/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.config;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.config.ConfigUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.SparseVector;
import org.nuiton.math.matrix.Vector;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ConfigHandler {
    private static Log log = LogFactory.getLog(ConfigHandler.class);
    protected ConfigUI configUI;
    protected Reflections reflections = new Reflections(MatrixND.class.getPackage().getName(), new Scanner[0]);

    public ConfigHandler(ConfigUI configUI) {
        this.configUI = configUI;
    }

    public void afterInit() {
        this.setupConfigFileLocation();
        this.fillCurrentConfig();
    }

    protected void setupConfigFileLocation() {
        File file = IsisFish.config.getUserConfigFile();
        this.configUI.isisConfigFileLocationLabel.setText(I18n.t((String)"isisfish.simulator.configuration.configFileLocation", (Object[])new Object[]{file.getAbsolutePath()}));
    }

    protected void fillCurrentConfig() {
        IsisConfig config = IsisFish.config;
        this.configUI.isisHomeDirectoryField.setText(StringUtils.stripToEmpty((String)config.getIsisHomeDirectory()));
        this.configUI.localeCombo.setSelectedItem(config.getLocale().toString());
        this.configUI.simulationInMaxThreadsField.setText(String.valueOf(config.getSimulatorInMaxThreads()));
        this.configUI.simulationSubMaxProcessField.setText(String.valueOf(config.getSimulatorSubMaxProcess()));
        this.configUI.simulationSubMaxMemoryField.setText(StringUtils.stripToEmpty((String)config.getSimulatorSubMaxMemory()));
        ArrayList vectors = new ArrayList(this.reflections.getSubTypesOf(Vector.class));
        List fullVectors = vectors.stream().filter(c -> !SparseVector.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toList());
        List sparseVectors = vectors.stream().filter(c -> !c.isInterface()).filter(SparseVector.class::isAssignableFrom).collect(Collectors.toList());
        this.configUI.matrixVectorClassField.setModel(new GenericComboModel(fullVectors));
        this.configUI.matrixVectorClassField.setSelectedItem(config.getSimulationMatrixVectorClass());
        this.configUI.matrixVectorSparseClassField.setModel(new GenericComboModel(sparseVectors));
        this.configUI.matrixVectorSparseClassField.setSelectedItem(config.getSimulationMatrixVectorSparseClass());
        this.configUI.matrixVectorThresholdField.setText(String.valueOf(config.getSimulationMatrixThresholdUseSparse()));
        this.configUI.matrixVectorLazyVectorField.setSelected(config.getSimulationMatrixdUseLazyVector());
        this.configUI.matrixStoreResultOnDiskField.setText(String.valueOf(config.getSimulationStoreResultOnDisk()));
        this.configUI.matrixStoreResultCacheStepField.setText(String.valueOf(config.getSimulationStoreResultCacheStep()));
        this.configUI.exportForceCompressionField.setSelected(config.getExportForceCompression());
        this.configUI.vcsUsernameField.setText(StringUtils.stripToEmpty((String)config.getVcsUserName()));
        this.configUI.vcsPasswordField.setText(StringUtils.stripToEmpty((String)config.getVcsUserPassword()));
        this.configUI.vcsCommunityUsernameField.setText(StringUtils.stripToEmpty((String)config.getVcsCommunityUserName()));
        this.configUI.vcsCommunityPasswordField.setText(StringUtils.stripToEmpty((String)config.getVcsCommunityUserPassword()));
    }

    protected void saveCurrentConfig() {
        IsisConfig config = IsisFish.config;
        config.setIsisHomeDirectory(StringUtils.trimToNull((String)this.configUI.isisHomeDirectoryField.getText()));
        config.setLocale((String)this.configUI.localeCombo.getSelectedItem());
        config.setSimulatorInMaxThreads(Integer.parseInt(this.configUI.simulationInMaxThreadsField.getText()));
        config.setSimulatorSubMaxProcess(Integer.parseInt(this.configUI.simulationSubMaxProcessField.getText()));
        config.setSimulatorSubMaxMemory(StringUtils.trimToNull((String)this.configUI.simulationSubMaxMemoryField.getText()));
        config.setSimulationMatrixVectorClass((Class)this.configUI.matrixVectorClassField.getSelectedItem());
        config.setSimulationMatrixVectorSparseClass((Class)this.configUI.matrixVectorSparseClassField.getSelectedItem());
        config.setSimulationMatrixThresholdUseSparse(Integer.parseInt(this.configUI.matrixVectorThresholdField.getText()));
        config.setSimulationMatrixdUseLazyVector(this.configUI.matrixVectorLazyVectorField.isSelected());
        config.setSimulationStoreResultOnDisk(Integer.parseInt(this.configUI.matrixStoreResultOnDiskField.getText()));
        config.setSimulationStoreResultCacheStep(Integer.parseInt(this.configUI.matrixStoreResultCacheStepField.getText()));
        config.setExportForceCompression(this.configUI.exportForceCompressionField.isSelected());
        config.setVcsUserName(StringUtils.trimToNull((String)this.configUI.vcsUsernameField.getText()));
        config.setVcsUserPassword(StringUtils.trimToNull((String)this.configUI.vcsPasswordField.getText()));
        config.setVcsCommunityUserName(StringUtils.trimToNull((String)this.configUI.vcsCommunityUsernameField.getText()));
        config.setVcsCommunityUserPassword(StringUtils.trimToNull((String)this.configUI.vcsCommunityPasswordField.getText()));
        config.saveForUser(new String[0]);
    }

    public void cancel() {
        this.configUI.dispose();
    }

    public void save() {
        try {
            this.saveCurrentConfig();
            this.configUI.dispose();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.configUI, I18n.t((String)"isisfish.simulator.configuration.cantParseConfig", (Object[])new Object[0]), I18n.t((String)"isisfish.simulator.configuration.error", (Object[])new Object[0]), 0);
        }
    }
}

