/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.result.ResultInfoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.launcher.SimulationExecutor;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationPlanPrepareJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationQueue;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorHelper;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.DependencyUtil;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ListenerSet;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.ZipUtil;

public class SimulationService {
    public static final String SIMULATION_LAUNCHER = "simulation.launcher";
    public static final int MAX_PLAN_SIMULATION = 20000;
    private static Log log = LogFactory.getLog(SimulationService.class);
    protected static SimulationService instance = new SimulationService();
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    protected ListenerSet<SimulationServiceListener> listeners = new ListenerSet();
    protected boolean autoLaunch = true;
    protected ExecutorService subSimulationComputationExecutor = Executors.newSingleThreadExecutor();
    protected Map<SimulatorLauncher, SimulationExecutor> executors = new LinkedHashMap<SimulatorLauncher, SimulationExecutor>();
    protected Map<SimulatorLauncher, MutableInt> launcherError = new HashMap<SimulatorLauncher, MutableInt>();
    protected SimulationQueue queue = new SimulationQueue();
    protected Set<String> idJobs = new HashSet<String>();
    protected Set<SimulationJob> jobs = new TreeSet<SimulationJob>();
    protected Set<SimulationJob> jobDones = new TreeSet<SimulationJob>();

    public static SimulationService getService() {
        return instance;
    }

    protected SimulationService() {
        Properties prop = IsisFish.config.getOptionStartsWith(SIMULATION_LAUNCHER);
        ArrayList<String> simulationKeys = new ArrayList<String>(prop.stringPropertyNames());
        Collections.sort(simulationKeys);
        for (String key : simulationKeys) {
            String value = prop.getProperty(key);
            try {
                SimulatorLauncher sl = (SimulatorLauncher)ObjectUtil.newInstance((String)value);
                this.addSimulationLauncher(sl);
            }
            catch (Exception eee) {
                log.warn((Object)I18n.t((String)"Can't instantiate %s", (Object[])new Object[]{value}), (Throwable)eee);
            }
        }
    }

    public void addSimulationLauncher(SimulatorLauncher sl) {
        SimulationQueue executorQueue = new SimulationQueue(this.queue);
        SimulationExecutor se = new SimulationExecutor(this, sl, executorQueue);
        this.executors.put(sl, se);
        this.launcherError.put(sl, new MutableInt(0));
    }

    public List<SimulatorLauncher> getSimulationLaunchers() {
        ArrayList<SimulatorLauncher> result = new ArrayList<SimulatorLauncher>(this.executors.keySet());
        return result;
    }

    public Collection<SimulationExecutor> getSimulationExecutors() {
        return this.executors.values();
    }

    public synchronized Set<SimulationJob> getJobs() {
        return this.jobs;
    }

    public synchronized Set<SimulationJob> getJobDones() {
        return this.jobDones;
    }

    protected Set<SimulatorLauncher> getSimulatorLaunchers() {
        return this.executors.keySet();
    }

    public void addSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.add((Object)l);
    }

    public void removeSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    protected synchronized void fireStartEvent(SimulationJob job) {
        if (this.jobs.add(job)) {
            this.idJobs.add(job.getItem().getControl().getId());
            for (SimulationServiceListener l : this.listeners) {
                l.simulationStart(this, job);
            }
        }
    }

    protected synchronized void fireStopEvent(SimulationJob job) {
        this.jobs.remove(job);
        this.idJobs.remove(job.getItem().getControl().getId());
        this.jobDones.add(job);
        for (SimulationServiceListener l : this.listeners) {
            l.simulationStop(this, job);
        }
    }

    public void clearJobDone() {
        this.jobDones.clear();
        for (SimulationServiceListener l : this.listeners) {
            l.clearJobDone(this);
        }
    }

    public boolean isAutoLaunch() {
        return this.autoLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLaunch(boolean autoLaunch) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            boolean oldValue = this.autoLaunch;
            this.autoLaunch = autoLaunch;
            if (this.autoLaunch) {
                this.notifyAll();
            }
            this.propertyListeners.firePropertyChange("autoLaunch", oldValue, autoLaunch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAutoLaunch(SimulationJob job) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            while (!this.isAutoLaunch()) {
                try {
                    log.info((Object)"autoLaunch is false waiting queue start");
                    job.getItem().getControl().setText(I18n.t((String)"Pause", (Object[])new Object[0]));
                    this.wait();
                }
                catch (InterruptedException eee) {
                    log.warn((Object)"Error during wait autoLaunch flag", (Throwable)eee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority) {
        SimulationParameter localParameters = param.deepCopy();
        localParameters.setIsisFishVersion(IsisConfig.getVersion());
        SimulationControl control = new SimulationControl(id);
        SimulationItem item = new SimulationItem(control, localParameters);
        SimulationJob job = new SimulationJob(this, item, priority);
        job.setLauncher(launcher);
        this.fireStartEvent(job);
        SimulationPlanPrepareJob task = null;
        if (localParameters.getUseSimulationPlan()) {
            try {
                SimulationLoggerUtil.setPlanLoggingContext(id);
                task = new SimulationPlanPrepareJob(this, job);
            }
            finally {
                SimulationLoggerUtil.clearPlanLoggingContext();
            }
        }
        File zip = this.prepareSimulationZipFile(localParameters, null, control, null, null);
        item.setSimulationZip(zip);
        if (localParameters.getUseSimulationPlan() && localParameters.isIndependentPlan()) {
            this.subSimulationComputationExecutor.execute(task);
        } else {
            this.submit(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority, SensitivityAnalysis sensitivityAnalysis, DesignPlan designPlan) {
        SimulationParameter localParameters = param.deepCopy();
        localParameters.setIsisFishVersion(IsisConfig.getVersion());
        try {
            SensitivityScenarios sensitivityScenarios;
            File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), id);
            if (!masterExportDirectory.isDirectory()) {
                masterExportDirectory.mkdirs();
            }
            String xmlDesignPlan = MexicoHelper.getDesignPlanAsXML(designPlan, new String[0]);
            RegionStorage regionStorage = RegionStorage.getRegion(param.getRegionName());
            TopiaContext context = null;
            try {
                context = regionStorage.getStorage().beginTransaction();
                this.fillDesignPlanNominalValue(context, designPlan);
            }
            finally {
                if (context != null) {
                    context.closeContext();
                }
            }
            try {
                SimulationLoggerUtil.setPlanLoggingContext(id);
                sensitivityScenarios = sensitivityAnalysis.compute(designPlan, masterExportDirectory);
            }
            finally {
                SimulationLoggerUtil.clearPlanLoggingContext();
            }
            localParameters.setSensitivityAnalysis(sensitivityAnalysis);
            localParameters.setNumberOfSensitivitySimulation(sensitivityScenarios.getScenarios().size());
            SimulationControl controlJustForZip = new SimulationControl(id);
            File zip = this.prepareSimulationZipFile(localParameters, null, controlJustForZip, xmlDesignPlan, sensitivityScenarios);
            int simulationIndex = 0;
            for (Scenario scenario : sensitivityScenarios.getScenarios()) {
                SimulationParameter subParam = localParameters.copy();
                String generatedScriptContent = FactorHelper.generatePreScript(scenario);
                subParam.setGeneratedPreScript(generatedScriptContent);
                String subsimulationId = id + "_" + simulationIndex;
                SimulationControl realSimulationControl = new SimulationControl(subsimulationId);
                SimulationItem item = new SimulationItem(realSimulationControl, subParam);
                item.setSimulationZip(zip);
                item.setStandaloneSimulation(false);
                item.setStandaloneSimulationZip(false);
                item.setSimulationNumber(simulationIndex);
                item.setLastSimulation(simulationIndex == sensitivityScenarios.getScenarios().size() - 1);
                SimulationJob job = new SimulationJob(this, item, priority);
                job.setLauncher(launcher);
                this.fireStartEvent(job);
                if (subParam.getUseSimulationPlan() && subParam.isIndependentPlan()) {
                    SimulationPlanPrepareJob task = new SimulationPlanPrepareJob(this, job);
                    this.subSimulationComputationExecutor.execute(task);
                } else {
                    this.submit(job);
                }
                ++simulationIndex;
            }
        }
        catch (Exception e) {
            throw new IsisFishRuntimeException("Can't get scenarios from calculator", e);
        }
    }

    protected void fillDesignPlanNominalValue(TopiaContext context, DesignPlan designPlan) {
        for (Factor factor : designPlan.getFactors()) {
            String path = factor.getPath();
            if (StringUtils.contains((CharSequence)path, (CharSequence)"#")) {
                String topiaId = path.substring(0, path.lastIndexOf("#"));
                String propertyName = path.substring(path.lastIndexOf("#") + 1);
                try {
                    TopiaEntity entity = context.findByTopiaId(topiaId);
                    String result = BeanUtils.getProperty((Object)entity, (String)propertyName);
                    factor.setNominalValue(result);
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An error occurred while trying to get nominal value", (Throwable)ex);
                    }
                }
            } else {
                factor.setNominalValue("NaN");
            }
            String name = SensitivityUtils.espaceFactorName(factor.getName());
            factor.setName(name);
        }
    }

    protected void submit(SimulationJob job) {
        SimulatorLauncher launcher = job.getLauncher();
        if (launcher != null) {
            for (SimulatorLauncher l : this.executors.keySet()) {
                if (launcher != l) continue;
                SimulationExecutor executor = this.executors.get(l);
                executor.execute(job);
                return;
            }
        }
        log.info((Object)I18n.t((String)"Add to default queue", (Object[])new Object[0]));
        this.queue.add(job);
    }

    protected void resubmit(SimulationJob job) {
        this.submit(job);
    }

    protected void submitSubJob(SimulationJob job) {
        this.submit(job);
    }

    public void submitForCheckOnly(SimulationJob job) {
        job.setOnlyCheckControl(true);
        this.fireStartEvent(job);
        this.submit(job);
    }

    public void restart(SimulationJob job) {
        job.getItem().setStandaloneSimulation(true);
        job.setOnlyCheckControl(false);
        job.getItem().getControl().reset();
        this.fireStartEvent(job);
        this.submit(job);
    }

    protected boolean cancel(SimulationJob job) {
        boolean result = this.queue.remove(job);
        return result;
    }

    public boolean exists(String id) {
        boolean result = this.idJobs.contains(id);
        return result;
    }

    protected void reportError(SimulatorLauncher launcher, SimulationJob job) {
        MutableInt i = this.launcherError.get(launcher);
        i.setValue(i.intValue() + 1);
        if (i.intValue() >= 50) {
            log.error((Object)I18n.t((String)"Launcher %s will be stopped because there are too many error (%s)", (Object[])new Object[]{launcher, i.intValue()}));
            SimulationExecutor e = this.executors.get(launcher);
            e.pause();
            i.setValue(0);
        }
        try {
            Thread.sleep(i.intValue() / 5 * 60 * 1000);
        }
        catch (InterruptedException eee) {
            log.info((Object)"Can't sleep before resubmit job, never mind", (Throwable)eee);
        }
        this.resubmit(job);
    }

    public File prepareSimulationZipFile(SimulationParameter param, File outputZilFile, SimulationControl control, String xmlDesignPlan, SensitivityScenarios sensitivityScenarios) throws SimulationException {
        try {
            Optimization optimization;
            Object name;
            File tmpDirectory = IsisFileUtil.createTempDirectory("isisfish-simulation-", "-preparation");
            Properties prop = param.toProperties();
            File f = new File(tmpDirectory, "parameters.properties");
            try (FileOutputStream out = new FileOutputStream(f);){
                prop.store(out, "Parameters");
            }
            if (control != null) {
                control.setText(I18n.t((String)"isisfish.message.backup.database.progress", (Object[])new Object[0]));
            }
            File regionBackup = new File(tmpDirectory, "data-backup.sql.gz");
            RegionStorage region = RegionStorage.getRegion(param.getRegionName());
            TopiaContext tc = region.getStorage().beginTransaction();
            tc.backup(regionBackup, true);
            tc.closeContext();
            if (control != null) {
                control.setText(I18n.t((String)"isisfish.message.backup.database.finished", (Object[])new Object[0]));
            }
            HashSet<String> necessaryResults = new HashSet<String>();
            List<Rule> rules = param.getRules();
            if (sensitivityScenarios != null) {
                for (Scenario scenario : sensitivityScenarios.getScenarios()) {
                    List<Factor> factors = scenario.getFactors();
                    for (Factor factor : factors) {
                        Domain domain = factor.getDomain();
                        if (!(domain instanceof RuleDiscreteDomain)) continue;
                        rules.addAll((List)factor.getValue());
                    }
                }
            }
            for (Rule rule : rules) {
                String name22 = RuleStorage.getName(rule);
                File ruleFile = new File(RuleStorage.getRuleDirectory(), name22 + ".java");
                if (!ruleFile.isFile()) {
                    ruleFile = new File(RuleStorage.getCommunityRuleDirectory(), name22 + ".java");
                }
                FileUtils.copyFile((File)ruleFile, (File)new File(tmpDirectory, "rules" + File.separator + name22 + ".java"));
                if (rule.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, rule.getNecessaryResult());
            }
            for (String string : param.getExtraRules()) {
                RuleStorage ruleStorage = RuleStorage.getRule(string, new CodeSourceStorage.Location[0]);
                Rule rule = (Rule)ruleStorage.getNewInstance();
                File ruleFile = new File(RuleStorage.getRuleDirectory(), string + ".java");
                if (!ruleFile.isFile()) {
                    ruleFile = new File(RuleStorage.getCommunityRuleDirectory(), string + ".java");
                }
                FileUtils.copyFile((File)ruleFile, (File)new File(tmpDirectory, "rules" + File.separator + string + ".java"));
                if (rule.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, rule.getNecessaryResult());
            }
            List<SimulationPlan> plans = param.getSimulationPlans();
            for (SimulationPlan plan : plans) {
                name = SimulationPlanStorage.getName(plan);
                File planFile = new File(SimulationPlanStorage.getSimulationPlanDirectory(), (String)name + ".java");
                if (!planFile.isFile()) {
                    planFile = new File(SimulationPlanStorage.getCommunitySimulationPlanDirectory(), (String)name + ".java");
                }
                FileUtils.copyFile((File)planFile, (File)new File(tmpDirectory, "simulationplans" + File.separator + (String)name + ".java"));
                if (plan.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, plan.getNecessaryResult());
            }
            for (String name2 : param.getExportNames()) {
                ExportStorage exportStorage = ExportStorage.getExport(name2, new CodeSourceStorage.Location[0]);
                ExportInfo export = (ExportInfo)exportStorage.getNewInstance();
                name2 = name2.endsWith(".java") ? name2 : name2 + ".java";
                File exportFile = new File(ExportStorage.getExportDirectory(), name2);
                if (!exportFile.isFile()) {
                    exportFile = new File(ExportStorage.getCommunityExportDirectory(), name2);
                }
                FileUtils.copyFile((File)exportFile, (File)new File(tmpDirectory, "exports" + File.separator + name2));
                if (export.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, export.getNecessaryResult());
            }
            for (SensitivityExport sensitivity : param.getSensitivityExport()) {
                name = SensitivityExportStorage.getName(sensitivity);
                name = ((String)name).endsWith(".java") ? name : (String)name + ".java";
                File sensitivityFile = new File(SensitivityExportStorage.getSensitivityExportDirectory(), (String)name);
                if (!sensitivityFile.isFile()) {
                    sensitivityFile = new File(SensitivityExportStorage.getCommunitySensitivityExportDirectory(), (String)name);
                }
                FileUtils.copyFile((File)sensitivityFile, (File)new File(tmpDirectory, "sensitivityexports" + File.separator + (String)name));
                if (sensitivity.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, sensitivity.getNecessaryResult());
            }
            Objective objective = param.getObjective();
            if (objective != null) {
                String name2;
                name2 = ObjectiveStorage.getName(objective);
                File objectiveFile = new File(ObjectiveStorage.getObjectiveDirectory(), name2 + ".java");
                if (!objectiveFile.isFile()) {
                    objectiveFile = new File(ObjectiveStorage.getCommunityObjectiveDirectory(), name2 + ".java");
                }
                FileUtils.copyFile((File)objectiveFile, (File)new File(tmpDirectory, "objectives" + File.separator + name2 + ".java"));
                if (objective.getNecessaryResult() != null) {
                    Collections.addAll(necessaryResults, objective.getNecessaryResult());
                }
            }
            if ((optimization = param.getOptimization()) != null) {
                name = OptimizationStorage.getName(optimization);
                File optimizationFile = new File(OptimizationStorage.getOptimizationDirectory(), (String)name + ".java");
                if (!optimizationFile.isFile()) {
                    optimizationFile = new File(OptimizationStorage.getCommunityOptimizationDirectory(), (String)name + ".java");
                }
                FileUtils.copyFile((File)optimizationFile, (File)new File(tmpDirectory, "optimizations" + File.separator + (String)name + ".java"));
                if (optimization.getNecessaryResult() != null) {
                    Collections.addAll(necessaryResults, optimization.getNecessaryResult());
                }
            }
            for (ExportInfo export : param.getOptimizationExportsObservations().keySet()) {
                Object name4 = ExportStorage.getName(export);
                if (param.getExportNames().contains(name4)) continue;
                name4 = ((String)name4).endsWith(".java") ? name4 : (String)name4 + ".java";
                File exportFile = new File(ExportStorage.getExportDirectory(), (String)name4);
                if (!exportFile.isFile()) {
                    exportFile = new File(ExportStorage.getCommunityExportDirectory(), (String)name4);
                }
                FileUtils.copyFile((File)exportFile, (File)new File(tmpDirectory, "exports" + File.separator + (String)name4));
                if (export.getNecessaryResult() == null) continue;
                Collections.addAll(necessaryResults, export.getNecessaryResult());
            }
            File simulatorFile = new File(SimulatorStorage.getSimulatorDirectory(), param.getSimulatorName());
            if (!simulatorFile.isFile()) {
                simulatorFile = new File(SimulatorStorage.getCommunitySimulatorDirectory(), param.getSimulatorName());
            }
            FileUtils.copyFile((File)simulatorFile, (File)new File(tmpDirectory, "simulators" + File.separator + param.getSimulatorName()));
            Set<String> allNecessaryResults = ResultInfoHelper.extractAllNecessaryResults(necessaryResults);
            for (String result : allNecessaryResults) {
                String filename = result.endsWith(".java") ? result : result + ".java";
                File resultFile = new File(ResultInfoStorage.getResultInfoDirectory(), filename);
                if (!resultFile.isFile()) {
                    resultFile = new File(ResultInfoStorage.getCommunityResultInfoDirectory(), filename);
                }
                FileUtils.copyFile((File)resultFile, (File)new File(tmpDirectory, "resultinfos" + File.separator + filename));
            }
            this.compileAllFile(control, tmpDirectory);
            if (!StringUtils.isEmpty((CharSequence)xmlDesignPlan)) {
                File simulationDesignPlanFile = SimulationStorage.getMexicoDesignPlan(tmpDirectory);
                FileUtils.writeStringToFile((File)simulationDesignPlanFile, (String)xmlDesignPlan, (String)"utf-8");
            }
            if (outputZilFile == null) {
                outputZilFile = new File(tmpDirectory.getPath() + ".zip");
                outputZilFile.deleteOnExit();
            }
            ZipUtil.compress((File)outputZilFile, (File)tmpDirectory, null);
            if (!FileUtils.deleteQuietly((File)tmpDirectory)) {
                log.warn((Object)I18n.t((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
            }
            return outputZilFile;
        }
        catch (IsisFishException | IOException | TopiaException eee) {
            throw new SimulationException(I18n.t((String)"isisfish.error.prepare.information.simulation", (Object[])new Object[0]), eee);
        }
    }

    protected void compileAllFile(SimulationControl control, File directory) throws IOException {
        String[] modules;
        if (control != null) {
            control.setText(I18n.t((String)"isisfish.simulation.message.scriptscompilation", (Object[])new Object[0]));
        }
        long currentTime = System.nanoTime();
        ArrayList<File> fileToCompile = new ArrayList<File>();
        ArrayList<File> fileToInpect = new ArrayList<File>();
        HashSet<String> dependencies = new HashSet<String>();
        for (String module : modules = new String[]{"exports", "rules", "sensitivityexports", "sensitivityanalysis", "scripts", "simulationplans", "simulators"}) {
            File moduleDir = new File(directory, module);
            List tmp = FileUtil.find((File)moduleDir, (String)".*\\.java$", (boolean)true);
            for (File srcFile : tmp) {
                fileToCompile.add(srcFile);
                File classFile = new File(srcFile.getAbsolutePath().replaceFirst("\\.java", ".class"));
                fileToInpect.add(classFile);
                dependencies.add(module + "." + FilenameUtils.getBaseName((String)srcFile.getName()));
            }
        }
        CompileHelper.compile(directory, fileToCompile, directory, null);
        Set<String> allDeps = DependencyUtil.extractDependencies(directory, fileToInpect);
        Collection missingDeps = CollectionUtils.subtract(allDeps, dependencies);
        for (String missingDep : missingDeps) {
            String relativePath = missingDep.replace('.', File.separatorChar) + ".java";
            File srcFile = new File(IsisFish.config.getContextDatabaseDirectory(), relativePath);
            if (!srcFile.isFile()) {
                srcFile = new File(IsisFish.config.getCommunityDatabaseDirectory(), missingDep.replace('.', File.separatorChar) + ".java");
            }
            File destFile = new File(directory, missingDep.replace('.', File.separatorChar) + ".java");
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        if (control != null) {
            long time = System.nanoTime() - currentTime;
            control.setText(I18n.t((String)"isisfish.message.compilation.time", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)(time / 1000000L), (String)"s'.'S")}));
        }
    }
}

