/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.types.Month;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.version.Versions;

public class SimulationParameterPropertiesHelper {
    private static final Log log = LogFactory.getLog(SimulationParameterPropertiesHelper.class);
    public static final String DOT = ".";
    public static final String LIST_SEPARATOR = ",";
    public static final String ISIS_FISH_VERSION_KEY = "isisFishVersion";
    public static final String SIMULATOR_NAME_KEY = "simulatorName";
    public static final String POPULATIONS_KEY = "populations";
    public static final String RULES_KEY = "rules";
    public static final String RULE_KEY = "rule";
    public static final String RESULT_NAMES_KEY = "resultNames";
    public static final String EXPORTS_KEY = "exports";
    public static final String PLANS_KEY = "plans";
    public static final String PLAN_KEY = "plan";
    public static final String STRATEGIES_KEY = "strategies";
    public static final String DESCRIPTION_KEY = "description";
    public static final String REGION_NAME_KEY = "regionName";
    public static final String USE_SIMULATION_PLAN_KEY = "useSimulationPlan";
    public static final String SIMULATION_PLAN_NUMBER_KEY = "simulationPlanNumber";
    public static final String USE_OPTIMIZATION_KEY = "useOptimization";
    public static final String OPTIMIZATION_KEY = "optimization";
    public static final String OPTIMIZATION_GENERATION_KEY = "optimizationGeneration";
    public static final String OPTIMIZATION_GENERATION_INDIVIDUAL_KEY = "optimizationGenerationIndividual";
    public static final String OBJECTIVE_KEY = "objective";
    public static final String OPTIMIZATION_EXPORTS_KEY = "optimizationexports";
    public static final String OPTIMIZATION_OBSERVATION_KEY = "optimizationobservation";
    public static final String USE_CACHE_KEY = "useCache";
    public static final String USE_STATISTIC_KEY = "useStatistic";
    public static final String USE_COMPUTE_RESULT_KEY = "useComputeResult";
    public static final String NUMBER_OF_YEAR_KEY = "numberOfYear";
    public static final String NUMBER_OF_MONTHS_KEY = "numberOfMonths";
    public static final String GENERATED_PRE_SCRIPT_KEY = "generatedPreScript";
    public static final String USE_PRE_SCRIPT_KEY = "usePreScript";
    public static final String PRE_SCRIPT_KEY = "preScript";
    public static final String SIMUL_LOG_LEVEL_KEY = "simulLogLevel";
    public static final String SCRIPT_LOG_LEVEL_KEY = "scriptLogLevel";
    public static final String LIB_LOG_LEVEL_KEY = "libLogLevel";
    public static final String SENSITIVITY_ANALYSIS_KEY = "sensitivityanalysis";
    public static final String SENSITIVITY_KEY = "sensitivity";
    public static final String SENSITIVITY_EXPORTS_KEY = "sensitivityexports";
    public static final String SENSITIVITY_EXPORT_KEY = "sensitivityexport";
    public static final String POPULATION_KEY = "population";
    public static final String NUMBER_KEY = "number";
    public static final String NUMBER_OF_SENSITIVITY_SIMULATION_KEY = "numberOfSensitivitySimulation";
    public static final String SENSITIVITY_ANALYSIS_ONLY_KEEP_FIRST_KEY = "sensitivityAnalysisOnlyKeepFirst";
    public static final String RESULT_DELETE_AFTER_EXPORT_KEY = "resultDeleteAfterExport";
    public static final String TAG_VALUE_KEY = "tagValue";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String PARAMETER_KEY = "parameter";

    public static String getIsisFishVersion(Properties prop) {
        String result = prop.getProperty(ISIS_FISH_VERSION_KEY, "");
        return result;
    }

    public static String getSimulatorName(Properties prop) {
        String result = prop.getProperty(SIMULATOR_NAME_KEY, "DefaultSimulator.java");
        return result;
    }

    public static String getDescription(Properties prop) {
        String result = prop.getProperty(DESCRIPTION_KEY, "");
        return result;
    }

    public static boolean getUseSimulationPlan(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(USE_SIMULATION_PLAN_KEY, "false"));
        return result;
    }

    public static int getSimulationPlanNumber(Properties prop) {
        int result = Integer.parseInt(prop.getProperty(SIMULATION_PLAN_NUMBER_KEY, "-1"));
        return result;
    }

    public static int getOptimizationGeneration(Properties prop) {
        int result = Integer.parseInt(prop.getProperty(OPTIMIZATION_GENERATION_KEY, "-1"));
        return result;
    }

    public static int getOptimizationGenerationIndividual(Properties prop) {
        int result = Integer.parseInt(prop.getProperty(OPTIMIZATION_GENERATION_INDIVIDUAL_KEY, "-1"));
        return result;
    }

    public static boolean getUseCache(Properties prop) {
        boolean result = Versions.smallerThan((String)SimulationParameterPropertiesHelper.getIsisFishVersion(prop), (String)"4.3.0.0") ? Boolean.parseBoolean(prop.getProperty(USE_OPTIMIZATION_KEY, "true")) : Boolean.parseBoolean(prop.getProperty(USE_CACHE_KEY, "true"));
        return result;
    }

    public static int getNumberOfMonths(Properties prop) {
        int result;
        String propValue = prop.getProperty(NUMBER_OF_MONTHS_KEY);
        if (propValue == null) {
            propValue = prop.getProperty(NUMBER_OF_YEAR_KEY, "1");
            result = Integer.parseInt(propValue) * Month.NUMBER_OF_MONTH;
        } else {
            result = Integer.parseInt(propValue);
        }
        return result;
    }

    public static String getRegionName(Properties prop) {
        String result = prop.getProperty(REGION_NAME_KEY, "");
        return result;
    }

    public static String[] getPopulationNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(POPULATIONS_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static List getPopulationNumbers(Properties prop, String popName) {
        String numberAsString = prop.getProperty("population." + popName + DOT + NUMBER_KEY);
        List result = MatrixHelper.convertStringToList((String)numberAsString);
        return result;
    }

    public static String[] getStrategieNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(STRATEGIES_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static String[] getRuleNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(RULES_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static String[] getResultNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(RESULT_NAMES_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static String[] getExportNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(EXPORTS_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static String[] getSimulationPlanNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(PLANS_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static boolean getUseOptimization(Properties prop) {
        boolean result = Versions.smallerThan((String)SimulationParameterPropertiesHelper.getIsisFishVersion(prop), (String)"4.3.0.0") ? Boolean.FALSE : Boolean.parseBoolean(prop.getProperty(USE_OPTIMIZATION_KEY, "false"));
        return result;
    }

    public static String getOptimizationName(Properties prop) {
        String result = prop.getProperty(OPTIMIZATION_KEY, "");
        return result;
    }

    public static String getObjectiveName(Properties prop) {
        String result = prop.getProperty(OBJECTIVE_KEY, "");
        return result;
    }

    public static String[] getOptimizationExportNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(OPTIMIZATION_EXPORTS_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static String getOptimizationObservationName(Properties prop, int index) {
        String result = prop.getProperty("optimizationobservation." + index, "");
        if (result.matches("[\\w.]+#[\\d.]+#[\\d.]+:(.+)")) {
            result = result.replaceFirst("[\\w.]+#[\\d.]+#[\\d.]+:(.+)", "$1");
        }
        return result;
    }

    public static String getSensitivityAnalysis(Properties prop) {
        String result = prop.getProperty(SENSITIVITY_ANALYSIS_KEY);
        return result;
    }

    public static String[] getSensitivityExportNames(Properties prop) {
        String[] result = StringUtils.split((String)prop.getProperty(SENSITIVITY_EXPORTS_KEY, ""), (String)LIST_SEPARATOR);
        return result;
    }

    public static int getNumberOfSensitivitySimulation(Properties prop) {
        int result = Integer.parseInt(prop.getProperty(NUMBER_OF_SENSITIVITY_SIMULATION_KEY, "-1"));
        return result;
    }

    public static boolean isSensitivityAnalysisOnlyKeepFirst(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(SENSITIVITY_ANALYSIS_ONLY_KEEP_FIRST_KEY, "false"));
        return result;
    }

    public static Boolean isResultDeleteAfterExport(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(RESULT_DELETE_AFTER_EXPORT_KEY, "false"));
        return result;
    }

    public static String getGeneratedPreScript(Properties prop) {
        String result = prop.getProperty(GENERATED_PRE_SCRIPT_KEY, "");
        return result;
    }

    public static boolean getUsePreScript(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(USE_PRE_SCRIPT_KEY, "false"));
        return result;
    }

    public static String getPreScript(Properties prop) {
        String result = prop.getProperty(PRE_SCRIPT_KEY, "");
        return result;
    }

    public static boolean getUseStatistic(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(USE_STATISTIC_KEY, "false"));
        return result;
    }

    public static boolean getUseComputeResult(Properties prop) {
        boolean result = Boolean.parseBoolean(prop.getProperty(USE_COMPUTE_RESULT_KEY, "false"));
        return result;
    }

    public static String getSimulLogLevel(Properties prop) {
        String result = prop.getProperty(SIMUL_LOG_LEVEL_KEY, "info");
        return result;
    }

    public static String getScriptLogLevel(Properties prop) {
        String result = prop.getProperty(SCRIPT_LOG_LEVEL_KEY, "info");
        return result;
    }

    public static String getLibLogLevel(Properties prop) {
        String result = prop.getProperty(LIB_LOG_LEVEL_KEY, "info");
        return result;
    }

    public static Map<String, String> getTagValue(Properties prop) {
        int tagValueLength = "tagValue.".length();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String k : prop.stringPropertyNames()) {
            if (!k.startsWith("tagValue.")) continue;
            String key = k.substring(tagValueLength);
            String value = prop.getProperty(k);
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, String> getParamAsString(Properties prop, String prefix, int index) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (prop != null) {
            String paramTag = prefix + DOT + index + DOT + PARAMETER_KEY + DOT;
            int paramTagLength = paramTag.length();
            for (String key : prop.stringPropertyNames()) {
                if (!StringUtils.startsWith((CharSequence)key, (CharSequence)paramTag)) continue;
                String paramName = key.substring(paramTagLength);
                String value = prop.getProperty(key);
                if (value.matches("[\\w.]+#[\\d.]+#[\\d.]+:(.+)")) {
                    value = value.replaceFirst("[\\w.]+#[\\d.]+#[\\d.]+:(.+)", "$1");
                }
                result.put(paramName, value);
            }
        }
        return result;
    }

    public static void copy(Properties source, Properties target, String prefix) {
        for (String key : source.stringPropertyNames()) {
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            target.setProperty(key, source.getProperty(key));
        }
    }

    public static String toString(Properties prop) {
        String prescript;
        String genScript;
        StringBuilder result = new StringBuilder();
        result.append(I18n.t((String)"isisfish.params.toString.simulation.done", (Object[])new Object[]{SimulationParameterPropertiesHelper.getIsisFishVersion(prop)})).append(" (").append(SimulationParameterPropertiesHelper.getSimulatorName(prop)).append(")").append('\n');
        result.append("--------------------\n");
        result.append(SimulationParameterPropertiesHelper.getDescription(prop)).append('\n');
        result.append("--------------------\n");
        if (SimulationParameterPropertiesHelper.getUseSimulationPlan(prop)) {
            result.append(I18n.t((String)"isisfish.params.toString.plan.number", (Object[])new Object[]{SimulationParameterPropertiesHelper.getSimulationPlanNumber(prop)}));
            result.append("\n");
        }
        result.append("\n");
        boolean useCache = SimulationParameterPropertiesHelper.getUseCache(prop);
        if (useCache) {
            result.append(I18n.t((String)"isisfish.params.toString.use.cache", (Object[])new Object[]{useCache}));
            result.append("\n");
        }
        result.append(I18n.t((String)"isisfish.params.toString.fishery", (Object[])new Object[]{SimulationParameterPropertiesHelper.getRegionName(prop)}));
        result.append("\n\n");
        result.append(I18n.t((String)"isisfish.params.toString.number.months", (Object[])new Object[]{SimulationParameterPropertiesHelper.getNumberOfMonths(prop)}));
        result.append("\n\n");
        String[] strs = SimulationParameterPropertiesHelper.getStrategieNames(prop);
        result.append(I18n.t((String)"isisfish.params.toString.strategies", (Object[])new Object[0]));
        String sep = "";
        for (String str : strs) {
            result.append(sep).append(str);
            sep = LIST_SEPARATOR;
        }
        result.append("\n\n");
        result.append(I18n.t((String)"isisfish.params.toString.populations", (Object[])new Object[0]));
        sep = "";
        for (String pop : SimulationParameterPropertiesHelper.getPopulationNames(prop)) {
            result.append(sep).append(pop);
            sep = LIST_SEPARATOR;
        }
        result.append("\n\n");
        int cpt = 0;
        for (String name : SimulationParameterPropertiesHelper.getRuleNames(prop)) {
            result.append(I18n.t((String)"isisfish.params.toString.rule", (Object[])new Object[]{name}));
            result.append('\n');
            for (Map.Entry<String, String> e : SimulationParameterPropertiesHelper.getParamAsString(prop, RULE_KEY, cpt++).entrySet()) {
                result.append("\t").append(e.getKey()).append(" : ").append(e.getValue()).append("\n");
            }
            result.append("\n");
        }
        result.append("\n\n");
        cpt = 0;
        for (String plan : SimulationParameterPropertiesHelper.getSimulationPlanNames(prop)) {
            result.append(I18n.t((String)"isisfish.params.toString.plan", (Object[])new Object[]{plan}));
            result.append('\n');
            for (Map.Entry<String, String> e : SimulationParameterPropertiesHelper.getParamAsString(prop, PLAN_KEY, cpt++).entrySet()) {
                result.append("\t").append(e.getKey()).append(" : ").append(e.getValue()).append("\n");
            }
            result.append('\n');
        }
        boolean useOptimization = SimulationParameterPropertiesHelper.getUseOptimization(prop);
        if (useOptimization) {
            String optimization;
            result.append(I18n.t((String)"isisfish.params.toString.use.optimization", (Object[])new Object[]{useOptimization}));
            result.append(" ").append(I18n.t((String)"isisfish.params.toString.optimization.generation", (Object[])new Object[]{SimulationParameterPropertiesHelper.getOptimizationGeneration(prop)}));
            result.append(" ").append(I18n.t((String)"isisfish.params.toString.optimization.generation.individual", (Object[])new Object[]{SimulationParameterPropertiesHelper.getOptimizationGenerationIndividual(prop)}));
            result.append("\n");
            String objective = SimulationParameterPropertiesHelper.getObjectiveName(prop);
            if (StringUtils.isNotBlank((CharSequence)objective)) {
                result.append(I18n.t((String)"isisfish.params.toString.objective", (Object[])new Object[]{objective}));
                result.append('\n');
                for (Map.Entry<String, String> e : SimulationParameterPropertiesHelper.getParamAsString(prop, OBJECTIVE_KEY, 0).entrySet()) {
                    result.append("\t").append(e.getKey()).append(" : ").append(e.getValue()).append("\n");
                }
                result.append('\n');
            }
            if (StringUtils.isNotBlank((CharSequence)(optimization = SimulationParameterPropertiesHelper.getOptimizationName(prop)))) {
                result.append(I18n.t((String)"isisfish.params.toString.optimization", (Object[])new Object[]{optimization}));
                result.append('\n');
                for (Map.Entry entry : SimulationParameterPropertiesHelper.getParamAsString(prop, OPTIMIZATION_KEY, 0).entrySet()) {
                    result.append("\t").append((String)entry.getKey()).append(" : ").append((String)entry.getValue()).append("\n");
                }
                result.append('\n');
            }
            cpt = 0;
            for (String export : SimulationParameterPropertiesHelper.getOptimizationExportNames(prop)) {
                String observation = SimulationParameterPropertiesHelper.getOptimizationObservationName(prop, cpt++);
                result.append(I18n.t((String)"isisfish.params.toString.optimizationExport", (Object[])new Object[]{export}));
                if (StringUtils.isNotBlank((CharSequence)observation)) {
                    result.append("\t->").append(I18n.t((String)"isisfish.params.toString.optimizationObservation", (Object[])new Object[]{observation}));
                }
                result.append('\n');
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(genScript = SimulationParameterPropertiesHelper.getGeneratedPreScript(prop)))) {
            result.append('\n');
            result.append(I18n.t((String)"isisfish.params.toString.script.generatedpresimulation", (Object[])new Object[0])).append(":\n");
            result.append(genScript);
        }
        if (SimulationParameterPropertiesHelper.getUsePreScript(prop) && StringUtils.isNotBlank((CharSequence)(prescript = SimulationParameterPropertiesHelper.getPreScript(prop)))) {
            result.append('\n');
            result.append(I18n.t((String)"isisfish.params.toString.script.presimulation", (Object[])new Object[0])).append(":\n");
            result.append(prescript);
        }
        result.append('\n');
        result.append(I18n.t((String)"isisfish.params.toString.simul.logger.level", (Object[])new Object[]{SimulationParameterPropertiesHelper.getSimulLogLevel(prop)}));
        result.append('\n');
        result.append(I18n.t((String)"isisfish.params.toString.script.logger.level", (Object[])new Object[]{SimulationParameterPropertiesHelper.getScriptLogLevel(prop)}));
        result.append('\n');
        result.append(I18n.t((String)"isisfish.params.toString.lib.logger.level", (Object[])new Object[]{SimulationParameterPropertiesHelper.getLibLogLevel(prop)}));
        result.append('\n');
        return result.toString();
    }

    public static void removeProperties(Properties prop, String ... propNames) {
        Stream.of(propNames).forEach(prop::remove);
    }

    public static void removePropertiesStartingWith(Properties prop, String ... propNames) {
        Set<String> strings = prop.stringPropertyNames();
        strings.stream().filter(p -> StringUtils.startsWithAny((CharSequence)p, (CharSequence[])propNames)).forEach(prop::remove);
    }
}

