/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.export;

import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.mexico.export.RegionExport;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

public class RegionExportFactorXML
implements RegionExport {
    private static Log log = LogFactory.getLog(RegionExportFactorXML.class);
    protected File outputFile;
    protected StringBuffer stringBuffer;
    protected String lastReadName;

    public RegionExportFactorXML(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void beginExport() {
        this.stringBuffer = new StringBuffer();
        this.stringBuffer.append("<regionFactors>");
        this.stringBuffer.append("<factors>");
    }

    public void start(TopiaEntity entity) {
        this.lastReadName = null;
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
        if ("name".equals(propertyName)) {
            this.lastReadName = (String)value;
        }
        String factorClass = entity.getClass().getSimpleName();
        factorClass = factorClass.replaceFirst("Impl", "");
        String factorName = factorClass + "." + propertyName;
        boolean enabled = SensitivityUtils.isSensitivityFactorEnabled(factorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing if attribute (" + factorName + ") is factor enabled : " + enabled));
        }
        if (enabled) {
            String exportFactorName = this.getUniqueFactorName(entity, factorClass, propertyName);
            String stringValue = this.getStringValue(entity, type, value);
            this.stringBuffer.append("<!-- " + factorName + " -->");
            this.stringBuffer.append("<factor name=\"" + exportFactorName + "\"");
            this.stringBuffer.append(" type=\"" + type.getSimpleName() + "\"");
            this.stringBuffer.append(">");
            this.stringBuffer.append("<target>" + entity.getTopiaId() + "#" + propertyName + "</target>");
            this.stringBuffer.append("<value>" + stringValue + "</value>");
            this.stringBuffer.append("</factor>");
        }
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        this.visit(entity, propertyName, type, value);
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
    }

    public void end(TopiaEntity entity) {
    }

    public void clear() {
    }

    @Override
    public void endExport() {
        block2: {
            this.stringBuffer.append("</factors>");
            this.stringBuffer.append("</regionFactors>");
            String xml = MexicoHelper.formatXML(this.stringBuffer.toString());
            try {
                FileUtils.writeStringToFile((File)this.outputFile, (String)xml, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't wrtie xml content to output file", (Throwable)ex);
            }
        }
    }

    protected String getUniqueFactorName(TopiaEntity entity, String factorClass, String propertyName) {
        String exportFactorName = null;
        if (this.lastReadName != null) {
            exportFactorName = factorClass + "." + this.lastReadName + "." + propertyName;
        } else if (entity instanceof EffortDescription) {
            EffortDescription newEntity = (EffortDescription)entity;
            exportFactorName = factorClass + ".";
            exportFactorName = exportFactorName + RandomStringUtils.randomAlphanumeric((int)8);
            exportFactorName = exportFactorName + "." + newEntity.getPossibleMetiers() + "." + propertyName;
        } else if (entity instanceof PopulationGroup) {
            PopulationGroup newEntity = (PopulationGroup)entity;
            exportFactorName = factorClass + "." + newEntity.getPopulation().getName();
            exportFactorName = exportFactorName + "." + newEntity.getId() + "." + propertyName;
        } else if (entity instanceof PopulationSeasonInfo) {
            PopulationSeasonInfo newEntity = (PopulationSeasonInfo)entity;
            exportFactorName = factorClass + "." + newEntity.getPopulation().getName() + ".";
            exportFactorName = exportFactorName + newEntity.getFirstMonth() + "." + newEntity.getLastMonth() + "." + propertyName;
        } else if (entity instanceof StrategyMonthInfo) {
            StrategyMonthInfo newEntity = (StrategyMonthInfo)entity;
            exportFactorName = factorClass + "." + newEntity.getStrategy().getName() + ".";
            exportFactorName = exportFactorName + newEntity.getMonth() + "." + propertyName;
        } else if (entity instanceof Selectivity) {
            Selectivity newEntity = (Selectivity)entity;
            exportFactorName = factorClass + "." + newEntity.getGear().getName();
            exportFactorName = exportFactorName + "." + newEntity.getPopulation().getName() + "." + propertyName;
        } else if (entity instanceof TargetSpecies) {
            TargetSpecies newEntity = (TargetSpecies)entity;
            exportFactorName = factorClass + "." + newEntity.getSpecies().getName() + ".";
            exportFactorName = exportFactorName + newEntity.getMetierSeasonInfo().getFirstMonth() + "." + newEntity.getMetierSeasonInfo().getLastMonth();
            exportFactorName = exportFactorName + "." + propertyName + "." + RandomStringUtils.randomAlphanumeric((int)8);
        }
        return exportFactorName;
    }

    protected String getStringValue(TopiaEntity entity, Class<?> type, Object value) {
        String result = null;
        if (type.isAssignableFrom(TimeUnit.class)) {
            result = String.valueOf(((TimeUnit)value).getTime());
        } else if (type.isAssignableFrom(MatrixND.class)) {
            result = MexicoHelper.getMatrixAsXML((MatrixND)value);
        } else if (type.isAssignableFrom(RangeOfValues.class)) {
            result = String.valueOf(((RangeOfValues)value).getValues());
        } else if (type.isAssignableFrom(Equation.class)) {
            if (value != null) {
                result = String.valueOf(((Equation)value).getContent());
                result = StringEscapeUtils.escapeXml11((String)result);
            }
        } else if (value != null) {
            result = value.toString();
        }
        return result;
    }
}

