/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import com.opencsv.CSVWriter;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public class RegionChangeLogger
implements TopiaEntityListener {
    protected static final char CSV_SEPARATOR = ';';
    protected static final String CHANGES_FILE_NAME = "changes.csv";
    protected RegionStorage regionStorage;
    protected TopiaContext context;
    protected File logFile;

    public RegionChangeLogger(RegionStorage regionStorage, TopiaContext context) {
        this.regionStorage = regionStorage;
        this.context = context;
        this.logFile = new File(regionStorage.getDirectory(), CHANGES_FILE_NAME);
    }

    public void create(TopiaEntityEvent event) {
        this.addLogLine("CREATE", event.getEntity().getClass(), event.getEntity());
    }

    public void load(TopiaEntityEvent event) {
    }

    public void update(TopiaEntityEvent event) {
        if (ArrayUtils.isNotEmpty((int[])event.getDirtyProperties())) {
            Class<?> clazz = event.getEntity().getClass();
            SessionFactory sesionFactory = ((TopiaContextImpl)this.context).getHibernateFactory();
            ClassMetadata classMetadata = sesionFactory.getClassMetadata(clazz);
            String[] propertyNames = classMetadata.getPropertyNames();
            for (int dirtyProperty : event.getDirtyProperties()) {
                String newValueString;
                String fieldName = propertyNames[dirtyProperty];
                Object oldValue = event.getOldState()[dirtyProperty];
                String oldValueString = oldValue != null ? oldValue.toString() : "";
                Object newValue = event.getState()[dirtyProperty];
                String string = newValueString = newValue != null ? newValue.toString() : "";
                if (StringUtils.equals((CharSequence)oldValueString, (CharSequence)newValueString)) continue;
                this.addLogLine("UPDATE", clazz, event.getEntity(), fieldName, oldValueString, newValueString);
            }
        }
    }

    public void delete(TopiaEntityEvent event) {
        this.addLogLine("DELETE", event.getEntity().getClass(), event.getEntity());
    }

    protected void addLogLine(String changeType, Class<? extends TopiaEntity> clazz, Object entity) {
        this.addLogLine(changeType, clazz, entity, "", "", "");
    }

    protected void addLogLine(String changeType, Class<? extends TopiaEntity> clazz, Object entity, String field, String oldValue, String newValue) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyy/MM/dd HH:mm:ss");
        String entityDisplayInfo = this.getEntityDisplayInfo(entity);
        this.addLine(date, changeType, clazz.getSimpleName().replace("Impl", ""), entityDisplayInfo, field, oldValue, newValue);
    }

    protected void addLine(String ... data) {
        boolean fileExists = this.logFile.length() > 0L;
        try (CSVWriter out = new CSVWriter((Writer)new BufferedWriter(new FileWriter(this.logFile, true)), ';', '\"', '\"', "\n");){
            if (!fileExists) {
                out.writeNext(new String[]{"date", "type", "entity", "name", "field", "oldvalue", "newvalue"});
            }
            out.writeNext(data);
        }
        catch (IOException ex) {
            throw new IsisFishRuntimeException("Can't write log file", ex);
        }
    }

    protected String getEntityDisplayInfo(Object entity) {
        String result;
        try {
            result = BeanUtils.getProperty((Object)entity, (String)"name");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            result = entity.toString();
        }
        return result;
    }
}

