/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSException;
import fr.ifremer.isisfish.vcs.VCSNone;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.version.Version;

public abstract class VersionStorage {
    private static final Log log = LogFactory.getLog(VersionStorage.class);
    protected File root = null;
    protected File file = null;

    protected static void registerWatcher(Collection<StorageChangeListener> storageListeners, File ... directories) {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            for (File dir : directories) {
                Path path = dir.toPath();
                path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            new Thread(() -> {
                WatchKey key;
                boolean valid;
                do {
                    try {
                        key = watchService.take();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException x) {
                        return;
                    }
                    StorageChangeEvent.Type typeEvent = null;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                            typeEvent = StorageChangeEvent.Type.ADDED;
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            typeEvent = StorageChangeEvent.Type.MODIFIED;
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        typeEvent = StorageChangeEvent.Type.DELETED;
                    }
                    if (typeEvent == null) continue;
                    StorageChangeEvent storageEvent = new StorageChangeEvent(typeEvent);
                    for (StorageChangeListener storageListener : storageListeners) {
                        storageListener.dataChanged(storageEvent);
                    }
                } while (valid = key.reset());
            }).start();
        }
        catch (IOException e) {
            throw new IsisFishRuntimeException("Can't register watcher", e);
        }
    }

    protected VersionStorage(File root, File file) {
        this.root = root;
        this.file = file;
    }

    protected static File getContextDatabaseDirectory() {
        return IsisFish.config.getContextDatabaseDirectory();
    }

    protected static File getCommunityDatabaseDirectory() {
        return IsisFish.config.getCommunityDatabaseDirectory();
    }

    protected VCS getCurrentVCS() {
        return this.getCurrentVCS(this.getFile());
    }

    protected VCS getCurrentVCS(File file) {
        String absolutePath = file.getAbsolutePath();
        VCS result = absolutePath.startsWith(IsisFish.config.getDatabaseDirectory() + File.separator) ? IsisFish.vcs : (absolutePath.startsWith(IsisFish.config.getCommunityDatabaseDirectory() + File.separator) ? IsisFish.communityVcs : new VCSNone(file.getParentFile(), "", "", "", null, "", ""));
        if (log.isDebugEnabled()) {
            log.debug((Object)("VCS for file " + this.getFile() + " is " + result));
        }
        return result;
    }

    protected static VCS getVCS() {
        return IsisFish.vcs;
    }

    protected static VCS getCommunityVCS() {
        return IsisFish.communityVcs;
    }

    protected abstract void prepare();

    public File getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isOnRemote() throws VCSException {
        return VersionStorage.getVCS().isOnRemote(this.getFile());
    }

    protected boolean isVersionnableFile(File file) {
        boolean result = true;
        if (!VersionStorage.getVCS().getLocalRepository().equals(this.file)) {
            result = VersionStorage.getVCS().isVersionnableFile(file);
        }
        return result;
    }

    protected List<File> getFiles(File current, List<File> result) {
        if (this.isVersionnableFile(current)) {
            result.add(current);
            if (current.exists() && current.isDirectory()) {
                for (File child : current.listFiles()) {
                    this.getFiles(child, result);
                }
            }
        }
        return result;
    }

    protected List<File> getFiles(boolean withParent) {
        ArrayList<File> result = new ArrayList<File>();
        File current = this.getFile();
        while (withParent && current != null && !current.equals(this.getRoot())) {
            if ((current = current.getParentFile()) == null) continue;
            result.add(0, current);
        }
        this.getFiles(this.getFile(), result);
        return result;
    }

    public void add(String msg) throws VCSException {
        this.prepare();
        List<File> files = this.getFiles(true);
        files.remove(IsisFish.config.getDatabaseDirectory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("files to add: " + files));
        }
        this.getCurrentVCS().add(files, msg);
    }

    public void delete(boolean vcsDelete) throws StorageException {
        if (vcsDelete) {
            List<File> files = this.getFiles(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to delete : " + files));
            }
            try {
                this.getCurrentVCS().delete(files, I18n.t((String)"isisfish.versionStorage.removed", (Object[])new Object[0]));
            }
            catch (VCSException eee) {
                throw new StorageException(I18n.t((String)"isisfish.error.delete.vcs.files", (Object[])new Object[0]), eee);
            }
        }
        if (this.getFile().isDirectory()) {
            FileUtils.deleteQuietly((File)this.getFile());
        } else {
            this.getFile().delete();
        }
    }

    public void commit(String msg) throws VCSException {
        this.add(msg);
    }

    public void update() throws VCSException {
        this.prepare();
        this.getCurrentVCS().update(this.getFile(), true);
    }

    public boolean isUpToDate() throws VCSException {
        this.prepare();
        return this.getCurrentVCS().isUpToDate(this.getFile());
    }

    public String diff() throws VCSException, IOException {
        return this.getCurrentVCS().getDiff(this.getFile());
    }

    public static void checkout(File destDir, String module) throws VCSException {
        Version tag = IsisConfig.getApiVersion();
        if (!VersionStorage.getVCS().isTag(tag)) {
            tag = null;
        }
        File file = new File(destDir, module);
        VersionStorage.getVCS().update(file, true);
    }

    public static List<String> getStorageNames(File directory) {
        ArrayList<String> result = new ArrayList<String>();
        if (directory.exists()) {
            for (File f : directory.listFiles()) {
                if (VersionStorage.getVCS().isVersionnableFile(f)) {
                    result.add(f.getName());
                    continue;
                }
                if (!VersionStorage.getCommunityVCS().isVersionnableFile(f)) continue;
                result.add(f.getName());
            }
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getRemoteStorageNames(File directory) {
        List<String> result;
        try {
            result = VersionStorage.getVCS().getFileList(directory);
        }
        catch (VCSException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error during connection to VCS server", (Throwable)e);
            }
            result = new ArrayList<String>();
        }
        Collections.sort(result);
        return result;
    }
}

