/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationPlanStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(SimulationPlanStorage.class);
    public static final String SIMULATION_PLAN_PATH = "simulationplans";
    public static final String SIMULATION_PLAN_TEMPLATE = "templates/script/simulationplan.ftl";
    protected static Map<String, SimulationPlanStorage> plansCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    protected SimulationPlanStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static void registerWatcher() {
        SimulationPlanStorage.registerWatcher(storageListeners, SimulationPlanStorage.getSimulationPlanDirectory(), SimulationPlanStorage.getCommunitySimulationPlanDirectory());
    }

    @Override
    public String getPackage() {
        return SIMULATION_PLAN_PATH;
    }

    public static File getSimulationPlanDirectory() {
        File result = new File(SimulationPlanStorage.getContextDatabaseDirectory(), SIMULATION_PLAN_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySimulationPlanDirectory() {
        File result = new File(SimulationPlanStorage.getCommunityDatabaseDirectory(), SIMULATION_PLAN_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getSimulationPlanNames() {
        List<String> result = SimulationPlanStorage.getStorageNames(SimulationPlanStorage.getSimulationPlanDirectory());
        result.addAll(SimulationPlanStorage.getStorageNames(SimulationPlanStorage.getCommunitySimulationPlanDirectory()));
        return result;
    }

    public static SimulationPlanStorage getSimulationPlan(String name, CodeSourceStorage.Location ... location) {
        SimulationPlanStorage result = plansCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = SimulationPlanStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    SimulationPlanStorage storage = new SimulationPlanStorage(dir, new File(dir, SIMULATION_PLAN_PATH), name);
                    if (!storage.getFile().isFile()) continue;
                    result = storage;
                    plansCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static SimulationPlanStorage createSimulationPlan(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        SimulationPlanStorage storage = new SimulationPlanStorage(dir, new File(dir, SIMULATION_PLAN_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        SimulationPlanStorage.checkout(IsisFish.config.getDatabaseDirectory(), SIMULATION_PLAN_PATH);
    }

    public static List<String> getNewSimulationPlanNames() {
        List<String> result = SimulationPlanStorage.getSimulationPlanNames();
        result.removeAll(SimulationPlanStorage.getRemoteSimulationPlanNames());
        return result;
    }

    public static List<String> getRemoteSimulationPlanNames() {
        File dir = SimulationPlanStorage.getSimulationPlanDirectory();
        return SimulationPlanStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteSimulationPlanNames() throws VCSException {
        List<String> result = SimulationPlanStorage.getRemoteSimulationPlanNames();
        result.removeAll(SimulationPlanStorage.getSimulationPlanNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            SimulationPlan simulationPlan = (SimulationPlan)this.getNewInstance();
            result = simulationPlan == null ? null : simulationPlan.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n.t((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

