/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SensitivityAnalysisStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(SensitivityAnalysisStorage.class);
    public static final String SENSITIVITY_ANALYSIS_PATH = "sensitivityanalysis";
    public static final String SENSITIVITY_ANALYSIS_TEMPLATE = "templates/script/sensitivityanalysis.ftl";
    protected static Map<String, SensitivityAnalysisStorage> sensitivityCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    protected SensitivityAnalysisStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static void registerWatcher() {
        SensitivityAnalysisStorage.registerWatcher(storageListeners, SensitivityAnalysisStorage.getSensitivityAnalysisDirectory(), SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory());
    }

    @Override
    public String getPackage() {
        return SENSITIVITY_ANALYSIS_PATH;
    }

    public static File getSensitivityAnalysisDirectory() {
        File result = new File(SensitivityAnalysisStorage.getContextDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySensitivityAnalysisDirectory() {
        File result = new File(SensitivityAnalysisStorage.getCommunityDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getSensitivityAnalysisNames() {
        List<String> result = SensitivityAnalysisStorage.getStorageNames(SensitivityAnalysisStorage.getSensitivityAnalysisDirectory());
        result.addAll(SensitivityAnalysisStorage.getStorageNames(SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory()));
        return result;
    }

    public static SensitivityAnalysisStorage getSensitivityAnalysis(String name, CodeSourceStorage.Location ... location) {
        SensitivityAnalysisStorage result = sensitivityCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = SensitivityAnalysisStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    SensitivityAnalysisStorage storage = new SensitivityAnalysisStorage(dir, new File(dir, SENSITIVITY_ANALYSIS_PATH), name);
                    if (!storage.getFile().isFile()) continue;
                    result = storage;
                    sensitivityCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static SensitivityAnalysisStorage createSensitivityAnalysis(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        SensitivityAnalysisStorage storage = new SensitivityAnalysisStorage(dir, new File(dir, SENSITIVITY_ANALYSIS_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        SensitivityAnalysisStorage.checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_ANALYSIS_PATH);
    }

    public static List<String> getNewSensitivityAnalysisNames() {
        List<String> result = SensitivityAnalysisStorage.getSensitivityAnalysisNames();
        result.removeAll(SensitivityAnalysisStorage.getRemoteSensitivityAnalysisNames());
        return result;
    }

    public static List<String> getRemoteSensitivityAnalysisNames() {
        File dir = SensitivityAnalysisStorage.getSensitivityAnalysisDirectory();
        return SensitivityAnalysisStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteSensitivityAnalysisNames() throws VCSException {
        List<String> result = SensitivityAnalysisStorage.getRemoteSensitivityAnalysisNames();
        result.removeAll(SensitivityAnalysisStorage.getSensitivityAnalysisNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            SensitivityAnalysis sensitivityAnalysis = (SensitivityAnalysis)this.getNewInstance();
            result = sensitivityAnalysis == null ? null : sensitivityAnalysis.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n.t((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

