/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.ResultStorageAbstract;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.BitUtil;
import fr.ifremer.isisfish.util.matrix.EntitySemanticsDecorator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.DoubleBigMappedVector;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixSemanticsDecorator;
import org.nuiton.math.matrix.SemanticsDecorator;
import org.nuiton.math.matrix.Vector;
import org.nuiton.topia.TopiaContext;

@Deprecated
public class ResultMappedStorage
extends ResultStorageAbstract {
    private static Log log = LogFactory.getLog(ResultMappedStorage.class);
    protected MatrixFactory matrixFactory;
    protected RandomAccessFile raf;
    protected long offset;
    protected Map<String, Map<TimeStep, ResultMapped>> nameStepResults = new TreeMap<String, Map<TimeStep, ResultMapped>>();

    public ResultMappedStorage(SimulationStorage simulation) throws IOException {
        super(simulation);
        File file = SimulationStorage.getResultFile(simulation.getDirectory());
        this.raf = new RandomAccessFile(file, "rw");
        this.offset = 0L;
        while (this.offset < this.raf.length()) {
            ResultMapped r = new ResultMapped(this.getMatrixFactory(), this.raf, this.offset);
            this.storeResult(r);
            this.offset += r.size();
        }
    }

    @Override
    protected MatrixFactory getMatrixFactory() {
        if (this.matrixFactory == null) {
            Class vectorClass = IsisFish.config.getMappedResultMatrixVectorClass();
            this.matrixFactory = MatrixFactory.getInstance((Class)vectorClass);
        }
        return this.matrixFactory;
    }

    protected void finalize() throws Throwable {
        try {
            this.raf.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void delete() {
        super.delete();
        File file = SimulationStorage.getResultFile(this.simulation.getDirectory());
        file.delete();
    }

    @Override
    public void close() {
        if (this.raf != null) {
            IOUtils.closeQuietly((Closeable)this.raf);
            this.raf = null;
        }
    }

    protected void storeResult(ResultMapped r) {
        TimeStep step = r.getStep();
        String name = r.getName();
        this.getResult(name).put(step, r);
    }

    protected Map<TimeStep, ResultMapped> getResult(String name) {
        Map result = this.nameStepResults.computeIfAbsent(name, k -> new TreeMap());
        return result;
    }

    @Override
    protected MatrixND readResult(TimeStep step, String name) {
        MatrixND result = null;
        ResultMapped rm = this.getResult(name).get(step);
        if (rm != null) {
            result = rm.getMatrix();
        }
        return result;
    }

    @Override
    protected void writeResult(TimeStep step, String name, MatrixND mat) {
        try {
            ResultMapped r = new ResultMapped(this.raf, this.offset, step, name, mat);
            this.storeResult(r);
            this.offset += r.size();
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't write result", eee);
        }
    }

    @Override
    protected void writeActiveRule(TimeStep step, String name, String params) {
    }

    @Override
    public List<String> getResultName() {
        ArrayList<String> result = new ArrayList<String>(this.nameStepResults.keySet());
        return result;
    }

    protected static class ResultMapped {
        protected RandomAccessFile raf;
        protected long offset;
        protected long size;
        protected TimeStep step;
        protected String name;
        protected MatrixND matrix;

        public ResultMapped(MatrixFactory matrixFactory, RandomAccessFile raf, long offset) throws IOException {
            this.raf = raf;
            this.offset = offset;
            ResultHeaderMatrix header = ResultHeaderMatrix.read(raf, offset);
            if (header != null) {
                this.step = new TimeStep(header.stepValue);
                this.name = header.name;
                String[] dimNames = header.dimNames;
                List[] sems = header.sems;
                long dataOffset = raf.getFilePointer();
                long size = raf.getFilePointer() - offset;
                int dataSize = header.dataSize;
                DoubleBigMappedVector data = new DoubleBigMappedVector(raf, dataOffset, dataSize);
                this.matrix = matrixFactory.create(this.name, sems, dimNames, (Vector)data);
                this.size = size += (long)(dataSize * 8);
            }
        }

        public ResultMapped(RandomAccessFile raf, long offset, TimeStep step, String name, MatrixND matrix) throws IOException {
            this.raf = raf;
            this.offset = offset;
            this.step = step;
            this.name = name;
            String[] dimNames = matrix.getDimensionNames();
            int[] dims = matrix.getDim();
            List[] sems = matrix.getSemantics();
            int dataSize = MatrixHelper.getVectorSize((int[])dims);
            EntitySemanticsDecorator deco = new EntitySemanticsDecorator();
            for (int i = 0; i < sems.length; ++i) {
                ArrayList undecorate;
                List l = sems[i];
                sems[i] = undecorate = new ArrayList(l.size());
                for (Object o : l) {
                    o = deco.undecorate(o);
                    undecorate.add(o);
                }
            }
            ResultHeaderMatrix header = new ResultHeaderMatrix();
            header.set(step.getStep(), name, dims.length, dimNames, dims, sems, dataSize);
            header.write(raf, offset);
            long dataOffset = raf.getFilePointer();
            DoubleBigMappedVector data = new DoubleBigMappedVector(raf, dataOffset, dataSize);
            this.matrix = MatrixFactory.getInstance().create(name, sems, dimNames, (Vector)data);
            this.matrix.paste(matrix);
            this.size = dataOffset - offset + (long)(dataSize * 8);
        }

        public long size() {
            return this.size;
        }

        public TimeStep getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public MatrixND getMatrix() {
            return this.matrix;
        }

        public MatrixND getMatrix(TopiaContext tx) {
            MatrixSemanticsDecorator result = new MatrixSemanticsDecorator(this.matrix, (SemanticsDecorator)new EntitySemanticsDecorator(new EntitySemanticsDecorator.EntityTxProvider(tx)));
            return result;
        }

        protected static class ResultHeaderMatrix {
            static final long RESULT_MATRIX = BitUtil.toMark("resmat01");
            int stepValue;
            String name;
            int dimSize;
            String[] dimNames;
            int[] dims;
            List[] sems;
            int dataSize;

            protected ResultHeaderMatrix() {
            }

            public void set(int stepValue, String name, int dimSize, String[] dimNames, int[] dims, List[] sems, int dataSize) {
                this.stepValue = stepValue;
                this.name = name;
                this.dimSize = dimSize;
                this.dimNames = dimNames;
                this.dims = dims;
                this.sems = sems;
                this.dataSize = dataSize;
            }

            public static ResultHeaderMatrix read(RandomAccessFile raf, long offset) throws IOException {
                raf.seek(offset);
                long mark = raf.readLong();
                ResultHeaderMatrix result = null;
                if (mark != RESULT_MATRIX) {
                    raf.seek(offset);
                } else {
                    int i;
                    result = new ResultHeaderMatrix();
                    result.stepValue = raf.readInt();
                    result.name = raf.readUTF().intern();
                    result.dimSize = raf.readInt();
                    result.dimNames = new String[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.dimNames[i] = raf.readUTF().intern();
                    }
                    result.dims = new int[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.dims[i] = raf.readInt();
                    }
                    result.sems = new List[result.dimSize];
                    for (i = 0; i < result.dimSize; ++i) {
                        result.sems[i] = new ArrayList();
                        for (int j = 0; j < result.dims[i]; ++j) {
                            String s = raf.readUTF().intern();
                            result.sems[i].add(s);
                        }
                    }
                    result.dataSize = raf.readInt();
                }
                return result;
            }

            public void write(RandomAccessFile raf, long offset) throws IOException {
                int i;
                raf.seek(offset);
                long mark = RESULT_MATRIX;
                raf.writeLong(mark);
                raf.writeInt(this.stepValue);
                raf.writeUTF(this.name);
                raf.writeInt(this.dimSize);
                for (i = 0; i < this.dimSize; ++i) {
                    raf.writeUTF(this.dimNames[i]);
                }
                for (i = 0; i < this.dimSize; ++i) {
                    raf.writeInt(this.dims[i]);
                }
                for (List sem : this.sems) {
                    for (Object s : sem) {
                        raf.writeUTF(String.valueOf(s));
                    }
                }
                raf.writeInt(this.dataSize);
            }
        }
    }
}

