/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.JavadocHelper;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaSourceStorage
extends CodeSourceStorage {
    private static final Log log = LogFactory.getLog(ExportStorage.class);
    protected static final String PARAM_PREFIX = "param_";

    protected JavaSourceStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name, ".java");
    }

    public abstract String getPackage();

    public String getFQN() {
        String root = this.getRoot().getAbsolutePath();
        String path = this.getFile().getParentFile().getAbsolutePath();
        String packageName = path.substring(1 + root.length()).replace(File.separatorChar, '.');
        String result = packageName + "." + this.getName();
        if (result.endsWith(".java")) {
            result = result.substring(0, result.length() - ".java".length());
        }
        return result;
    }

    public static String getName(Object instance) {
        return ClassUtils.getShortClassName((Object)instance, null);
    }

    public int compile(boolean force, PrintWriter out) {
        String packageDeclaration;
        String content;
        int result = CompileHelper.compile(this, IsisFish.config.getCompileDirectory(), force, out);
        if (result == 0 && !(content = this.getContent()).contains(packageDeclaration = "package " + this.getPackage() + ";")) {
            if (out != null) {
                out.println("Script doesn't contains mandatory package declaration:");
                out.println("   " + packageDeclaration);
            }
            result = 2;
        }
        return result;
    }

    public int doJavadoc(boolean force, PrintWriter out) {
        int result = JavadocHelper.generateJavadoc(this, IsisFish.config.getJavadocDirectory(), force, out);
        return result;
    }

    public <E> Class<E> getCodeClass() throws IsisFishException {
        String fqn = this.getFQN();
        this.compile(false, null);
        Class<?> result = CompileHelper.loadClass(fqn);
        if (result == null) {
            throw new IsisFishException(String.format("Can't load class: %s", fqn));
        }
        return result;
    }

    public <E> E getNewInstance() throws IsisFishException {
        E result;
        Class<E> clazz = this.getCodeClass();
        try {
            result = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException eee) {
            throw new IsisFishException("Can't instanciate class: " + clazz.getName(), eee);
        }
        return result;
    }

    protected static String getFieldDoc(Class klass, String paramName) throws SecurityException, NoSuchFieldException {
        Field f;
        String result = null;
        if (klass != null && (f = klass.getField(paramName)) != null) {
            Doc annOld;
            fr.ifremer.isisfish.annotations.Doc ann = f.getAnnotation(fr.ifremer.isisfish.annotations.Doc.class);
            if (ann != null) {
                result = ann.value();
            }
            if ((annOld = f.getAnnotation(Doc.class)) != null) {
                result = annOld.value();
            }
        }
        return result;
    }

    public static String getParameterDoc(Object object, String paramName) {
        String result = null;
        try {
            result = JavaSourceStorage.getFieldDoc(object.getClass(), PARAM_PREFIX + paramName);
        }
        catch (Exception e) {
            log.warn((Object)String.format("could not found field %s doc for %s", paramName, object));
        }
        return result;
    }

    public String getDescription() {
        return null;
    }

    public static Map<String, Field> getParameterNamesAndField(Object instance) {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field field : instance.getClass().getFields()) {
            if (!field.getName().startsWith(PARAM_PREFIX)) continue;
            result.put(field.getName().substring(PARAM_PREFIX.length()), field);
        }
        return result;
    }

    public static Object getParameterValue(Object instance, String name) throws IsisFishException {
        if (instance == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            return field.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static Class getParameterType(Object instance, String name) throws IsisFishException {
        if (instance == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static void setParameterValue(Object instance, String name, Object value) throws IsisFishException {
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify script parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }

    public static String getParamAsString(Object instance) throws IsisFishException {
        StringBuilder result = new StringBuilder();
        for (String name : JavaSourceStorage.getParameterNamesAndField(instance).keySet()) {
            Object value = JavaSourceStorage.getParameterValue(instance, name);
            result.append(name).append(" : ").append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public static Object clone(Object instance) {
        Object clone;
        try {
            clone = BeanUtils.cloneBean((Object)instance);
            for (Field field : instance.getClass().getFields()) {
                if (!field.getName().startsWith(PARAM_PREFIX)) continue;
                field.set(clone, field.get(instance));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IsisFishRuntimeException("Can't clone object", e);
        }
        return clone;
    }
}

