/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;

public class FormuleStorage
extends CodeSourceStorage
implements Formule {
    private static final Log log = LogFactory.getLog(FormuleStorage.class);
    public static final String FORMULE_PATH = "formules";
    public static final String FORMULE_TEMPLATE = "templates/script/equation.ftl";
    private static Map<String, FormuleStorage> formulesCache = new ReferenceMap();
    protected String category = null;

    public FormuleStorage(File rootSrc, File directory, String category, String name, String extension) {
        super(rootSrc, new File(directory, category), name, "." + extension);
        this.category = category;
    }

    public static File getFormuleDirectory() {
        File result = new File(IsisFish.config.getDatabaseDirectory(), FORMULE_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityFormuleDirectory() {
        File result = new File(FormuleStorage.getCommunityDatabaseDirectory(), FORMULE_PATH);
        result.mkdirs();
        return result;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public static List<FormuleStorage> getFormules(String category) {
        ArrayList<FormuleStorage> result;
        block3: {
            result = new ArrayList<FormuleStorage>();
            try {
                File dir = new File(FormuleStorage.getFormuleDirectory(), category);
                dir.mkdirs();
                for (File f : dir.listFiles()) {
                    if (!FormuleStorage.getVCS().isVersionnableFile(f)) continue;
                    String name = FileUtil.basename((File)f, (String[])new String[0]);
                    result.add(FormuleStorage.getFormule(category, name));
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Can't load formule for category: " + category), (Throwable)eee);
            }
        }
        return result;
    }

    public static List<FormuleStorage> getCommunityFormules(String category) {
        ArrayList<FormuleStorage> result;
        block3: {
            result = new ArrayList<FormuleStorage>();
            try {
                File dir = new File(FormuleStorage.getCommunityFormuleDirectory(), category);
                dir.mkdirs();
                for (File f : dir.listFiles()) {
                    if (!FormuleStorage.getCommunityVCS().isVersionnableFile(f)) continue;
                    String name = FileUtil.basename((File)f, (String[])new String[0]);
                    result.add(FormuleStorage.getCommunityFormule(category, name));
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Can't load formule for category: " + category), (Throwable)eee);
            }
        }
        return result;
    }

    public static List<String> getFormuleNames(String category) {
        ArrayList<String> result;
        block3: {
            result = new ArrayList<String>();
            try {
                File dir = new File(FormuleStorage.getFormuleDirectory(), category);
                dir.mkdirs();
                for (File f : dir.listFiles()) {
                    if (!FormuleStorage.getVCS().isVersionnableFile(f)) continue;
                    String name = FileUtil.basename((File)f, (String[])new String[0]);
                    result.add(name);
                }
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Can't load formule for category: " + category), (Throwable)eee);
            }
        }
        return result;
    }

    public static List<String> getCategories(TopiaContext context) {
        TreeSet<String> all;
        block2: {
            all = new TreeSet<String>(FormuleStorage.getCategories());
            try {
                List contextCategory = context.findAll("SELECT DISTINCT category FROM Equation", new Object[0]);
                all.addAll(contextCategory);
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't get category from TopiaContext", (Throwable)eee);
            }
        }
        ArrayList<String> result = new ArrayList<String>(all);
        return result;
    }

    public static List<Formule> getFormules(TopiaContext context, String category) {
        ArrayList<Formule> result;
        block3: {
            result = new ArrayList<Formule>(FormuleStorage.getFormules(category));
            result.addAll(FormuleStorage.getCommunityFormules(category));
            if (context != null) {
                try {
                    EquationDAO dao = IsisFishDAOHelper.getEquationDAO(context);
                    List contextFormule = dao.findAllByCategory(category);
                    result.addAll(contextFormule);
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Can't get Equation from TopiaContext", (Throwable)eee);
                }
            }
        }
        return result;
    }

    public static List<String> getCategories() {
        ArrayList<String> result = new ArrayList<String>();
        File dir = FormuleStorage.getFormuleDirectory();
        if (dir.exists()) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || !FormuleStorage.getVCS().isVersionnableFile(f)) continue;
                result.add(f.getName());
            }
        }
        return result;
    }

    public static FormuleStorage getFormule(String category, String name) {
        String key = category + File.separator + name;
        FormuleStorage result = formulesCache.get(key);
        if (result == null) {
            String extension = FileUtil.extension((File)new File(name), (String[])new String[]{"."});
            if (!"".equals(extension)) {
                name = name.substring(0, name.length() - (extension.length() + 1));
            }
            result = new FormuleStorage(IsisFish.config.getDatabaseDirectory(), FormuleStorage.getFormuleDirectory(), category, name, extension);
            formulesCache.put(key, result);
        }
        return result;
    }

    public static FormuleStorage getCommunityFormule(String category, String name) {
        String key = "community" + category + File.separator + name;
        FormuleStorage result = formulesCache.get(key);
        if (result == null) {
            String extension = FileUtil.extension((File)new File(name), (String[])new String[]{"."});
            if (!"".equals(extension)) {
                name = name.substring(0, name.length() - (extension.length() + 1));
            }
            result = new FormuleStorage(IsisFish.config.getCommunityDatabaseDirectory(), FormuleStorage.getCommunityFormuleDirectory(), category, name, extension);
            formulesCache.put(key, result);
        }
        return result;
    }

    public static FormuleStorage createFormule(String category, String name, String extension) {
        String key = category + File.separator + name + extension;
        FormuleStorage result = formulesCache.get(key);
        if (result == null) {
            result = new FormuleStorage(IsisFish.config.getDatabaseDirectory(), FormuleStorage.getCommunityFormuleDirectory(), category, name, extension);
            formulesCache.put(key, result);
        }
        return result;
    }

    public static void checkout() throws VCSException {
        FormuleStorage.checkout(IsisFish.config.getDatabaseDirectory(), FORMULE_PATH);
    }
}

