/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.cache.IsisCache;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CacheAspect {
    private static Log log = LogFactory.getLog(CacheAspect.class);

    protected IsisCache getCache() {
        SimulationContext context = SimulationContext.get();
        IsisCache result = context.getCache();
        return result;
    }

    @Around(value="execution(* scripts..*(..))")
    public Object call(ProceedingJoinPoint jp) throws Throwable {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        Object[] args = jp.getArgs();
        Object result = this.getCache().get(method, args, jp);
        if (log.isTraceEnabled()) {
            log.trace((Object)(((MethodSignature)jp.getSignature()).getMethod() + " args " + Arrays.toString(jp.getArgs()) + " result = " + result));
        }
        return result;
    }
}

