/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.actions.ExportAction;
import fr.ifremer.isisfish.actions.ImportAction;
import fr.ifremer.isisfish.actions.OtherAction;
import fr.ifremer.isisfish.actions.SimulationAction;
import fr.ifremer.isisfish.actions.ValidateSimulationAction;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.InProcessSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SSHSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SubProcessSimulationLauncher;
import fr.ifremer.isisfish.util.cache.IsisCacheBackend;
import fr.ifremer.isisfish.util.cache.IsisCacheBackendOnGuava;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.DoubleBigVector;
import org.nuiton.math.matrix.DoubleSparseHashVector;
import org.nuiton.math.matrix.Vector;
import org.nuiton.util.StringUtil;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class IsisConfig
extends ApplicationConfig {
    public static final int ISIS_FISH_MAJOR_VERSION = 4;
    public static final int STEP_AFTER_INIT = 0;
    public static final int STEP_AFTER_INIT_VCS = 1;
    public static final int STEP_AFTER_UI = 2;
    public static final int STEP_BEFORE_EXIT = 3;
    protected static Version version;
    protected static Version databaseVersion;
    protected static Version apiVersion;
    public static final String COMPRESSION_EXTENSION = ".gz";
    public static final String SEP = ",";
    protected long startingTime = System.currentTimeMillis();
    protected static File currentTempDirectory;

    public static String getVersion() {
        String result = version.toString();
        return result;
    }

    public static Version getDatabaseVersion() {
        return databaseVersion;
    }

    public static Version getApiVersion() {
        return apiVersion;
    }

    public IsisConfig() {
        for (Option option : Option.values()) {
            if (option.defaultValue == null) continue;
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : Action.values()) {
            for (String alias : ((Action)enum_).aliases) {
                this.addActionAlias(alias, ((Action)enum_).action);
            }
        }
    }

    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        ApplicationConfig config = super.parse(args);
        this.postInitWithVersion(config.getOption("isisfish.version"));
        return config;
    }

    protected void postInitWithVersion(String fullVersion) {
        version = Versions.valueOf((String)fullVersion);
        databaseVersion = Versions.extractVersion((Version)version, (int)0, (int)1);
        apiVersion = Versions.extractVersion((Version)version, (int)0, (int)2);
        this.setDefaultOption(Option.SIMULATOR_SSH_ISIS_HOME.key, "/home3/datahome/echatell/isis-fish-" + apiVersion.toString());
    }

    public String getIsisHomeDirectory() {
        String result = this.getOption(Option.ISIS_HOME_DIRECTORY.key);
        return result;
    }

    public void setIsisHomeDirectory(String homeDirectory) {
        this.setOption(Option.ISIS_HOME_DIRECTORY.key, homeDirectory);
    }

    public File getDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.DATABASE_DIRECTORY.key);
        return result;
    }

    public File getCommunityDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.COMMUNITY_DATABASE_DIRECTORY.key);
        return result;
    }

    public File getContextDatabaseDirectory() {
        SimulationContext simContext = SimulationContext.get();
        File scriptDirectory = simContext.getScriptDirectory();
        if (scriptDirectory == null) {
            scriptDirectory = this.getDatabaseDirectory();
        }
        return scriptDirectory;
    }

    public String getDatabaseLockMode() {
        String result = this.getOption(Option.DATABASE_LOCK_MODE.key);
        return result;
    }

    public File getCompileDirectory() {
        File result = this.getOptionAsFile(Option.COMPILATION_DIRECTORY.key);
        SimulationContext simContext = SimulationContext.get();
        SimulationControl control = simContext.getSimulationControl();
        if (control != null) {
            result = new File(result, control.getId());
        }
        return result;
    }

    public File getMonitoringDirectory() {
        File result = this.getOptionAsFile(Option.MONITORING_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getJavadocDirectory() {
        File result = this.getOptionAsFile(Option.JAVADOC_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getCurrentTempDirectory() {
        if (currentTempDirectory == null) {
            File tempDirectory = this.getOptionAsFile(Option.TEMP_DIRECTORY.key);
            String yyyyMMddHHmmss = DateFormatUtils.format((long)this.startingTime, (String)"yyyyMMddHHmmss");
            currentTempDirectory = new File(tempDirectory, "tmp-" + yyyyMMddHHmmss + "-" + RandomUtils.nextInt());
            if (!currentTempDirectory.exists()) {
                currentTempDirectory.mkdirs();
            }
        }
        return currentTempDirectory;
    }

    public File getLogDirectory() {
        File result = this.getOptionAsFile(Option.LOG_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getSwingSessionFile() {
        File result = this.getOptionAsFile(Option.SWING_SESSION_FILE.key);
        return result;
    }

    public Locale getLocale() {
        String value = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConvertUtils.convert((String)value, Locale.class);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public String getEncoding() {
        String result = this.getOption(Option.ENCODING.key);
        return result;
    }

    public String getUserName() {
        String result = this.getOption(Option.USER_NAME.key);
        return result;
    }

    public String getUserMail() {
        String result = this.getOption(Option.USER_MAIL.key);
        return result;
    }

    public String getSimulatorClassfile() {
        String result = this.getOption(Option.SIMULATOR_CLASSFILE.key);
        return result;
    }

    public void setSimulatorClassfile(String value) {
        this.setOption(Option.SIMULATOR_CLASSFILE.key, value);
    }

    public int getSimulatorInMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_IN_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorInMaxThreads(int value) {
        this.setOption(Option.SIMULATOR_IN_MAXTHREADS.key, String.valueOf(value));
    }

    public int getSimulatorSubMaxProcess() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SUB_MAXPROCESS.key);
        return result;
    }

    public void setSimulatorSubMaxProcess(int value) {
        this.setOption(Option.SIMULATOR_SUB_MAXPROCESS.key, String.valueOf(value));
    }

    public String getSimulatorSubMaxMemory() {
        String result = this.getOption(Option.SIMULATOR_SUB_MAXMEMORY.key);
        return result;
    }

    public void setSimulatorSubMaxMemory(String value) {
        this.setOption(Option.SIMULATOR_SUB_MAXMEMORY.key, value);
    }

    public String getSimulatorSshServer() {
        String result = this.getOption(Option.SIMULATOR_SSH_SERVER.key);
        return result;
    }

    public void setSimulatorSshServer(String sshServer) {
        this.setOption(Option.SIMULATOR_SSH_SERVER.key, sshServer);
    }

    public String getSimulatorSshUsername() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_NAME.key);
        return result;
    }

    public void setSimulatorSshUsername(String username) {
        this.setOption(Option.SIMULATOR_SSH_USER_NAME.key, username);
    }

    public String getSimulatorSshDataPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_DATAPATH.key);
        return result;
    }

    public void setSimulatorSshDataPath(String datapath) {
        this.setOption(Option.SIMULATOR_SSH_DATAPATH.key, datapath);
    }

    public String getSimulatorSshUserHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_USER_HOME.key);
        return result;
    }

    public void setSimulatorSshUserHome(String userhome) {
        this.setOption(Option.SIMULATOR_SSH_USER_HOME.key, userhome);
    }

    public String getSimulatorSshIsisHome() {
        String result = this.getOption(Option.SIMULATOR_SSH_ISIS_HOME.key);
        return result;
    }

    public void setSimulatorSshIsisHome(String isishome) {
        this.setOption(Option.SIMULATOR_SSH_ISIS_HOME.key, isishome);
    }

    public String getSimulatorSshTmpPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_TMPPATH.key);
        return result;
    }

    public void setSimulatorSshTmpPath(String sshtemppath) {
        this.setOption(Option.SIMULATOR_SSH_TMPPATH.key, sshtemppath);
    }

    public String getSimulatorSshPbsQsubOptions() {
        String result = this.getOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key);
        return result;
    }

    public void setSimulatorSshPbsQsubOptions(String options) {
        this.setOption(Option.SIMULATOR_SSH_PBSQSUBOPTIONS.key, options);
    }

    public String getSimulatorSshJavaPath() {
        String result = this.getOption(Option.SIMULATOR_SSH_JAVAPATH.key);
        return result;
    }

    public void setSimulatorSshJavaPath(String path) {
        this.setOption(Option.SIMULATOR_SSH_JAVAPATH.key, path);
    }

    public int getSimulatorSshControlCheckInterval() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key);
        return result;
    }

    public void setSimulatorSshControlCheckInterval(int interval) {
        this.setOption(Option.SIMULATOR_SSH_CONTROLCHECKINTERVAL.key, String.valueOf(interval));
    }

    public int getSimulatorSshMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SSH_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorSshMaxThreads(int max) {
        this.setOption(Option.SIMULATOR_SSH_MAXTHREADS.key, String.valueOf(max));
    }

    public String getSimulatorSshMaxMemory() {
        String result = this.getOption(Option.SIMULATOR_SSH_MAXMEMORY.key);
        return result;
    }

    public void setSimulatorSshMaxMemory(String memory) {
        this.setOption(Option.SIMULATOR_SSH_MAXMEMORY.key, memory);
    }

    public File getSSHPrivateKeyFilePath() {
        File result = this.getOptionAsFile(Option.SSH_KEY_FILE.key);
        return result;
    }

    public void setSSHPrivateKeyFilePath(File sshFile) {
        if (sshFile == null) {
            this.setOption(Option.SSH_KEY_FILE.key, null);
        } else {
            this.setOption(Option.SSH_KEY_FILE.key, sshFile.getAbsolutePath());
        }
    }

    public String getSimulatorSshProxyCommand() {
        String result = this.getOption(Option.SIMULATOR_SSH_PROXYCOMMAND.key);
        return result;
    }

    public boolean isLaunchUI() {
        boolean result = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return result;
    }

    public boolean isPerformVcsUpdate() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_VCS_UPDATE.key);
        return result;
    }

    public boolean isPerformCron() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_CRON.key);
        return result;
    }

    public boolean isScriptAutoconfig() {
        boolean result = this.getOptionAsBoolean(Option.SIMULATION_SCRIPT_AUTOCONFIG.key);
        return result;
    }

    public String getDefaultExportNames() {
        String result = this.getOption(Option.DEFAULT_EXPORT_NAMES.key);
        return result;
    }

    public boolean getExportForceCompression() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        boolean result = config.getOptionAsBoolean(Option.EXPORT_FORCE_COMPRESSION.key);
        return result;
    }

    public void setExportForceCompression(boolean value) {
        this.setOption(Option.EXPORT_FORCE_COMPRESSION.key, String.valueOf(value));
    }

    public void setDefaultExportNames(List<String> exportNames) {
        StringBuilder sb = new StringBuilder();
        for (String exportName : exportNames) {
            sb.append(SEP).append(exportName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_EXPORT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultExportNamesAsList() {
        ArrayList<String> result = null;
        String exportNamesList = this.getDefaultExportNames();
        if (exportNamesList != null) {
            String[] exportNames = StringUtil.split((String)exportNamesList, (String)SEP);
            result = new ArrayList<String>(Arrays.asList(exportNames));
        }
        return result;
    }

    public String getDefaultMapFilename() {
        String result = this.getOption(Option.DEFAULT_MAP_FILENAME.key);
        return result;
    }

    public String getDefaultResultNames() {
        String result = this.getOption(Option.DEFAULT_RESULT_NAMES.key);
        return result;
    }

    public void setDefaultResultNames(List<String> resultNames) {
        StringBuilder sb = new StringBuilder();
        for (String resultName : resultNames) {
            sb.append(SEP).append(resultName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_RESULT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultResultNamesAsList() {
        ArrayList<String> result = null;
        String resultNamesList = this.getDefaultResultNames();
        if (resultNamesList != null) {
            String[] resultNames = StringUtil.split((String)resultNamesList, (String)SEP);
            result = new ArrayList<String>(Arrays.asList(resultNames));
        }
        return result;
    }

    public String getDefaultTagValue() {
        String result = this.getOption(Option.DEFAULT_TAG_VALUE.key);
        return result;
    }

    public void setDefaultTagValues(Map<String, String> tagValues) {
        StringBuilder sb = new StringBuilder(" ");
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            sb.append(SEP).append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"');
        }
        String value = sb.toString().trim();
        this.setOption(Option.DEFAULT_TAG_VALUE.key, value.isEmpty() ? "" : value.substring(1));
        this.saveForUser(new String[0]);
    }

    public Map<String, String> getDefaultSimulationConfig() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(Option.SIMULATION_MATRIX_VECTOR_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_VECTOR_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key, this.getOption(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key));
        result.put(Option.SIMULATION_STORE_RESULT_ON_DISK.key, this.getOption(Option.SIMULATION_STORE_RESULT_ON_DISK.key));
        result.put(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key, this.getOption(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key));
        result.put(Option.CACHE_BACKEND_FACTORY_CLASS.key, this.getOption(Option.CACHE_BACKEND_FACTORY_CLASS.key));
        result.put(Option.EXPORT_FORCE_COMPRESSION.key, this.getOption(Option.EXPORT_FORCE_COMPRESSION.key));
        return result;
    }

    public Map<String, String> getDefaultTagValueAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String tagValuesList = this.getDefaultTagValue();
        if (tagValuesList != null) {
            String[] tagValues;
            for (String tagValue : tagValues = StringUtil.split((String)tagValuesList, (String)SEP)) {
                String[] tagAndValue = StringUtil.split((String)tagValue, (String)":");
                String tag = tagAndValue[0].trim();
                tag = tag.substring(1, tag.length() - 1);
                String value = tagAndValue[1].trim();
                value = value.substring(1, value.length() - 1);
                result.put(tag, value);
            }
        }
        return result;
    }

    public String getIsisFishURL() {
        String result = this.getOption(Option.ISIS_URL.key);
        return result;
    }

    public String getJavadocIsisURL() {
        String result = this.getOption(Option.JAVADOC_ISIS_URL.key);
        return result;
    }

    public String getJavadocMatrixURL() {
        String result = this.getOption(Option.JAVADOC_MATRIX_URL.key);
        return result;
    }

    public String getJavadocTopiaURL() {
        String result = this.getOption(Option.JAVADOC_TOPIA_URL.key);
        return result;
    }

    public String getJavadocJavaURL() {
        String result = this.getOption(Option.JAVADOC_JAVA_URL.key);
        return result;
    }

    public long getStartingTime() {
        return this.startingTime;
    }

    public String getElapsedTimeAsString() {
        long diff = System.currentTimeMillis() - this.getStartingTime();
        String result = DurationFormatUtils.formatDuration((long)diff, (String)"s'.'S");
        return result;
    }

    public ClassLoader getScriptClassLoader() {
        SimulationContext simContext = SimulationContext.get();
        ClassLoader result = simContext.getClassLoader();
        if (result == null) {
            URL[] cp = this.getScriptDirectoryURLs();
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            result = new URLClassLoader(cp, parent);
        }
        return result;
    }

    public URL[] getScriptDirectoryURLs() {
        URL[] cp;
        File f = this.getCompileDirectory();
        try {
            cp = new URL[]{f.toURI().toURL()};
        }
        catch (MalformedURLException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.load.classloader", (Object[])new Object[]{f, eee.getMessage()}), eee);
        }
        return cp;
    }

    public Class getMappedResultMatrixVectorClass() {
        Class result = this.getOptionAsClass(Option.MAPPED_RESULT_MATRIX_VECTOR_CLASS.key);
        return result;
    }

    public Class<Vector> getSimulationMatrixVectorClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        Class result = config.getOptionAsClass(Option.SIMULATION_MATRIX_VECTOR_CLASS.key);
        return result;
    }

    public void setSimulationMatrixVectorClass(Class<Vector> value) {
        this.setOption(Option.SIMULATION_MATRIX_VECTOR_CLASS.key, value.getName());
    }

    public Class<Vector> getSimulationMatrixVectorSparseClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        Class result = config.getOptionAsClass(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key);
        return result;
    }

    public void setSimulationMatrixVectorSparseClass(Class<Vector> value) {
        this.setOption(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key, value.getName());
    }

    public int getSimulationMatrixThresholdUseSparse() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key);
        return result;
    }

    public void setSimulationMatrixThresholdUseSparse(int value) {
        this.setOption(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key, String.valueOf(value));
    }

    public boolean getSimulationMatrixdUseLazyVector() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        boolean result = config.getOptionAsBoolean(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key);
        return result;
    }

    public void setSimulationMatrixdUseLazyVector(boolean value) {
        this.setOption(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key, String.valueOf(value));
    }

    public int getSimulationStoreResultOnDisk() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_STORE_RESULT_ON_DISK.key);
        return result;
    }

    public void setSimulationStoreResultOnDisk(int value) {
        this.setOption(Option.SIMULATION_STORE_RESULT_ON_DISK.key, String.valueOf(value));
    }

    public int getSimulationStoreResultCacheStep() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key);
        return result;
    }

    public void setSimulationStoreResultCacheStep(int value) {
        this.setOption(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key, String.valueOf(value));
    }

    public IsisCacheBackend.Factory getCacheBackendFactoryClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        IsisCacheBackend.Factory result = (IsisCacheBackend.Factory)config.getOptionAsObject(IsisCacheBackend.Factory.class, Option.CACHE_BACKEND_FACTORY_CLASS.key);
        return result;
    }

    public String getVcsUserName() {
        String result = this.getOption(Option.VCS_USER_NAME.key);
        return result;
    }

    public void setVcsUserName(String value) {
        this.setOption(Option.VCS_USER_NAME.key, value);
    }

    public String getVcsUserPassword() {
        String result = this.getOption(Option.VCS_USER_PASSWORD.key);
        return result;
    }

    public void setVcsUserPassword(String value) {
        this.setOption(Option.VCS_USER_PASSWORD.key, value);
    }

    public String getVcsCommunityUserName() {
        String result = this.getOption(Option.VCS_COMMUNITY_USER_NAME.key);
        return result;
    }

    public void setVcsCommunityUserName(String value) {
        this.setOption(Option.VCS_COMMUNITY_USER_NAME.key, value);
    }

    public String getVcsCommunityUserPassword() {
        String result = this.getOption(Option.VCS_COMMUNITY_PASSWORD.key);
        return result;
    }

    public void setVcsCommunityUserPassword(String value) {
        this.setOption(Option.VCS_COMMUNITY_PASSWORD.key, value);
    }

    public String getBugReportUrl() {
        String result = this.getOption(Option.BUG_REPORT_URL.key);
        return result;
    }

    public static enum Option {
        CONFIG_FILE("config.file", I18n.n((String)"isisfish.config.main.configFileName.description", (Object[])new Object[0]), "isis-config-4"),
        ISIS_HOME_DIRECTORY("isis.home.directory", I18n.n((String)"isisfish.config.main.compileDirectory.description", (Object[])new Object[0]), ApplicationConfig.getUserHome() + File.separator + "isis-fish-" + 4),
        COMPILATION_DIRECTORY("compilation.directory", I18n.n((String)"isisfish.config.main.compileDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-build"),
        MONITORING_DIRECTORY("monitoring.directory", I18n.n((String)"isisfish.config.main.monitoringDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-monitoring"),
        JAVADOC_DIRECTORY("javadoc.directory", I18n.n((String)"isisfish.config.main.javadocDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-docs"),
        TEMP_DIRECTORY("temp.directory", I18n.n((String)"isisfish.config.main.defaultTempDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-temp"),
        LOG_DIRECTORY("log.directory", I18n.n((String)"isisfish.config.main.defaultLogDirectory.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-log"),
        SWING_SESSION_FILE("swing.session.file", I18n.n((String)"isisfish.config.main.swingSession.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "session.xml"),
        EXPORT_FORCE_COMPRESSION("export.force.compression", I18n.n((String)"isisfish.config.export.force.compression.description", (Object[])new Object[0]), "false"),
        DEFAULT_EXPORT_NAMES("default.export.names", I18n.n((String)"isisfish.config.main.defaultExportNames.description", (Object[])new Object[0]), ""),
        DEFAULT_RESULT_NAMES("default.result.names", I18n.n((String)"isisfish.config.main.defaultResultNames.description", (Object[])new Object[0]), ""),
        DEFAULT_MAP_FILENAME("default.map.filename", I18n.n((String)"isisfish.config.main.defaultMapFile.description", (Object[])new Object[0]), "maps/vmap_area_thin.shp"),
        DEFAULT_TAG_VALUE("default.tagvalue", I18n.n((String)"isisfish.config.main.defaultTagValue.description", (Object[])new Object[0]), ""),
        ENCODING("encoding", I18n.n((String)"isisfish.config.main.encoding.description", (Object[])new Object[0]), "UTF-8"),
        ISIS_URL("isis.url", null, "http://api.isis-fish.org/"),
        JAVADOC_ISIS_URL("javadoc.isis.url", null, "http://api.isis-fish.org/"),
        JAVADOC_MATRIX_URL("javadoc.matrix.url", null, "http://nuiton.page.nuiton.org/nuiton-matrix/nuiton-matrix/apidocs/"),
        JAVADOC_JAVA_URL("javadoc.java.url", null, "https://docs.oracle.com/javase/8/docs/api/"),
        JAVADOC_TOPIA_URL("javadoc.topia.url", null, "http://nuiton.page.nuiton.org/topia-2.x/topia-persistence/apidocs/"),
        SIMULATOR_CLASSFILE("simulator.classfile", I18n.n((String)"isisfish.config.main.defaultSimulator.description", (Object[])new Object[0]), "DefaultSimulator.java"),
        SIMULATOR_LAUNCHER("simulation.launcher.3", I18n.n((String)"isisfish.config.main.localSimulator.description", (Object[])new Object[0]), InProcessSimulatorLauncher.class.getName()),
        SIMULATOR_LAUNCHER2("simulation.launcher.1", I18n.n((String)"isisfish.config.main.subSimulator.description", (Object[])new Object[0]), SubProcessSimulationLauncher.class.getName()),
        SIMULATOR_LAUNCHER_REMOTE("simulation.launcher.2", I18n.n((String)"isisfish.config.main.remoteDatarmor.description", (Object[])new Object[0]), SSHSimulatorLauncher.class.getName()),
        SIMULATION_MATRIX_VECTOR_CLASS("simulation.matrix.vector.class", I18n.n((String)"isisfish.config.simulation.matrix.vector.class.description", (Object[])new Object[0]), DoubleBigVector.class.getName()),
        SIMULATION_MATRIX_VECTOR_SPARSE_CLASS("simulation.matrix.vector.sparse.class", I18n.n((String)"isisfish.config.simulation.matrix.vector.sparse.class.description", (Object[])new Object[0]), DoubleSparseHashVector.class.getName()),
        SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS("simulation.matrix.threshold.use.sparse.class", I18n.n((String)"isisfish.config.simulation.matrix.threshold.use.sparse.class.description", (Object[])new Object[0]), "1000"),
        SIMULATION_MATRIX_USE_LAZY_VECTOR("simulation.matrix.use.lazy.vector", I18n.n((String)"isisfish.config.simulation.matrix.use.lazy.vector.description", (Object[])new Object[0]), "true"),
        SIMULATION_STORE_RESULT_ON_DISK("simulation.store.result.ondisk", I18n.n((String)"isisfish.config.simulation.store.result.ondisk.description", (Object[])new Object[0]), "-1"),
        SIMULATION_STORE_RESULT_CACHE_STEP("simulation.store.result.cachestep", I18n.n((String)"isisfish.config.simulation.store.result.cachestep.description", (Object[])new Object[0]), "13"),
        SIMULATOR_IN_MAXTHREADS("simulation.in.max.threads", I18n.n((String)"isisfish.config.main.simulation.in.max.threads.description", (Object[])new Object[0]), "1"),
        SIMULATOR_SUB_MAXPROCESS("simulation.sub.max.process", I18n.n((String)"isisfish.config.main.simulation.sub.max.process.description", (Object[])new Object[0]), "-1"),
        SIMULATOR_SUB_MAXMEMORY("simulation.sub.max.memory", I18n.n((String)"isisfish.config.main.simulation.sub.max.memory.description", (Object[])new Object[0]), "1024M"),
        SIMULATOR_SSH_SERVER("simulation.ssh2.server", I18n.n((String)"isisfish.config.main.simulation.ssh.server.description", (Object[])new Object[0]), "datarmor"),
        SIMULATOR_SSH_USER_NAME("simulation.ssh2.username", I18n.n((String)"isisfish.config.main.simulation.ssh.username.description", (Object[])new Object[0]), ""),
        SIMULATOR_SSH_USER_HOME("simulation.ssh2.userhome", I18n.n((String)"isisfish.config.main.simulation.ssh.userhome.description", (Object[])new Object[0]), ""),
        SIMULATOR_SSH_DATAPATH("simulation.ssh2.datapath", I18n.n((String)"isisfish.config.main.simulation.ssh.datapath.description", (Object[])new Object[0]), "isis-fish-4/isis-database"),
        SIMULATOR_SSH_ISIS_HOME("simulation.ssh2.isis.home", I18n.n((String)"isisfish.config.main.simulation.ssh.isis.home.description", (Object[])new Object[0]), null),
        SIMULATOR_SSH_TMPPATH("simulation.ssh2.tmppath", I18n.n((String)"isisfish.config.main.simulation.ssh.tmppath.description", (Object[])new Object[0]), "isis-tmp"),
        SIMULATOR_SSH_JAVAPATH("simulation.ssh2.javapath442", I18n.n((String)"isisfish.config.main.simulation.ssh.javapath.description", (Object[])new Object[0]), "/home3/datahome/echatell/jdk8/bin/java"),
        SIMULATOR_SSH_PBSQSUBOPTIONS("simulation.ssh2.pbsqsuboptions", I18n.n((String)"isisfish.config.main.simulation.ssh.pbsqsuboptions.description", (Object[])new Object[0]), "-m n -l mem=2GB -l walltime=01:00:00"),
        SIMULATOR_SSH_CONTROLCHECKINTERVAL("simulation.ssh2.control.check.interval", I18n.n((String)"isisfish.config.main.simulation.ssh.control.check.interval.description", (Object[])new Object[0]), "120"),
        SIMULATOR_SSH_MAXTHREADS("simulation.ssh2.max.threads", I18n.n((String)"isisfish.config.main.simulation.ssh.max.threads.description", (Object[])new Object[0]), "1"),
        SIMULATOR_SSH_MAXMEMORY("simulation.ssh2.max.memory", I18n.n((String)"isisfish.config.main.simulation.ssh.max.memory.description", (Object[])new Object[0]), "2000M"),
        SIMULATOR_SSH_PROXYCOMMAND("simulation.ssh2.proxy.command", I18n.n((String)"isisfish.config.main.simulation.ssh.proxy.command.description", (Object[])new Object[0]), null),
        LOCALE("locale", I18n.n((String)"isisfish.config.main.locale.description", (Object[])new Object[0]), "fr_FR"),
        LAUNCH_UI("launch.ui", I18n.n((String)"isisfish.config.main.launchUI.description", (Object[])new Object[0]), "true"),
        PERFORM_VCS_UPDATE("perform.vcsupdate", I18n.n((String)"isisfish.config.main.performvcsupdate.description", (Object[])new Object[0]), "true"),
        PERFORM_CRON("perform.cron", I18n.n((String)"isisfish.config.main.performcron.description", (Object[])new Object[0]), "true"),
        SIMULATION_SCRIPT_AUTOCONFIG("script.autoconfig", I18n.n((String)"isisfish.config.main.script.autoconfig.description", (Object[])new Object[0]), "true"),
        DATABASE_LOCK_MODE("database.lockmode", I18n.n((String)"isisfish.config.database.lockmode.description", (Object[])new Object[0]), "file"),
        SSH_KEY_FILE("ssh.key.file", I18n.n((String)"isisfish.config.ssh.key.file.description", (Object[])new Object[0]), ApplicationConfig.getUserHome() + File.separator + ".ssh" + File.separator + "isis_rsa"),
        DATABASE_DIRECTORY("database.directory", I18n.n((String)"isisfish.config.vcs.localDatabasePath.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-database"),
        VCS_TYPE("vcs.type", I18n.n((String)"isisfish.config.vcs.type.description", (Object[])new Object[0]), "svn"),
        VCS_PROTOCOL("vcs.protocol", I18n.n((String)"isisfish.config.vcs.protocol.description", (Object[])new Object[0]), "http"),
        VCS_USER_NAME("vcs.username", I18n.n((String)"isisfish.config.vcs.userName.description", (Object[])new Object[0]), ""),
        VCS_USER_PASSWORD("vcs.password", I18n.n((String)"isisfish.config.vcs.userPassword.description", (Object[])new Object[0]), ""),
        VCS_HOST_NAME("vcs.hostName", I18n.n((String)"isisfish.config.vcs.hostName.description", (Object[])new Object[0]), "svn.forge.codelutin.com"),
        VCS_PATH("vcs.path", I18n.n((String)"isisfish.config.vcs.remotePath.description", (Object[])new Object[0]), "/svn/isis-fish-data"),
        COMMUNITY_DATABASE_DIRECTORY("community.database.directory", I18n.n((String)"isisfish.config.vcs.localCommunityDatabasePath.description", (Object[])new Object[0]), "${isis.home.directory}" + File.separator + "isis-community-database"),
        VCS_COMMUNITY_TYPE("vcs.community.type", I18n.n((String)"isisfish.config.vcs.community.type.description", (Object[])new Object[0]), "svn"),
        VCS_COMMUNITY_PROTOCOL("vcs.community.protocole", I18n.n((String)"isisfish.config.vcs.community.protocol.description", (Object[])new Object[0]), "http"),
        VCS_COMMUNITY_USER_NAME("vcs.community.username", I18n.n((String)"isisfish.config.vcs.community.username.description", (Object[])new Object[0]), ""),
        VCS_COMMUNITY_PASSWORD("vcs.community.password", I18n.n((String)"isisfish.config.vcs.community.password.description", (Object[])new Object[0]), ""),
        VCS_COMMUNITY_HOST_NAME("vcs.community.hostname", I18n.n((String)"isisfish.config.vcs.community.hostname.description", (Object[])new Object[0]), "svn.forge.codelutin.com"),
        VCS_COMMUNITY_PATH("vcs.community.path", I18n.n((String)"isisfish.config.vcs.community.remotepath.description", (Object[])new Object[0]), "/svn/isis-fish-community"),
        USER_NAME("user.name", I18n.n((String)"isisfish.config.main.userName.description", (Object[])new Object[0]), System.getProperty("user.name")),
        USER_MAIL("userMail", I18n.n((String)"isisfish.config.main.userMail.description", (Object[])new Object[0]), Option.USER_NAME.defaultValue + "@" + Option.VCS_HOST_NAME.defaultValue),
        BUG_REPORT_URL("bug.report.url", I18n.n((String)"isisfish.config.bug.report.url.description", (Object[])new Object[0]), "https://forge.codelutin.com/projects/isis-fish/issues/new"),
        MAPPED_RESULT_MATRIX_VECTOR_CLASS("mapped.result.matrix.vector.class", I18n.n((String)"isisfish.config.mapped.result.matrix.vector.class.description", (Object[])new Object[0]), DoubleBigVector.class.getName()),
        CACHE_BACKEND_FACTORY_CLASS("cache.backend.factory.class", I18n.n((String)"isisfish.config.cache.backend.factory.class.description", (Object[])new Object[0]), IsisCacheBackendOnGuava.IsisCacheBackendOnGuavaFactory.class.getName());

        public String key;
        public String description;
        public String defaultValue;

        private Option(String key, String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }
    }

    public static enum Action {
        HELP(I18n.n((String)"Show help", (Object[])new Object[0]), OtherAction.class.getName() + "#help", "-h", "--help"),
        VERSION(I18n.n((String)"Show version", (Object[])new Object[0]), OtherAction.class.getName() + "#version", "-v", "--version"),
        IMPORT_EXPORT(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importExport", "--importExport"),
        IMPORT_RULE(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRule", "--importRule"),
        IMPORT_SCRIPT(I18n.n((String)"Import one java file script source", (Object[])new Object[0]), ImportAction.class.getName() + "#importScript", "--importScript"),
        IMPORT_SIMULATION_PLAN(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulationPlan", "--importSimulationPlan"),
        IMPORT_SIMULATOR(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulator", "--importSimulator"),
        IMPORT_FORMULA(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importFormula", "--importFormula"),
        IMPORT_REGION(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRegion", "--importRegion"),
        IMPORT_REGION_AND_RENAME(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importRegionAndRename", "--importRegionAndRename"),
        IMPORT_SIMULATION(I18n.n((String)"", (Object[])new Object[0]), ImportAction.class.getName() + "#importSimulation", "--importSimulation"),
        IMPORT_SCRIPT_MODULE(I18n.n((String)"Import zipped file containing all scripts directory structure", (Object[])new Object[0]), ImportAction.class.getName() + "#importScriptModule", "--importScriptModule"),
        LIST_EXPORT(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listExport", "--listExport"),
        LIST_RULE(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listRule", "--listRule"),
        LIST_SCRIPT(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listScript", "--listScript"),
        LIST_SIMULATION_PLAN(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulationPlan", "--listSimulationPlan"),
        LIST_SIMULATOR(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulator", "--listSimulator"),
        LIST_FORMULA(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listFormula", "--listFormula"),
        LIST_REGION(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listRegion", "--listRegion"),
        LIST_SIMULATION(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#listSimulation", "--listSimulation"),
        EXPORT_EXPORT(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportExport", "--exportExport"),
        EXPORT_RULE(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportRule", "--exportRule"),
        EXPORT_SCRIPT(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportScript", "--exportScript"),
        EXPORT_SIMULATION_PLAN(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulationPlan", "--exportSimulationPlan"),
        EXPORT_SIMULATOR(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulator", "--exportSimulator"),
        EXPORT_FORMULA(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportFormula", "--exportFormula"),
        EXPORT_REGION(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportRegion", "--exportRegion"),
        EXPORT_SIMULATION(I18n.n((String)"", (Object[])new Object[0]), ExportAction.class.getName() + "#exportSimulation", "--exportSimulation"),
        SIMULATE_WITH_REGION(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithRegion", "--simulateWithRegion"),
        SIMULATE_WITH_SIMULATION(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithSimulation", "--simulateWithSimulation"),
        SIMULATE_WITH_SIMULATION_AND_SCRIPT(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateWithSimulationAndScript", "--simulateWithSimulationAndScript"),
        SIMULATE_REMOTELLY(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateRemotelly", "--simulateRemotelly"),
        SIMULATE_REMOTELLY_WITH_PRESCRIPT(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulateRemotellyWithPreScript", "--simulateRemotellyWithPreScript"),
        SIMULATE_WITH_PRE_SCRIPT(I18n.n((String)"", (Object[])new Object[0]), SimulationAction.class.getName() + "#simulationWithRegionNameAndScript", "--simulationWithRegionNameAndScript"),
        VALIDATE_WITH_SIMULATION(I18n.n((String)"", (Object[])new Object[0]), ValidateSimulationAction.class.getName() + "#validateSimulation", "--validate");

        protected String description;
        protected String action;
        protected String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        public String getDescription() {
            return I18n.t((String)this.description, (Object[])new Object[0]);
        }

        public String getAction() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }
}

