/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.util;

import fr.ifremer.isisfish.util.Doc;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class RendererHelper {
    protected static final String DOCUMENTATION_SUBTITLE = "<html><b>%s</b>%s<font color='gray'>%s</font></html>";
    protected static final String COMPILATION_SUBTITLE = "<html><b color='red'>%s</b>%s<font color='red'>%s</font></html>";

    public static String docToString(Doc doc, String ... optionalDocumentations) {
        String tooltip = null;
        if (doc != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (!ArrayUtils.isEmpty((Object[])optionalDocumentations)) {
                for (String optionalDocumentation : optionalDocumentations) {
                    sb.append("<p>" + optionalDocumentation + "</p>");
                }
            } else {
                sb.append("<p>" + doc.value() + "</p>");
            }
            if (!StringUtils.isEmpty((CharSequence)doc.author())) {
                sb.append("<p><b>author: </b>" + doc.author() + "</p>");
            }
            if (!StringUtils.isEmpty((CharSequence)doc.date())) {
                sb.append("<p><b>date: </b>" + doc.date() + "</p>");
            }
            if (!StringUtils.isEmpty((CharSequence)doc.version())) {
                sb.append("<p><b>version: </b>" + doc.version() + "</p>");
            }
            sb.append("</html>");
            tooltip = sb.toString();
            tooltip = tooltip.replace("\n", "<br/>");
        }
        return tooltip;
    }

    public static String getNameAndDocListString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, "<br />", documentation);
        return result;
    }

    public static String getNameAndCompListString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, "<br />", I18n.t((String)"isisfish.error.compile.documentationerror", (Object[])new Object[0]));
        return result;
    }

    public static String getNameAndDocComboString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, " - ", documentation);
        return result;
    }

    public static String getNameAndCompComboString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, " - ", I18n.t((String)"isisfish.error.compile.documentationerror", (Object[])new Object[0]));
        return result;
    }
}

