/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.NavigationHandler;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTreeModel;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.FileUtil;

public class SensitivityInputHandler
extends NavigationHandler {
    private static Log log = LogFactory.getLog(SensitivityInputHandler.class);
    protected SensitivityInputUI sensitivityInputUI;

    public SensitivityInputHandler(SensitivityInputUI sensitivityInputUI) {
        this.sensitivityInputUI = sensitivityInputUI;
    }

    protected void afterInit() {
    }

    protected InputSaveVerifier getVerifier() {
        return this.sensitivityInputUI.getContextValue(InputSaveVerifier.class);
    }

    protected RegionStorage getRegionStorage() {
        return this.sensitivityInputUI.getContextValue(RegionStorage.class);
    }

    protected FactorGroup getFactorGroup() {
        return this.sensitivityInputUI.getContextValue(FactorGroup.class);
    }

    public void setTreeModel() {
        if (this.sensitivityInputUI.getFisheryRegion() != null) {
            this.sensitivityInputUI.getCardlayoutPrincipal().show(this.sensitivityInputUI.inputPanePrincipal, "normale");
            this.sensitivityInputUI.setContextValue(this.sensitivityInputUI.getFisheryRegion());
            this.loadFisheryRegionTree();
        }
    }

    protected void setInfoText(String s) {
        WelcomePanelUI root = this.sensitivityInputUI.getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s);
    }

    protected void regionNull() {
        this.sensitivityInputUI.getCardlayoutPrincipal().show(this.sensitivityInputUI.inputPanePrincipal, "none");
        DefaultTreeModel model = new DefaultTreeModel(null);
        this.sensitivityInputUI.fisheryRegionTree.setModel(model);
    }

    public void setFactorModel() {
        FactorGroup factorGroup = this.getFactorGroup();
        FactorTreeModel model = new FactorTreeModel(factorGroup);
        this.sensitivityInputUI.factorsTree.setModel(model);
        this.sensitivityInputUI.getParentContainer(SensitivityUI.class).getSensitivityChooserUI().getHandler().setFactorCardinalityTableModel();
    }

    public void loadFisheryRegionTree() {
        FisheryRegion fisheryRegion = this.sensitivityInputUI.getFisheryRegion();
        if (fisheryRegion == null) {
            this.sensitivityInputUI.getCardlayoutPrincipal().show(this.sensitivityInputUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            this.sensitivityInputUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryTreeHelper treeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            treeHelper.setDataProvider(dataProvider);
            TreeModel model = treeHelper.createTreeModel(fisheryRegion);
            this.sensitivityInputUI.getFisheryRegionTree().setModel(model);
            this.sensitivityInputUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            treeHelper.setUI(this.sensitivityInputUI.getFisheryRegionTree(), true, false, null);
            this.sensitivityInputUI.setContextValue(fisheryRegion);
            this.sensitivityInputUI.setContextValue(treeHelper);
            this.sensitivityInputUI.setContextValue(model);
            this.sensitivityInputUI.setContextValue(fisheryRegion.getTopiaContext());
            this.sensitivityInputUI.getCardlayoutPrincipal().show(this.sensitivityInputUI.getInputPanePrincipal(), "normale");
        }
    }

    public void nodeSelectionChanged(TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = this.sensitivityInputUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, this.sensitivityInputUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                    inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                inputContentUI.setLayer(true);
                inputContentUI.setSensitivity(true);
                this.sensitivityInputUI.getCardlayoutPrincipal().show(this.sensitivityInputUI.getInputPanePrincipal(), "normale");
                this.sensitivityInputUI.getInputPane().removeAll();
                this.sensitivityInputUI.getInputPane().add(inputContentUI, "Center");
                this.sensitivityInputUI.getInputPane().repaint();
                this.sensitivityInputUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    public void addNewFactorGroup(boolean continuous) {
        String factorName = JOptionPane.showInputDialog(this.sensitivityInputUI, I18n.t((String)"isisfish.sensitivity.newfactorname", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 3);
        if (StringUtils.isNotBlank((CharSequence)factorName)) {
            FactorGroup rootFactorGroup = this.getFactorGroup();
            FactorGroup factorGroup = new FactorGroup(factorName, continuous);
            rootFactorGroup.addFactor(factorGroup);
            this.setFactorModel();
        }
    }

    public void moveFactor(FactorGroup selectedFactorGroup, List<Factor> movedFactors) {
        try {
            selectedFactorGroup.addAllFactors(movedFactors);
            FactorGroup rootFactorGroup = this.getFactorGroup();
            if (!rootFactorGroup.equals(selectedFactorGroup)) {
                rootFactorGroup.removeAll(movedFactors);
            }
            for (int index = 0; index < rootFactorGroup.size(); ++index) {
                FactorGroup factorGroup;
                Factor factor = rootFactorGroup.get(index);
                if (!(factor instanceof FactorGroup) || (factorGroup = (FactorGroup)factor).equals(selectedFactorGroup)) continue;
                factorGroup.removeAll(movedFactors);
            }
            this.setFactorModel();
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(this.sensitivityInputUI, I18n.t((String)"isisfish.sensitivity.moveillegal", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 0);
        }
    }

    public void factorsTreeMouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItemDelete = new JMenuItem(I18n.t((String)"isisfish.common.delete", (Object[])new Object[0]));
            menuItemDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SensitivityInputHandler.this.deleteSelectedFactors();
                }
            });
            menu.add(menuItemDelete);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.factorSelected();
        }
    }

    protected void factorSelected() {
        Object[] pathWay;
        Object selectedObject;
        TreePath selectedPath = this.sensitivityInputUI.getFactorsTree().getSelectionPath();
        if (selectedPath != null && (selectedObject = (pathWay = selectedPath.getPath())[pathWay.length - 1]) != null && !(selectedObject instanceof FactorGroup)) {
            Factor selectedFactor = (Factor)selectedObject;
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)this.sensitivityInputUI);
            FactorWizardHandler handler = factorWizardUI.getHandler();
            handler.initExistingFactor(factorWizardUI, selectedFactor);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(this.sensitivityInputUI);
            factorWizardUI.setVisible(true);
        }
    }

    protected void deleteSelectedFactors() {
        Object[] selectedPaths = this.sensitivityInputUI.getFactorsTree().getSelectionPaths();
        if (!ArrayUtils.isEmpty((Object[])selectedPaths)) {
            for (Object selectedPath : selectedPaths) {
                Object selectedObject;
                Object[] pathWay = ((TreePath)selectedPath).getPath();
                if (pathWay.length < 2 || (selectedObject = pathWay[pathWay.length - 1]) == null || !(selectedObject instanceof Factor)) continue;
                Factor selectedFactor = (Factor)selectedObject;
                FactorGroup selectedFactorGroup = (FactorGroup)pathWay[pathWay.length - 2];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting factor " + selectedFactor.getName()));
                }
                selectedFactorGroup.remove(selectedFactor);
                this.setFactorModel();
            }
        }
    }

    public void exportFactorsToMexico() {
        File xmlFile = FileUtil.getFile((String)I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.title", (Object[])new Object[0]), (String)I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.approve", (Object[])new Object[0]), (Component)this.sensitivityInputUI, (String[])new String[]{".*\\.xml", I18n.t((String)"isisfish.sensitivity.mexico.exporttoxml.filter", (Object[])new Object[0])});
        if (xmlFile != null) {
            if (!FilenameUtils.isExtension((String)xmlFile.getAbsolutePath(), (String)"xml")) {
                xmlFile = new File(xmlFile.getAbsolutePath() + ".xml");
            }
            DesignPlan designPlan = new DesignPlan();
            designPlan.setFactorGroup(this.getFactorGroup());
            MexicoHelper.writeDesignPlanToFile(xmlFile, designPlan);
        }
    }
}

