/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.logging;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.ui.widget.text.SyntaxEditorUI;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.commons.io.FileUtils;
import org.nuiton.i18n.I18n;

public class LoggingFrame
extends JFrame {
    private static final long serialVersionUID = -655585012872692567L;
    protected SyntaxEditorUI editor = new SyntaxEditorUI();

    public LoggingFrame() {
        this.editor.setStyle("isisfish-log");
        this.add((Component)((Object)this.editor));
        this.setSize(800, 600);
    }

    public JMenuBar createMenuBar(Frame parent) {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu(I18n.t((String)"isisfish.script.search", (Object[])new Object[0]));
        menu.add(new JMenuItem(this.editor.getFindAction()));
        menu.add(new JMenuItem(this.editor.getReplaceAction()));
        menu.add(new JMenuItem(this.editor.getGotoAction()));
        mb.add(menu);
        return mb;
    }

    public void loadSimulationLog(String simulationName) throws IOException {
        this.setTitle(I18n.t((String)"isisfish.simulation.log.console.title", (Object[])new Object[]{simulationName}));
        SimulationStorage storage = SimulationStorage.getSimulation(simulationName);
        File logFile = new File(storage.getSimulationLogFile());
        String content = FileUtils.readFileToString((File)logFile);
        this.editor.setText(content);
    }
}

