/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationRecruitmentUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationRecruitmentHandler
extends InputContentHandler<PopulationRecruitmentUI> {
    private static final Log log = LogFactory.getLog(PopulationRecruitmentHandler.class);

    protected PopulationRecruitmentHandler(PopulationRecruitmentUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationRecruitmentUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((PopulationRecruitmentUI)((PopulationRecruitmentHandler)PopulationRecruitmentHandler.this).inputContentUI).fieldPopulationMonthGapBetweenReproRecrutement.setText("");
                    ((PopulationRecruitmentUI)((PopulationRecruitmentHandler)PopulationRecruitmentHandler.this).inputContentUI).fieldPopulationRecruitmentComment.setText("");
                }
                if (evt.getNewValue() != null) {
                    // empty if block
                }
            }
        });
    }

    protected void populationRecruitmentDistributionMatrixChanged(MatrixPanelEvent event) {
        if (((PopulationRecruitmentUI)this.inputContentUI).getBean() != null && ((PopulationRecruitmentUI)this.inputContentUI).fieldPopulationRecruitmentDistribution.getMatrix() != null) {
            ((PopulationRecruitmentUI)this.inputContentUI).getBean().setRecruitmentDistribution(((PopulationRecruitmentUI)this.inputContentUI).fieldPopulationRecruitmentDistribution.getMatrix().copy());
        }
    }

    public void createRecruitmentDistribution(Population pop) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("createRecruitmentDistributionon called: " + pop));
        }
        try {
            int num;
            block10: {
                String val = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.recruitment.number.month", (Object[])new Object[0]));
                num = -1;
                if (val != null && !"".equals(val)) {
                    try {
                        num = Integer.parseInt(val);
                    }
                    catch (RuntimeException eee) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)("Can't parse val: " + val), (Throwable)eee);
                    }
                }
            }
            if (num > 0) {
                ArrayList<String> sem = new ArrayList<String>(num);
                for (int i = 0; i < num; ++i) {
                    sem.add(I18n.t((String)"isisfish.common.month", (Object[])new Object[]{i}));
                }
                MatrixND newMat = MatrixFactory.getInstance().create(new List[]{sem});
                MatrixND mat = pop.getRecruitmentDistribution();
                if (mat != null) {
                    newMat.paste(mat);
                }
                pop.setRecruitmentDistribution(newMat);
                pop.update();
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove RecruitmentDistribution", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"RecruitmentDistribution"}), eee);
        }
    }
}

