/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.metier;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoZoneUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.widget.Interval;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class MetierSeasonInfoZoneHandler
extends InputContentHandler<MetierSeasonInfoZoneUI> {
    private static final Log log = LogFactory.getLog(MetierSeasonInfoZoneHandler.class);
    protected Interval interval = null;
    protected boolean init = false;

    protected MetierSeasonInfoZoneHandler(MetierSeasonInfoZoneUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((MetierSeasonInfoZoneUI)this.inputContentUI).ip.addPropertyChangeListener("first", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((MetierSeasonInfoZoneUI)MetierSeasonInfoZoneHandler.this.inputContentUI).getMetierSeasonInfo() != null) {
                    ((MetierSeasonInfoZoneUI)MetierSeasonInfoZoneHandler.this.inputContentUI).getMetierSeasonInfo().setFirstMonth(new Month(MetierSeasonInfoZoneHandler.this.interval.getFirst()));
                }
            }
        });
        ((MetierSeasonInfoZoneUI)this.inputContentUI).ip.addPropertyChangeListener("last", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (((MetierSeasonInfoZoneUI)MetierSeasonInfoZoneHandler.this.inputContentUI).getMetierSeasonInfo() != null) {
                    ((MetierSeasonInfoZoneUI)MetierSeasonInfoZoneHandler.this.inputContentUI).getMetierSeasonInfo().setLastMonth(new Month(MetierSeasonInfoZoneHandler.this.interval.getLast()));
                }
            }
        });
        ((MetierSeasonInfoZoneUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    // empty if block
                }
                if (evt.getNewValue() != null) {
                    MetierSeasonInfoZoneHandler.this.refresh();
                }
            }
        });
    }

    protected void save() {
        ((MetierSeasonInfoZoneUI)this.inputContentUI).getSaveVerifier().save();
        this.setMetierSeasonInfoCombo();
    }

    protected void create() {
        MetierSeasonInfo newMSI = this.createMetierSeasonInfo(((MetierSeasonInfoZoneUI)this.inputContentUI).getBean());
        ((MetierSeasonInfoZoneUI)this.inputContentUI).setMetierSeasonInfo(newMSI);
        this.setMetierSeasonInfoCombo();
    }

    protected void delete() {
        this.removeMetierSeasonInfo(((MetierSeasonInfoZoneUI)this.inputContentUI).getBean(), ((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo());
        ((MetierSeasonInfoZoneUI)this.inputContentUI).setMetierSeasonInfo(null);
        this.setMetierSeasonInfoCombo();
    }

    public MetierSeasonInfo createMetierSeasonInfo(Metier metier) {
        MetierSeasonInfo metierSeasonInfo = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMetierSeasonInfo called");
        }
        try {
            MetierSeasonInfoDAO metierSeasonInfoPS = IsisFishDAOHelper.getMetierSeasonInfoDAO(metier.getTopiaContext());
            metierSeasonInfo = (MetierSeasonInfo)metierSeasonInfoPS.create(new Object[0]);
            metierSeasonInfo.setFirstMonth(Month.MONTH[0]);
            metierSeasonInfo.setLastMonth(Month.MONTH[3]);
            metier.addMetierSeasonInfo(metierSeasonInfo);
            metierSeasonInfo.update();
            metier.update();
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't create MetierSeasonInfo", eee);
        }
        return metierSeasonInfo;
    }

    public void removeMetierSeasonInfo(Metier metier, MetierSeasonInfo info) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMetierSeasonInfo called");
        }
        try {
            metier.removeMetierSeasonInfo(info);
            metier.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove MetierSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"MetierSeasonInfo"}), eee);
        }
    }

    public void refresh() {
        ((MetierSeasonInfoZoneUI)this.inputContentUI).setMetierSeasonInfo(null);
        if (((MetierSeasonInfoZoneUI)this.inputContentUI).getBean() != null) {
            this.interval = new Interval();
            this.interval.setMin(0);
            this.interval.setMax(11);
            this.interval.setFirst(0);
            this.interval.setLast(2);
            this.setMetierSeasonInfoCombo();
            this.setSeason();
            this.setMetierZone();
            ((MetierSeasonInfoZoneUI)this.inputContentUI).ip.setLabelRenderer(Month.MONTH);
            ((MetierSeasonInfoZoneUI)this.inputContentUI).ip.setModel(this.interval);
        }
    }

    protected void setSeason() {
        block10: {
            if (((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo() != null) {
                ((MetierSeasonInfoZoneUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo());
                try {
                    Month lastMonth;
                    Month firstMonth;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Refresh interval : ");
                    }
                    if ((firstMonth = ((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo().getFirstMonth()) != null) {
                        this.interval.setFirst(firstMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" first : " + this.interval.getFirst()));
                        }
                    } else {
                        this.interval.setFirst(0);
                    }
                    if ((lastMonth = ((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo().getLastMonth()) != null) {
                        this.interval.setLast(lastMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" last : " + this.interval.getLast()));
                        }
                    } else {
                        this.interval.setLast(3);
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Can't display season", (Throwable)e);
                }
            }
        }
    }

    protected void setMetierZone() {
        if (((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo() != null) {
            ListSelectionListener[] listeners;
            for (ListSelectionListener listener : listeners = ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.getListSelectionListeners()) {
                ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.removeListSelectionListener(listener);
            }
            List<Zone> allZones = ((MetierSeasonInfoZoneUI)this.inputContentUI).getFisheryRegion().getZone();
            GenericListModel<Zone> model = new GenericListModel<Zone>(allZones);
            ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.setModel(model);
            if (((MetierSeasonInfoZoneUI)this.inputContentUI).metierSeasonInfo.getZone() != null) {
                for (Zone zone : ((MetierSeasonInfoZoneUI)this.inputContentUI).metierSeasonInfo.getZone()) {
                    int index = allZones.indexOf(zone);
                    ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.getSelectionModel().addSelectionInterval(index, index);
                }
            }
            for (ListSelectionListener listener : listeners) {
                ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.addListSelectionListener(listener);
            }
        }
    }

    protected void setMetierSeasonInfoCombo() {
        List<MetierSeasonInfo> metierSeasonInfoList = ((MetierSeasonInfoZoneUI)this.inputContentUI).getBean().getMetierSeasonInfo();
        GenericComboModel<MetierSeasonInfo> metierSeasonInfoModel = new GenericComboModel<MetierSeasonInfo>(metierSeasonInfoList);
        ((MetierSeasonInfoZoneUI)this.inputContentUI).metierSeasonInfoCombo.setModel(metierSeasonInfoModel);
        metierSeasonInfoModel.setSelectedItem(((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo());
    }

    protected void metierZonesChanged() {
        List<Zone> selected = ((MetierSeasonInfoZoneUI)this.inputContentUI).metierZones.getSelectedValuesList();
        ArrayList<Zone> zones = new ArrayList<Zone>(selected);
        ((MetierSeasonInfoZoneUI)this.inputContentUI).getMetierSeasonInfo().setZone(zones);
    }

    protected void seasonChanged() {
        this.init = true;
        ((MetierSeasonInfoZoneUI)this.inputContentUI).setMetierSeasonInfo((MetierSeasonInfo)((MetierSeasonInfoZoneUI)this.inputContentUI).metierSeasonInfoCombo.getSelectedItem());
        this.setSeason();
        this.setMetierZone();
        this.init = false;
    }
}

