/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.mexico.export.RegionExplorer;
import fr.ifremer.isisfish.mexico.export.RegionExportFactorXML;
import fr.ifremer.isisfish.ui.NavigationHandler;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeSelectionModel;
import fr.ifremer.isisfish.ui.input.tree.loadors.PopulationsNodeLoador;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.vcs.VCSException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.FileUtil;

public class InputHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(InputHandler.class);
    protected InputUI inputUI;

    public InputHandler(InputUI inputUI) {
        this.inputUI = inputUI;
    }

    public void afterInit() {
        PromptSupport.setPrompt((String)I18n.t((String)"isisfish.input.newRegion", (Object[])new Object[0]), (JTextComponent)this.inputUI.getFieldNewRegion());
    }

    protected void loadRegion(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load region " + name));
        }
        if (name == null) {
            this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            this.inputUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryRegion fisheryRegion = null;
            RegionStorage regionStorage = null;
            TopiaContext topiaContext = null;
            try {
                regionStorage = RegionStorage.getRegion(name);
                topiaContext = regionStorage.getStorage().beginTransaction();
                fisheryRegion = RegionStorage.getFisheryRegion(topiaContext);
            }
            catch (TopiaException ex) {
                throw new IsisFishRuntimeException("Can't load region", ex);
            }
            catch (StorageException ex) {
                throw new IsisFishRuntimeException("Can't load region", ex);
            }
            this.inputUI.setRegionLoaded(fisheryRegion != null);
            FisheryTreeHelper fisheryTreeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            fisheryTreeHelper.setDataProvider(dataProvider);
            TreeModel fisheryTreeModel = fisheryTreeHelper.createTreeModel(fisheryRegion);
            this.inputUI.getFisheryRegionTree().setCellRenderer(null);
            this.inputUI.getFisheryRegionTree().setModel(fisheryTreeModel);
            this.inputUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            this.inputUI.getFisheryRegionTree().setSelectionModel(new FisheryTreeSelectionModel(this.inputUI));
            fisheryTreeHelper.setUI(this.inputUI.getFisheryRegionTree(), true, false, null);
            this.inputUI.setContextValue(fisheryRegion);
            this.inputUI.setContextValue(regionStorage);
            this.inputUI.setContextValue(fisheryTreeHelper);
            this.inputUI.setContextValue(fisheryTreeModel);
            this.inputUI.setContextValue(topiaContext);
            this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "normale");
            fisheryTreeHelper.selectNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())));
        }
    }

    public void reloadFisheryTree() {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        fisheryTreeHelper.refreshNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), true);
    }

    public void regionChange(ItemEvent e) {
        if (e.getStateChange() == 1) {
            final String name = (String)this.inputUI.getFieldCurrentRegion().getSelectedItem();
            if (log.isDebugEnabled()) {
                log.debug((Object)("New region selected " + name));
            }
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.loading.region", (Object[])new Object[]{name}), true);
            this.inputUI.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InputHandler.this.loadRegion(name);
                    InputHandler.this.setStatusMessage((JAXXContext)InputHandler.this.inputUI, I18n.t((String)"isisfish.message.load.finished", (Object[])new Object[0]));
                    InputHandler.this.inputUI.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
    }

    public void createNewRegion() {
        String name = this.inputUI.getFieldNewRegion().getText();
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.creating.region", (Object[])new Object[]{name}), true);
        if (RegionStorage.getRegionNames().contains(name)) {
            JOptionPane.showMessageDialog(this.inputUI, I18n.t((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
        } else {
            try {
                RegionStorage.create(name);
            }
            catch (StorageException ex) {
                throw new IsisFishRuntimeException("Can't create region", ex);
            }
            this.inputUI.getFieldNewRegion().setText("");
            this.refreshRegionList(name);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.creation.finished", (Object[])new Object[0]));
    }

    protected void refreshRegionList(String selectedItem) {
        GenericComboModel<String> regionsModel = new GenericComboModel<String>(RegionStorage.getRegionNames());
        this.inputUI.getFieldCurrentRegion().setModel(regionsModel);
        if (selectedItem != null) {
            this.inputUI.getFieldCurrentRegion().setSelectedItem((Object)selectedItem);
        } else {
            this.loadRegion(null);
        }
    }

    public void importRegion() {
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                RegionStorage.importZip(file);
                this.refreshRegionList(null);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionAndRename() {
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                String newName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.name.imported.region", (Object[])new Object[0]));
                RegionStorage.importAndRenameZip(file, newName);
                this.refreshRegionList(null);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionFromSimulation() {
    }

    public void exportRegion() {
        try {
            File file = FileUtil.getFile((String[])new String[]{".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0])});
            if (file != null) {
                if (!file.getAbsolutePath().endsWith(".zip")) {
                    file = new File(file.getAbsolutePath() + ".zip");
                }
                int resp = 0;
                if (file.exists()) {
                    resp = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.message.file.overwrite", (Object[])new Object[0]));
                }
                if (resp == 0) {
                    RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
                    regionStorage.createZip(file);
                }
            }
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't export region", eee);
        }
    }

    public void removeRegion(boolean vcsDelete) {
        try {
            RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
            int resp = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.message.confirm.remove.region", (Object[])new Object[]{regionStorage.getName()}));
            if (resp == 0) {
                regionStorage.delete(vcsDelete);
                this.refreshRegionList(null);
            }
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't delete region", eee);
        }
    }

    public void copyRegion() {
        try {
            String newName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.new.region.name", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((CharSequence)newName)) {
                RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
                File zip = regionStorage.createZip();
                RegionStorage.importAndRenameZip(zip, newName);
            }
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't copy region", eee);
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't copy region", eee);
        }
    }

    public void commitRegionInCVS() {
        try {
            RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.commiting.region", (Object[])new Object[]{regionStorage.getName()}), true);
            String msg = regionStorage.getCommentForNextCommit();
            JTextArea text = new JTextArea(msg);
            int resp = JOptionPane.showOptionDialog(null, new JScrollPane(text), I18n.t((String)"isisfish.commit.message", (Object[])new Object[0]), 2, 3, null, null, null);
            if (resp == 0) {
                regionStorage.commit(text.getText());
                regionStorage.clearCommentForNextCommit();
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.region.commited", (Object[])new Object[0]));
            } else {
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.commit.region.canceled", (Object[])new Object[0]));
            }
        }
        catch (VCSException eee) {
            throw new IsisFishRuntimeException("Can't commit region", eee);
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't commit region", eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.export.done", (Object[])new Object[0]));
    }

    public void exportRegionSensitivityFactors() {
        try {
            File exportFile = FileUtil.getFile((String)I18n.t((String)"isisfish.input.sensitivity.export.title", (Object[])new Object[0]), (String)I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]), (Component)this.inputUI, (String[])new String[]{".*\\.xml", "XML Files"});
            if (exportFile != null) {
                if (!exportFile.getAbsolutePath().endsWith(".xml")) {
                    exportFile = new File(exportFile.getAbsolutePath() + ".xml");
                }
                FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.running", (Object[])new Object[0]), true);
                RegionExplorer explorer = new RegionExplorer();
                RegionExportFactorXML exportXML = new RegionExportFactorXML(exportFile);
                explorer.explore(fisheryRegion, exportXML);
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.complete", (Object[])new Object[0]), true);
            } else {
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.cancel", (Object[])new Object[0]), true);
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't export sensitivity factors", eee);
        }
    }

    public void nodeSelectionChanged(TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, this.inputUI);
                inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "normale");
                this.inputUI.getInputPane().removeAll();
                this.inputUI.getInputPane().add(inputContentUI, "Center");
                this.inputUI.getInputPane().repaint();
                this.inputUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    public void deleteTreeNode(String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        FisheryTreeNode parentNode = (FisheryTreeNode)newSelectNode.getParent();
        fisheryTreeHelper.selectNode((NavNode)parentNode);
        fisheryTreeHelper.removeNode((NavNode)newSelectNode);
    }

    public void insertTreeNode(Class nodeClass, TopiaEntityContextable topiaEntity) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)fisheryTreeHelper.getSelectedNode();
        if (selectedNode.isStaticNode()) {
            selectedNode = (FisheryTreeNode)selectedNode.getParent();
        }
        FisheryTreeNode newNode = new FisheryTreeNode(nodeClass, topiaEntity.getTopiaId(), null, null);
        fisheryTreeHelper.insertNode((NavNode)selectedNode, (NavNode)newNode);
        if (nodeClass.equals(Species.class)) {
            FisheryTreeNode newPopNode = new FisheryTreeNode(Population.class, I18n.n((String)"isisfish.input.tree.populations", (Object[])new Object[0]), null, new PopulationsNodeLoador((Species)topiaEntity));
            fisheryTreeHelper.insertNode((NavNode)newNode, (NavNode)newPopNode);
        }
        fisheryTreeHelper.selectNode((NavNode)newNode);
    }

    public void updateTreeNode(String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        fisheryTreeHelper.refreshNode((NavNode)newSelectNode, false);
    }

    public Species findSpecies() {
        FisheryTreeHelper treeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)treeHelper.getSelectedNode();
        if (selectedNode == null) {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        String speciesId = null;
        FisheryTreeNode parentNode = (FisheryTreeNode)selectedNode.getParent();
        if (parentNode.getInternalClass().equals(Species.class)) {
            speciesId = parentNode.getId();
        } else if (((FisheryTreeNode)parentNode.getParent()).getInternalClass().equals(Species.class)) {
            speciesId = ((FisheryTreeNode)parentNode.getParent()).getId();
        } else {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        TopiaContext topiaContext = this.inputUI.getContextValue(TopiaContext.class);
        Species result = null;
        try {
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(topiaContext);
            result = (Species)dao.findByTopiaId(speciesId);
        }
        catch (TopiaException e) {
            throw new IsisFishRuntimeException("Can't find ");
        }
        return result;
    }
}

