/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RangeOfValues
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_STRING = "String";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_FLOAT = "Float";
    public static final String[] TYPES = new String[]{"String", "Integer", "Float"};
    protected String type = "String";
    protected boolean continueRange = false;
    protected String values = "";
    protected List<Object> possibleValues = null;

    public static String[] getPossibleTypes() {
        return TYPES;
    }

    public RangeOfValues(String typeValue) {
        this.setTypeValues(typeValue);
    }

    public RangeOfValues(String type, String value) {
        this.setType(type);
        this.setValues(value);
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getValues() {
        return this.values;
    }

    protected void setValues(String values) {
        this.values = values;
        this.possibleValues = null;
    }

    public boolean isContinueRange() {
        this.getPossibleValues();
        return this.continueRange;
    }

    protected void setTypeValues(String typeValues) {
        if (typeValues != null) {
            int begin = typeValues.indexOf(91);
            int end = typeValues.indexOf(93);
            String type = typeValues.substring(0, begin);
            String values = typeValues.substring(begin + 1, end);
            this.setType(type);
            this.setValues(values);
        }
    }

    public boolean contains(String val) {
        boolean result = false;
        if (TYPE_INTEGER.equals(this.getType())) {
            result = this.contains(Integer.parseInt(val));
        } else if (TYPE_FLOAT.equals(this.getType())) {
            result = this.contains(Float.parseFloat(val));
        } else {
            this.getPossibleValues().contains(val);
        }
        return result;
    }

    public boolean contains(int val) {
        boolean result = false;
        if (!this.isContinueRange()) {
            result = this.getPossibleValues().contains(val);
        } else {
            int first = (Integer)this.getPossibleValues().get(0);
            int last = (Integer)this.getPossibleValues().get(1);
            result = first <= val && val <= last;
        }
        return result;
    }

    public boolean contains(float val) {
        boolean result = false;
        if (!this.isContinueRange()) {
            result = this.getPossibleValues().contains(Float.valueOf(val));
        } else {
            double first = (Double)this.getPossibleValues().get(0);
            double last = (Double)this.getPossibleValues().get(1);
            result = first <= (double)val && (double)val <= last;
        }
        return result;
    }

    private Object stringToObject(String s) {
        if (TYPE_INTEGER.equals(this.getType())) {
            return Integer.valueOf(s);
        }
        if (TYPE_FLOAT.equals(this.getType())) {
            return Double.valueOf(s);
        }
        return s;
    }

    public List<Object> getPossibleValues() {
        if (this.possibleValues == null) {
            this.possibleValues = new ArrayList<Object>();
            String g = this.getValues();
            if (g.indexOf(";") != -1 || g.matches("^-?[^-]+$")) {
                this.continueRange = false;
                String[] val = g.split(";");
                for (int i = 0; i < val.length; ++i) {
                    this.possibleValues.add(this.stringToObject(val[i]));
                }
            } else {
                this.continueRange = true;
                int first = 0;
                if (g.startsWith("-")) {
                    first = 1;
                }
                first = g.indexOf("-", first);
                String min = g.substring(0, first);
                String max = g.substring(first + 1);
                this.possibleValues.add(this.stringToObject(min));
                this.possibleValues.add(this.stringToObject(max));
            }
        }
        return this.possibleValues;
    }

    public String getAsString() {
        String result = this.getType() + "[" + this.getValues() + "]";
        return result;
    }

    public String toString() {
        String result = this.getAsString();
        return result;
    }
}

