/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.coords.LatLonPoint;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.ZoneDelimiterLayer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;

public class CellSelectionLayer
extends ZoneDelimiterLayer
implements MapMouseListener {
    private static final long serialVersionUID = 6952137313443302883L;
    protected int selectionMode;
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULT_SELECTION = 2;

    public CellSelectionLayer(FisheryRegion fisheryRegion, int selectionMode) throws TopiaException {
        super(fisheryRegion);
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int v) {
        this.selectionMode = v;
    }

    public OMRect findXY(LatLonPoint pt) {
        List allRect = this.graphics.getTargets();
        for (OMGraphic rectg : allRect) {
            OMRect rect = (OMRect)rectg;
            if (!((double)pt.getLatitude() >= rect.getSouthLat()) || !((double)pt.getLatitude() < rect.getNorthLat()) || !((double)pt.getLongitude() >= rect.getWestLon()) || !((double)pt.getLongitude() < rect.getEastLon())) continue;
            return rect;
        }
        return null;
    }

    public List<LatLonPoint> getSelected() {
        List allRect = this.graphics.getTargets();
        ArrayList<LatLonPoint> result = new ArrayList<LatLonPoint>();
        for (OMGraphic rectg : allRect) {
            OMRect rect = (OMRect)rectg;
            if (rect.getFillPaint() == null || rect.isClear(rect.getFillPaint())) continue;
            result.add((LatLonPoint)new LatLonPoint.Double(rect.getSouthLat(), rect.getWestLon()));
        }
        return result;
    }

    public void unSelectAll() {
        List allRect = this.graphics.getTargets();
        for (OMGraphic rectg : allRect) {
            OMRect rect = (OMRect)rectg;
            rect.setFillPaint(null);
        }
        this.repaint();
    }

    public boolean select(LatLonPoint pt) {
        OMRect select = this.findXY(pt);
        if (select == null) {
            return false;
        }
        if (select.getFillPaint() == null || select.isClear(select.getFillPaint())) {
            if (this.getSelectionMode() == 1) {
                this.unSelectAll();
            }
            select.setFillPaint((Paint)Color.green);
        }
        this.repaint();
        return true;
    }

    public boolean select(float latitude, float longitude) {
        return this.select((LatLonPoint)new LatLonPoint.Float(latitude, longitude));
    }

    public boolean unSelect(LatLonPoint pt) {
        OMRect select = this.findXY(pt);
        if (select == null) {
            return false;
        }
        OMRect rect = select;
        rect.setFillPaint(null);
        this.repaint();
        return true;
    }

    public boolean unSelect(float latitude, float longitude) {
        return this.unSelect((LatLonPoint)new LatLonPoint.Float(latitude, longitude));
    }

    public String[] getMouseModeServiceList() {
        return new String[]{"Gestures"};
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.getSelectionMode() == 0) {
            return false;
        }
        OMRect select = this.findXY((LatLonPoint)this.getProjection().inverse((double)e.getX(), (double)e.getY()));
        if (select == null) {
            return false;
        }
        if (select.getFillPaint() == null || select.isClear(select.getFillPaint())) {
            if (this.getSelectionMode() == 1) {
                this.unSelectAll();
            }
            select.setFillPaint((Paint)Color.green);
        } else if (this.getSelectionMode() == 2) {
            select.setFillPaint(null);
        }
        this.repaint();
        return true;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }
}

