/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.result.ResultInfo;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ResultInfoStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(ResultInfoStorage.class);
    public static final String RESULT_INFO_PATH = "resultinfos";
    public static final String RESULT_INFO_TEMPLATE = "templates/script/resultinfo.ftl";
    protected static Map<String, ResultInfoStorage> resultInfosCache = new ReferenceMap();

    protected ResultInfoStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    @Override
    public String getPackage() {
        return RESULT_INFO_PATH;
    }

    public static File getResultInfoDirectory() {
        File result = new File(ResultInfoStorage.getContextDatabaseDirectory(), RESULT_INFO_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityResultInfoDirectory() {
        File result = new File(ResultInfoStorage.getCommunityDatabaseDirectory(), RESULT_INFO_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getResultInfoNames() {
        List<String> rules = ResultInfoStorage.getStorageNames(ResultInfoStorage.getResultInfoDirectory());
        rules.addAll(ResultInfoStorage.getStorageNames(ResultInfoStorage.getCommunityResultInfoDirectory()));
        return rules;
    }

    public static ResultInfoStorage getResultInfo(String name, CodeSourceStorage.Location ... location) {
        ResultInfoStorage result = resultInfosCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location[] locs = ResultInfoStorage.nonEmptyLocation(location);
            for (int i = 0; i < locs.length && result == null; ++i) {
                CodeSourceStorage.Location loc = locs[i];
                for (File dir : loc.getDirectories()) {
                    ResultInfoStorage storage = new ResultInfoStorage(dir, new File(dir, RESULT_INFO_PATH), name);
                    File sFile = storage.getFile();
                    if (!sFile.isFile()) continue;
                    result = storage;
                    resultInfosCache.put(name, result);
                }
            }
        }
        return result;
    }

    public static ResultInfoStorage createResultInfo(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        ResultInfoStorage storage = new ResultInfoStorage(dir, new File(dir, RESULT_INFO_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        ResultInfoStorage.checkout(IsisFish.config.getDatabaseDirectory(), RESULT_INFO_PATH);
    }

    public static List<String> getNewResultInfoNames() {
        List<String> result = ResultInfoStorage.getResultInfoNames();
        result.removeAll(ResultInfoStorage.getRemoteResultInfoNames());
        return result;
    }

    public static List<String> getRemoteResultInfoNames() {
        File dir = ResultInfoStorage.getResultInfoDirectory();
        return ResultInfoStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteResultInfoNames() {
        List<String> result = ResultInfoStorage.getRemoteResultInfoNames();
        result.removeAll(ResultInfoStorage.getResultInfoNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            ResultInfo resultInfo = (ResultInfo)this.getNewInstance();
            result = resultInfo == null ? null : resultInfo.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n.t((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

