/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.aspect.AspectJWeavingAdaptor;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.bridge.AbortException;
import org.aspectj.weaver.bcel.ExtensibleURLClassLoader;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class AspectJUrlClassLoader
extends ExtensibleURLClassLoader
implements WeavingClassLoader {
    public static final String WEAVING_CLASS_PATH = "aj.class.path";
    public static final String WEAVING_ASPECT_PATH = "aj.aspect.path";
    private URL[] aspectURLs;
    private AspectJWeavingAdaptor adaptor;
    private boolean initializingAdaptor;
    private Map generatedClasses = new HashMap();
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(AspectJUrlClassLoader.class);

    public AspectJUrlClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{urls, parent});
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
        this.adaptor = new AspectJWeavingAdaptor(this.getParent(), this);
    }

    protected void addURL(URL url) {
        this.adaptor.addURL(url);
        super.addURL(url);
    }

    protected Class defineClass(String name, byte[] b, CodeSource cs) throws IOException {
        Class clazz;
        if (trace.isTraceEnabled()) {
            trace.enter("defineClass", (Object)this, new Object[]{name, b, cs});
        }
        byte[] orig = b;
        if (!this.initializingAdaptor) {
            if (this.adaptor != null || !this.initializingAdaptor) {
                // empty if block
            }
            try {
                b = this.adaptor.weaveClass(name, b, false);
            }
            catch (AbortException ex) {
                trace.error("defineClass", (Throwable)ex);
                throw ex;
            }
            catch (Throwable th) {
                trace.error("defineClass", th);
            }
        }
        try {
            clazz = super.defineClass(name, b, cs);
        }
        catch (Throwable th) {
            trace.error("Weaving class problem. Original class has been returned. The error was caused because of: " + th, th);
            clazz = super.defineClass(name, orig, cs);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("defineClass", (Object)clazz);
        }
        return clazz;
    }

    protected byte[] getBytes(String name) throws IOException {
        byte[] bytes = super.getBytes(name);
        if (bytes == null) {
            return (byte[])this.generatedClasses.remove(name);
        }
        return bytes;
    }

    public URL[] getAspectURLs() {
        return this.aspectURLs;
    }

    public void acceptClass(String name, byte[] classBytes, byte[] weavedBytes) {
        this.generatedClasses.put(name, weavedBytes);
    }

    public void deploy(Class<?> aspectClass) {
        byte[] result = this.adaptor.deploy(aspectClass);
        this.defineClass(aspectClass.getName(), result, 0, result.length);
    }

    public void prepare() {
        this.adaptor.prepare();
    }
}

