/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish;

import com.bbn.openmap.MapBean;
import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.IsisTray;
import fr.ifremer.isisfish.cron.CronService;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.simulator.launcher.SimulationMonitor;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.ui.WelcomeContext;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.WelcomeUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.util.IsisCache;
import fr.ifremer.isisfish.util.IsisMatrixSemanticMapper;
import fr.ifremer.isisfish.util.RUtil;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSActionEvent;
import fr.ifremer.isisfish.vcs.VCSException;
import fr.ifremer.isisfish.vcs.VCSFactory;
import fr.ifremer.isisfish.vcs.VetoableActionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jaxx.runtime.JAXXContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.version.Version;
import org.nuiton.widget.SwingSession;

public class IsisFish {
    private static Log log = LogFactory.getLog(IsisFish.class);
    public static IsisConfig config = null;
    public static VCS vcs = null;
    public static VCS communityVcs = null;

    public static void quit() {
        System.exit(0);
    }

    public static void main(String ... args) throws Exception {
        System.setSecurityManager(null);
        IsisFish.init(args);
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Isis-Fish " + IsisConfig.getVersion() + " with args : " + Arrays.toString(args)));
            log.info((Object)("Date: " + SimpleDateFormat.getInstance().format(new Date())));
            log.info((Object)("Java version: " + System.getProperty("java.runtime.version") + ", " + System.getProperty("java.vm.name")));
            log.info((Object)("Plaform/arch: " + System.getProperty("os.name") + "/" + System.getProperty("os.arch")));
            log.info((Object)("R_HOME: " + System.getenv("R_HOME")));
            log.info((Object)("PATH: " + System.getenv("PATH")));
        }
        RUtil.initJri();
        config.doAction(0);
        IsisFish.initLookAndFeel();
        try {
            IsisFish.initVCS();
            IsisFish.initCommunityVCS();
            IsisFish.checkDuplicatedFiles();
        }
        catch (Exception eee) {
            log.warn((Object)I18n.t((String)"Error during vcs initialisation", (Object[])new Object[0]), (Throwable)eee);
        }
        MatrixFactory.setSemanticMapper((SemanticMapper)new IsisMatrixSemanticMapper());
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"isisfish.launching", (Object[])new Object[]{config.getElapsedTimeAsString()}));
        }
        config.doAction(1);
        IsisFish.launchUI();
        config.doAction(2);
        IsisFish.startCronService();
    }

    protected static void initVersion() {
    }

    protected static void startCronService() {
        if (config.isPerformCron()) {
            CronService cronService = new CronService();
            cronService.start();
        }
    }

    private static void initLookAndFeel() throws InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (config.isLaunchUI()) {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(laf.getName())) continue;
                try {
                    UIManager.setLookAndFeel(laf.getClassName());
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)"Can't install nimbus");
                }
            }
        }
    }

    public static void init(String ... args) throws Exception {
        config = new IsisConfig();
        config.parse(args);
        try {
            I18n.init((I18nInitializer)new DefaultI18nInitializer("isis-fish-i18n"), (Locale)config.getLocale());
        }
        catch (Exception ex) {
            I18n.init((I18nInitializer)new ClassPathI18nInitializer(), (Locale)config.getLocale());
        }
        IsisCache.defaultFactory = config.getCacheBackendFactoryClass();
        Runtime.getRuntime().addShutdownHook(new IsisQuitHook());
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"isisfish.launch.init.done", (Object[])new Object[]{config.getElapsedTimeAsString()}));
        }
    }

    protected static boolean ask(Object msg) {
        int value = JOptionPane.showConfirmDialog(null, msg);
        if (value == 2) {
            IsisFish.quit();
        }
        boolean result = value == 0;
        return result;
    }

    public static void initVCS() throws VCSException {
        if (config.isLaunchUI() && config.isPerformVcsUpdate()) {
            vcs = VCSFactory.createVCS(config);
            VCSActionAsker asker = new VCSActionAsker();
            vcs.addVetoableActionListener(asker);
            File local = config.getDatabaseDirectory();
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"Check state of local repository: %s", (Object[])new Object[]{local}));
            }
            if (local.exists() && !vcs.isValidLocalRepository()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Local repository exists but it's not valide for current vcs: %s", (Object[])new Object[]{config.getOption("vcs.type")}));
                }
                if (IsisFish.ask(I18n.t((String)"isisfish.vcs.init.wrongprotocol", (Object[])new Object[]{local}))) {
                    File localBackup = new File(local.getParentFile(), local.getName() + "-" + new SimpleDateFormat("yyyy-mm-dd-HH-mm-ss").format(new Date()));
                    if (log.isInfoEnabled()) {
                        log.info((Object)I18n.t((String)"Rename data directory to %s", (Object[])new Object[]{localBackup}));
                    }
                    if (!local.renameTo(localBackup)) {
                        throw new IsisFishRuntimeException("Can't rename local repository that don't use svn");
                    }
                } else {
                    log.info((Object)I18n.t((String)"Switch repository type to none", (Object[])new Object[0]));
                    config.setOption(IsisConfig.Option.VCS_TYPE.key, "none");
                    config.saveForUser(new String[0]);
                    vcs = VCSFactory.createVCS(config);
                }
            }
            if (!local.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Local repository don't exist", (Object[])new Object[0]));
                }
                if (!vcs.isConnected()) {
                    ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.vcs.init.notfoundcantdownload", (Object[])new Object[]{IsisConfig.getApiVersion()}), null);
                } else {
                    Version tag = IsisConfig.getApiVersion();
                    if (!vcs.isTag(tag)) {
                        tag = null;
                    }
                    vcs.checkout(tag, false);
                    ExportStorage.checkout();
                    FormuleStorage.checkout();
                    ObjectiveStorage.checkout();
                    OptimizationStorage.checkout();
                    RuleStorage.checkout();
                    ResultInfoStorage.checkout();
                    ScriptStorage.checkout();
                    SensitivityAnalysisStorage.checkout();
                    SensitivityExportStorage.checkout();
                    SimulationPlanStorage.checkout();
                    SimulatorStorage.checkout();
                    vcs.update(new File(local, "simulations"), false);
                    vcs.update(new File(local, "regions"), false);
                    try {
                        RegionStorage.checkout("DemoRegion");
                    }
                    catch (TopiaException eee) {
                        log.warn((Object)"Can't checkout DemoRegion", (Throwable)eee);
                    }
                }
            }
            if (!local.exists()) {
                throw new IsisFishRuntimeException("Can't find local repository");
            }
            if (vcs.isConnected()) {
                List<File> filesInClonflict;
                vcs.cleanup(null);
                vcs.checkProtocol();
                if (vcs.getTag().startsWith("/branches")) {
                    log.info((Object)I18n.t((String)"Use branches, switch not needed", (Object[])new Object[0]));
                } else {
                    Version tag = IsisConfig.getApiVersion();
                    filesInClonflict = vcs.isTag(tag) ? vcs.setTag(tag) : vcs.setTag(null);
                    if (filesInClonflict != null && !filesInClonflict.isEmpty()) {
                        IsisFish.warnFileListDialog(I18n.t((String)"isisfish.error.warning.title", (Object[])new Object[0]), I18n.t((String)"isisfish.vcs.switchtag.warningconflict", (Object[])new Object[0]), filesInClonflict);
                    }
                }
                filesInClonflict = vcs.checkFileStatus();
                if (filesInClonflict != null && !filesInClonflict.isEmpty()) {
                    IsisFish.warnFileListDialog(I18n.t((String)"isisfish.error.warning.title", (Object[])new Object[0]), I18n.t((String)"isisfish.vcs.update.warningconflict", (Object[])new Object[0]), filesInClonflict);
                }
            }
            vcs.remoteVetoableActionListener(asker);
        } else {
            config.setOption("vcs.type", "none");
            vcs = VCSFactory.createVCS(config);
        }
    }

    public static void initCommunityVCS() throws VCSException {
        if (config.isLaunchUI() && config.isPerformVcsUpdate()) {
            communityVcs = VCSFactory.createPublicVCS(config);
            VCSActionAsker asker = new VCSActionAsker();
            communityVcs.addVetoableActionListener(asker);
            File local = config.getCommunityDatabaseDirectory();
            if (local.exists() && !communityVcs.isValidLocalRepository()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Local repository exists but it's not valide for current vcs: %s", (Object[])new Object[]{config.getOption("vcs.type")}));
                }
                if (IsisFish.ask(I18n.t((String)"isisfish.vcs.init.wrongprotocol", (Object[])new Object[]{local}))) {
                    File localBackup = new File(local.getParentFile(), local.getName() + "-" + new SimpleDateFormat("yyyy-mm-dd-HH-mm-ss").format(new Date()));
                    if (log.isInfoEnabled()) {
                        log.info((Object)I18n.t((String)"Rename data directory to %s", (Object[])new Object[]{localBackup}));
                    }
                    if (!local.renameTo(localBackup)) {
                        throw new IsisFishRuntimeException("Can't rename local repository that don't use svn");
                    }
                } else {
                    log.info((Object)I18n.t((String)"Switch repository type to none", (Object[])new Object[0]));
                    config.setOption(IsisConfig.Option.VCS_COMMUNITY_TYPE.key, "none");
                    config.saveForUser(new String[0]);
                    communityVcs = VCSFactory.createPublicVCS(config);
                }
            }
            if (!local.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Local repository don't exist", (Object[])new Object[0]));
                }
                if (!communityVcs.isConnected()) {
                    ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.vcs.init.notfoundcantdownload", (Object[])new Object[]{"trunk"}), null);
                } else {
                    communityVcs.checkout(null, true);
                }
            }
            if (communityVcs.isConnected()) {
                communityVcs.cleanup(null);
                communityVcs.checkProtocol();
                List<File> filesInClonflict = communityVcs.checkFileStatus();
                if (filesInClonflict != null && !filesInClonflict.isEmpty()) {
                    IsisFish.warnFileListDialog(I18n.t((String)"isisfish.error.warning.title", (Object[])new Object[0]), I18n.t((String)"isisfish.vcs.update.warningconflict", (Object[])new Object[0]), filesInClonflict);
                }
            }
            communityVcs.remoteVetoableActionListener(asker);
        } else {
            config.setOption(IsisConfig.Option.VCS_COMMUNITY_TYPE.key, "none");
            communityVcs = VCSFactory.createPublicVCS(config);
        }
    }

    protected static void checkDuplicatedFiles() {
        long before = System.currentTimeMillis();
        Collection offFiles = FileUtils.listFiles((File)config.getDatabaseDirectory(), (IOFileFilter)new AbstractFileFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        }, (IOFileFilter)new AbstractFileFilter(){

            public boolean accept(File dir, String name) {
                return !name.equals("simulations");
            }
        });
        for (File offFile : offFiles) {
            File comFile = new File(config.getCommunityDatabaseDirectory() + StringUtils.removeStart((String)offFile.getAbsolutePath(), (String)config.getDatabaseDirectory().getAbsolutePath()));
            if (!comFile.isFile()) continue;
            if (log.isWarnEnabled()) {
                log.warn((Object)("Found file collision for " + comFile.getAbsolutePath()));
            }
            File newFile = new File(comFile.getParentFile(), "Duplicated_" + comFile.getName());
            comFile.renameTo(newFile);
        }
        if (log.isDebugEnabled()) {
            long after = System.currentTimeMillis();
            log.debug((Object)("Check corrumpted file in " + (after - before) + " ms"));
        }
    }

    protected static void warnFileListDialog(String dialogTitle, String labelTitle, List<File> conflictFiles) {
        String conflictFilesString = "";
        String separator = "";
        for (File file : conflictFiles) {
            conflictFilesString = conflictFilesString + separator + file.toString();
            separator = "\n";
        }
        JLabel labelModifiedFiles = new JLabel(labelTitle);
        JTextArea areaModifiedFiles = new JTextArea(conflictFilesString);
        areaModifiedFiles.setEditable(false);
        areaModifiedFiles.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane(areaModifiedFiles);
        sp.setPreferredSize(new Dimension(500, 100));
        JOptionPane.showMessageDialog(null, new Component[]{labelModifiedFiles, sp}, dialogTitle, 2);
    }

    public static void launchUI() {
        if (config.isLaunchUI()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WelcomeUI welcome;
                    SwingSession session;
                    block14: {
                        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                            @Override
                            public void uncaughtException(Thread t, Throwable cause) {
                                if (cause instanceof LinkageError) {
                                    block8: {
                                        if (log.isFatalEnabled()) {
                                            log.fatal((Object)"Linkage error detected", cause);
                                        }
                                        try {
                                            FileUtils.deleteDirectory((File)config.getCompileDirectory());
                                        }
                                        catch (IOException ex) {
                                            if (!log.isErrorEnabled()) break block8;
                                            log.error((Object)"Can't clear build directory", (Throwable)ex);
                                        }
                                    }
                                    ErrorHelper.showErrorDialog(null, I18n.t((String)"isisfish.error.linkageerror.message", (Object[])new Object[0]), cause);
                                } else {
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)"Global application exception", cause);
                                    }
                                    Throwable lastCause = cause;
                                    while (lastCause.getCause() != null) {
                                        lastCause = lastCause.getCause();
                                    }
                                    if (!(lastCause instanceof NumberFormatException)) {
                                        ErrorHelper.showErrorDialog(null, cause.getMessage(), cause);
                                    }
                                }
                            }
                        });
                        SimulationService.getService();
                        IsisTray.getInstance();
                        MapBean.suppressCopyright = true;
                        File isisConfigDirectory = new File(config.getUserConfigDirectory(), "isis-fish");
                        isisConfigDirectory.mkdirs();
                        File sessionFile = new File(isisConfigDirectory, "session.xml");
                        session = new SwingSession(sessionFile, true);
                        WelcomeContext welcomeContext = new WelcomeContext();
                        welcome = new WelcomeUI((JAXXContext)welcomeContext);
                        welcome.setTitle(I18n.t((String)"isisfish.welcome.title", (Object[])new Object[]{IsisConfig.getVersion()}));
                        welcome.setDefaultCloseOperation(0);
                        welcome.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                WelcomeUI ui = (WelcomeUI)e.getSource();
                                ui.getHandler().close(ui);
                            }

                            @Override
                            public void windowClosed(WindowEvent e) {
                                session.save();
                                IsisFish.quit();
                            }
                        });
                        try (InputStream imageStream = WelcomeUI.class.getResourceAsStream("/images/simulation.gif");){
                            BufferedImage image = ImageIO.read(imageStream);
                            welcome.setIconImage(image);
                        }
                        catch (IOException ex) {
                            if (!log.isErrorEnabled()) break block14;
                            log.error((Object)"Can't set frame icon", (Throwable)ex);
                        }
                    }
                    welcome.setLocationRelativeTo(null);
                    session.add((Component)welcome);
                    WelcomeTabUI tabUI = (WelcomeTabUI)welcome.getWelcomePanelUI().getComponent(1);
                    tabUI.getSimulUI().getBodyTabbedPane().setSelectedIndex(0);
                    tabUI.getSensitivityUI().getBodyTabbedPane().setSelectedIndex(0);
                    welcome.setExtendedState(welcome.getExtendedState() & 0xFFFFFFFE);
                    welcome.setVisible(true);
                    SimulationService service = SimulationService.getService();
                    SimulationMonitor.getInstance().reloadConfig(service);
                }
            });
        } else if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"isisfish.message.launchui.notlaunch", (Object[])new Object[0]));
        }
    }

    static class VCSActionAsker
    implements VetoableActionListener {
        VCSActionAsker() {
        }

        @Override
        public boolean canDoAction(VCS vcs, VCSActionEvent action, File ... files) {
            boolean result = true;
            if (action == VCSActionEvent.SWITCH_PROTOCOL) {
                result = IsisFish.ask(I18n.t((String)"isisfish.vcs.switchprotocol.confirm", (Object[])new Object[0]));
                if (!result) {
                    vcs.setWriteable(false);
                }
            } else if (action == VCSActionEvent.SWITCH) {
                result = IsisFish.ask(I18n.t((String)"isisfish.vcs.switchversion.confirm", (Object[])new Object[]{IsisConfig.getVersion()}));
                if (!result) {
                    vcs.setWriteable(false);
                }
            } else if (action == VCSActionEvent.UPDATE_REPOSITORY) {
                String modifiedFiles = "";
                String separator = "";
                for (File file : files) {
                    modifiedFiles = modifiedFiles + separator + file.toString();
                    separator = "\n";
                }
                JLabel labelModifiedFiles = new JLabel(I18n.t((String)"isisfish.vcs.updaterepository.confirm", (Object[])new Object[0]));
                JTextArea areaModifiedFiles = new JTextArea(modifiedFiles);
                areaModifiedFiles.setEditable(false);
                areaModifiedFiles.setAutoscrolls(true);
                JScrollPane sp = new JScrollPane(areaModifiedFiles);
                sp.setPreferredSize(new Dimension(500, 100));
                result = IsisFish.ask(new Component[]{labelModifiedFiles, sp});
            }
            return result;
        }
    }

    public static class IsisQuitHook
    extends Thread {
        @Override
        public void run() {
            try {
                config.doAction(3);
            }
            catch (Exception eee) {
                log.info((Object)"Error in quit daemon", (Throwable)eee);
            }
        }
    }
}

