/*
 * #%L
 * IsisFish
 * 
 * $Id: RendererHelper.java 4277 2015-06-21 17:24:03Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/util/RendererHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import static org.nuiton.i18n.I18n.t;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import fr.ifremer.isisfish.util.Doc;

/**
 * Common format utils methods mostly used in renderers.
 *
 * @author chatellier
 * @version $Revision: 4277 $
 * 
 * Last update : $Date: 2015-06-21 19:24:03 +0200 (dim., 21 juin 2015) $
 * By : $Author: echatellier $
 */
public class RendererHelper {

    protected static final String DOCUMENTATION_SUBTITLE = "<html><b>%s</b>%s<font color='gray'>%s</font></html>";
    protected static final String COMPILATION_SUBTITLE = "<html><b color='red'>%s</b>%s<font color='red'>%s</font></html>";

    /**
     * Return HTML formatted tooltip.
     * 
     * Use optional documentation (if any) or use @Doc's class doc.
     * 
     * @param doc the doc to use
     * @param optionalDocumentations optional documentation
     * @return a string nicely print version
     */
    public static String docToString(Doc doc, String... optionalDocumentations) {
        
        String tooltip = null;
        
        if (doc != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (!ArrayUtils.isEmpty(optionalDocumentations)) {
                for (String optionalDocumentation : optionalDocumentations) {
                    sb.append("<p>" + optionalDocumentation + "</p>");
                }
            } else {
                sb.append("<p>" + doc.value() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.author())) {
                sb.append("<p><b>author: </b>" + doc.author() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.date())) {
                sb.append("<p><b>date: </b>" + doc.date() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.version())) {
                sb.append("<p><b>version: </b>" + doc.version() + "</p>");
            }
            sb.append("</html>");
            tooltip = sb.toString();
            
            // replace all \n by <br/>
            tooltip = tooltip.replace("\n", "<br/>");
        }
        return tooltip;
    }

    public static String getNameAndDocListString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, "<br />", documentation);
        return result;
    }

    public static String getNameAndCompListString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, "<br />", t("isisfish.error.compile.documentationerror"));
        return result;
    }
    
    public static String getNameAndDocComboString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, " - ", documentation);
        return result;
    }

    public static String getNameAndCompComboString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, " - ", t("isisfish.error.compile.documentationerror"));
        return result;
    }
}
