package fr.ifremer.isisfish.ui.sensitivity.wizard;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorListModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n.t;

public class EquationContinuousPanelUI extends ContinuousPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_SELECTED_FACTOR = "selectedFactor";
    public static final String PROPERTY_TEXT = "text";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISTRIBUTION_PANEL_ENABLED = "distributionPanel.enabled";
    public static final String BINDING_EDITOR_BEAN = "editor.bean";
    public static final String BINDING_EDITOR_BEAN_PROPERTY = "editor.beanProperty";
    public static final String BINDING_EDITOR_CLAZZ = "editor.clazz";
    public static final String BINDING_EDITOR_FORMULE = "editor.formule";
    public static final String BINDING_EDITOR_FORMULE_CATEGORY = "editor.formuleCategory";
    public static final String BINDING_EDITOR_SELECTED_EQUATION = "editor.selectedEquation";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWT28bRRSfuHVSJ2n+tiEVBQVwBQJpTEFClVKFtkkMDi6t4rQqNQfG3nEy0XpmOzPrrHNAfAQ+Aty5IHHjhDhw5sAF8RUQ4sAV8WZ2vet1Nq7FqjnMOvPe+73fezPvvfnuT1RUEr12TIIAS59r1qV47+6TJw9ax7Std6hqS+ZpIVH4N1VAhSaac+J9pdEbzboxr0TmlW3R9QSnfMh6s45mle67VB1RqjV6JW3RVqrSiMWbgefLAWpMKgv1m7//KnztfPVtAaHAA3bXIJSN51klkVysowJzNFoBTz1ScQk/BBqS8UPge9nsbbtEqU9Jlz5DX6KZOpr2iAQwjV6fPGSLYe0DT6Pl8rYAG+4LXz0knLrvarTdkZh1JO1S+CqmOkwdYZ9hRblimvWY7uMTdkqkg3ef+UQzwUdAHtU8z/qY1uiipgEwXDL8sYkJhzENabQo4Rq9L+Qh5j7TgmMtPEawRyW415S3KT4wO7vgRfeNM8AkLZcmIPMG5KEUYKP7Zm8hkRXbLjk91Wgx4WCzkGgsdoTs+pAcoumhkKMAS4q6cP2oM4hXoxtZSaKGH6MqzksCMRN50Kg81rIaqiWGCwPfVdKGc4QjS6K4J4QLYQ97sUpQBQtWy9fMxXXIYaJyubzXaEvhuuak4LRfMooBVidwJnhIZNRLCXD5wOQb9NdTFzo0szKjeSPbzU2z+aZZ3kpyGlE17O4Lh7oa3Zrg4nWNKg5zEZsm0c0NoUapimMze0btnVj7StnsNWyC4bQsFoT46rDZWQ1vNCs2vLfT4UWi92LRB7HoUnmvTlrW00qaoNk1Srdi3eUekcwAmaqvMupCf1hLGR1AKVjBiKEDvCVr+Ya2LUqNdicv7KSgd0Zx0sGUynv3fA01C9GspoiF22ntC8SxPHfTyZoGTqJHsyTUYfbWn3c3GPd8jWlUb7hm/n3A6aAAH9UiPIleTl1c6PE46fFJE55qoqKEAoQSWm+eHQv7IAoHwvrIQDCAVvrv2upvP/7xQ3UwBa6C76uZqkNDDLqzFzYvZlwvhiPAlG/lPvE2m6gUtgFb29cziDUiMZADf8tJ9X9M1BFAFGd+/+nntS9+vYAKVTTrChL1kxoq6SMJWRCuE3gf3rGM5k8uwbpkuMERuKQv4CzRwm2HaLLRYtyBA94KIAnXM5IQM2mVfvlntfH9nUEipoDYtXPVk2QUn6Jpxl3GqR2I0azLHIBznqK+I5KZljXlpsx31ovKdt+uj7MinW9T192n3KGSSqP1WeCbz1NL3vz63GLdnACraBtVTpAZyk3tO2NgNieAiUbwyu0wqxtEhxVNt/4vptk+HsNqKzfC3dwIOxMhCLN4Lwrho9xR1HJzeD4C1Dj0AhY24HNQPpkA5QrxtWiQHoUxyTqsbTtwTkz7OByTn0kwzrwNc2CFb8mcIIPHYE6YrFdrDrgzr9xcePG1HIPwH1qmam/vDQAA";
    private static final Log log = LogFactory.getLog(EquationContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected ContinuousDistributionPanel distributionPanel;
    protected InputOneEquationUI editor;
    protected List<Factor> factors;
    protected JList<Factor> factorsList;
    protected FactorListModel factorsListModel;
    protected Formule formule;
    protected String formuleCategory;
    protected JButton remove;
    protected Equation selectedEquation;
    protected Boolean selectedFactor;
    protected String text;
    protected JTextField variableNameField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EquationContinuousPanelUI $ContinuousPanel0 = this;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void initWithFactor(Factor factor) {
        addFactor(factor);
    }
    
    protected void addFactor(Factor factor) {
        factors.add(factor);
        // fire data change
        factorsListModel.setFactors(factors);
    }
    
    /**
     * Valid selected factor.
     */
    protected void validSelectedFactor() {
        // fill selected
        Factor selectedFactor = (Factor)factorsList.getSelectedValue();
        selectedFactor.setEquationVariableName(variableNameField.getText().trim());
        selectedFactor.setDomain(distributionPanel.generateDomain());
    
        // parse equation content to replace
        // double xxx = 4.0;
        // by
        // double xxx = context.getValueAndCompute("myfactorname.xxx", 4.0)
        // if xxx is the variable name to replace
        FactorWizardUI wizard = getParentContainer(FactorWizardUI.class);
        String factorName = wizard.getFactorNameField().getText().trim();
        String variableName = selectedFactor.getEquationVariableName();
        String[] lines = editor.getEditor().getText().split("\n");
        String result = "";
        for (String line : lines) {
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(line);
            if (matcher.find()) {
                String fullVariableName = factorName + "." + variableName;
                line = matcher.group(1) +  "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result += line + "\n";
        }
        editor.getEditor().setText(result);
        
        // fire data change
        factorsListModel.setFactors(factors);
    }
    
    protected void addNewVariable() {
        Factor factor = new Factor("");
        factor.setEquationVariableName("X");
        addFactor(factor);
        
        // auto select
        factorsList.setSelectedValue(factor, true);
    }
    
    protected void displaySelectedFactor() {
        Factor selectedFactor = (Factor)factorsList.getSelectedValue();
        variableNameField.setText(selectedFactor.getEquationVariableName());
        distributionPanel.initWithFactor(selectedFactor);
    }
    
    protected void removeSelectedVariable() {
        int selectedIndex = factorsList.getSelectedIndex();
        factors.remove(selectedIndex);
        
        // fire data change
        factorsList.clearSelection();
        factorsListModel.setFactors(factors);
    }
    
    @Override
    public boolean isFactorValid() {
        boolean valid = true;
    
        for (Factor factor : factors) {
            if (StringUtils.isBlank(factor.getEquationVariableName())) {
                valid = false;
            }
            if (factor.getDomain() == null) {
                valid = false;
            }
        }
        
        return valid;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EquationContinuousPanelUI() {
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSelectedFactor();
    }

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addNewVariable();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectedVariable();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displaySelectedFactor();setSelectedFactor(factorsList.getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class getClazz() {
        return clazz;
    }

    public ContinuousDistributionPanel getDistributionPanel() {
        return distributionPanel;
    }

    public InputOneEquationUI getEditor() {
        return editor;
    }

    public List<Factor> getFactors() {
        return factors;
    }

    public JList<Factor> getFactorsList() {
        return factorsList;
    }

    public FactorListModel getFactorsListModel() {
        return factorsListModel;
    }

    public Formule getFormule() {
        return formule;
    }

    public String getFormuleCategory() {
        return formuleCategory;
    }

    public JButton getRemove() {
        return remove;
    }

    public Equation getSelectedEquation() {
        return selectedEquation;
    }

    public Boolean getSelectedFactor() {
        return selectedFactor;
    }

    public String getText() {
        return text;
    }

    public JTextField getVariableNameField() {
        return variableNameField;
    }

    public Boolean isSelectedFactor() {
        return selectedFactor !=null && selectedFactor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setSelectedFactor(Boolean selectedFactor) {
        Boolean oldValue = this.selectedFactor;
        this.selectedFactor = selectedFactor;
        firePropertyChange(PROPERTY_SELECTED_FACTOR, oldValue, selectedFactor);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanProperty() {
        $objectMap.put("beanProperty", beanProperty = null);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createDistributionPanel() {
        $objectMap.put("distributionPanel", distributionPanel = new ContinuousDistributionPanel(0.0d));
        
        distributionPanel.setName("distributionPanel");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new InputOneEquationUI(this));
        
        editor.setName("editor");
        editor.setActive(true);
        editor.setAutoSaveModification(false);
    }

    protected void createFactors() {
        $objectMap.put("factors", factors = new ArrayList<Factor>());
    }

    protected void createFactorsList() {
        $objectMap.put("factorsList", factorsList = new JList<Factor>());
        
        factorsList.setName("factorsList");
    }

    protected void createFactorsListModel() {
        $objectMap.put("factorsListModel", factorsListModel = new FactorListModel(factors));
    }

    protected void createFormule() {
        $objectMap.put("formule", formule = null);
    }

    protected void createFormuleCategory() {
        $objectMap.put("formuleCategory", formuleCategory = null);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSelectedEquation() {
        $objectMap.put("selectedEquation", selectedEquation = null);
    }

    protected void createSelectedFactor() {
        $objectMap.put("selectedFactor", selectedFactor = false);
    }

    protected void createText() {
        $objectMap.put("text", text = null);
    }

    protected void createVariableNameField() {
        $objectMap.put("variableNameField", variableNameField = new JTextField());
        
        variableNameField.setName("variableNameField");
        variableNameField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $ContinuousPanel0
        add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(factorsList);
        // inline complete setup of $Table1
        $Table1.add($Table2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(distributionPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        factorsList.setCellRenderer(new fr.ifremer.isisfish.ui.sensitivity.model.FactorListRenderer());
        factorsList.setModel(factorsListModel);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ContinuousPanel0", $ContinuousPanel0);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormuleCategory();
        createSelectedEquation();
        createFormule();
        createSelectedFactor();
        createFactors();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFactorsListModel();
        createFactorsList();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = factorsList.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.sensitivity.equation.variablename"));
        createVariableNameField();
        createDistributionPanel();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.sensitivity.equation.valid"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdd();
        createRemove();
        createEditor();
        // inline creation of $ContinuousPanel0
        setName("$ContinuousPanel0");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                variableNameField.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTRIBUTION_PANEL_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                distributionPanel.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                editor.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN_PROPERTY, true ,"beanProperty") {
        
            @Override
            public void processDataBinding() {
                editor.setBeanProperty(getBeanProperty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_CLAZZ, true ,"clazz") {
        
            @Override
            public void processDataBinding() {
                editor.setClazz(getClazz());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE, true ,"formule") {
        
            @Override
            public void processDataBinding() {
                editor.setFormule(getFormule());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE_CATEGORY, true ,"formuleCategory") {
        
            @Override
            public void processDataBinding() {
                editor.setFormuleCategory(getFormuleCategory());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_SELECTED_EQUATION, true ,"selectedEquation") {
        
            @Override
            public void processDataBinding() {
                editor.setSelectedEquation(getSelectedEquation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                editor.setText(t(getText()));
            }
        });
    }

}