/*
 * #%L
 * $Id: LoggingFrame.java 4263 2015-06-11 09:01:47Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/logging/LoggingFrame.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.logging;

import static org.nuiton.i18n.I18n.t;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import org.apache.commons.io.FileUtils;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.ui.widget.text.IsisSyntaxConstants;
import fr.ifremer.isisfish.ui.widget.text.SyntaxEditorUI;

/**
 * Standalone frame to display log file with syntax highlight.
 * 
 * @author Eric Chatellier
 */
public class LoggingFrame extends JFrame {

    /** serialVersionUID. */
    private static final long serialVersionUID = -655585012872692567L;

    protected SyntaxEditorUI editor;

    public LoggingFrame() {
        editor = new SyntaxEditorUI();
        editor.setStyle(IsisSyntaxConstants.SYNTAX_STYLE_LOG);

        add(editor);

        setSize(800, 600);
    }
    
    /**
     * Return menu bar configured for {@code textArea} component.
     * 
     * @param parent parent
     * @return JMenuBar instance
     */
    public JMenuBar createMenuBar(Frame parent) {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu(t("isisfish.script.search"));
        menu.add(new JMenuItem(editor.getFindAction()));
        menu.add(new JMenuItem(editor.getReplaceAction()));
        menu.add(new JMenuItem(editor.getGotoAction()));
        mb.add(menu);

        return mb;
    }

    public void loadSimulationLog(String simulationName) throws IOException {
        setTitle(t("isisfish.simulation.log.console.title", simulationName));

        SimulationStorage storage = SimulationStorage.getSimulation(simulationName);
        File logFile = new File(storage.getSimulationLogFile());
        String content = FileUtils.readFileToString(logFile);
        editor.setText(content);
    }
}
