package fr.ifremer.isisfish.ui.input.species;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SpeciesUI extends InputContentUI<fr.ifremer.isisfish.entities.Species> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_SPECIES_CEE_ENABLED = "fieldSpeciesCEE.enabled";
    public static final String BINDING_FIELD_SPECIES_CEE_TEXT = "fieldSpeciesCEE.text";
    public static final String BINDING_FIELD_SPECIES_CODE_RUBBIN_ENABLED = "fieldSpeciesCodeRubbin.enabled";
    public static final String BINDING_FIELD_SPECIES_CODE_RUBBIN_TEXT = "fieldSpeciesCodeRubbin.text";
    public static final String BINDING_FIELD_SPECIES_COMMENT_ENABLED = "fieldSpeciesComment.enabled";
    public static final String BINDING_FIELD_SPECIES_COMMENT_TEXT = "fieldSpeciesComment.text";
    public static final String BINDING_FIELD_SPECIES_NAME_ENABLED = "fieldSpeciesName.enabled";
    public static final String BINDING_FIELD_SPECIES_NAME_TEXT = "fieldSpeciesName.text";
    public static final String BINDING_FIELD_SPECIES_SCIENTIFIC_NAME_ENABLED = "fieldSpeciesScientificName.enabled";
    public static final String BINDING_FIELD_SPECIES_SCIENTIFIC_NAME_TEXT = "fieldSpeciesScientificName.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";
    private static final String BINDING_$SPECIES_STRUCTURED_UI0_ACTIVE = "$SpeciesStructuredUI0.active";
    private static final String BINDING_$SPECIES_STRUCTURED_UI0_BEAN = "$SpeciesStructuredUI0.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS2/TQBDehPQFFApVS6EFCkQIAXJKeQjRij5SorYKDzUFoebCxt40Wzm22V0Hc0H8BH4C3LkgceOEOHDmwAXxFxDiwBUxa+fldHGNnMM62Znvm29mx7N5+wP1cYbO7GDP05hrCVon2vrS48f3KztEFyuE64w6wmYo+KTSKF1GB4z2PhfoXLko4bkmPJe3645tEasLPVdE+7l4bhJeI0QIdDKM0DnPldrmOc9xWYu1LUrF+vrXz/Qr4+WbNEKeA+qOQyrTe6E6mWSKKE0NgY5CpAbOmdjaBhmMWtugd1ju5U3M+T1cJ0/RCzRQRP0OZkAm0Nn4KfscPt5zBBrJrlmOK/K2JcD94dqMQFqVabTKSJ3Ak1NepbymuVSj0lHjDtEp4VopeD5ccxyfrV+gTIVgS6CsCg/kVHThOqiBGrYMkzCBrv5P4NUA1eEZamCTGhhSFehSqOhtg8afQTG1klwftTa79dvGcyi/rLTX9F1/gC1idqnNbuKKSaBME6EYgbdvk55jvYAr8ucJuUy0TYPZ9SKuEHOmN6a/K50m274jVUpMo5m77ACBxkOYTeKJgvQJ41ox/Pinw7YT3ZwlWCCVKtVb/XVWzTSrYBrvZsrbBtlwKxVqRbBcVbAcDrHcuRMBv6aAj2VbqQjm6sJlxPD7+eb/tFU3Vh36uiL0cHa9pDPbNGW3QMhjoaPpmMKo0XDV6nX/VR7bdaxLjGAJudHbVLOKpspw3IDmGA2xLLtC2P5xzLcd+3Vs6UGbLfZaIKAgKotBTBK2MDQZehFgdmqd2dkZbqky6mMubMObU949bjfAFAzaiZ5BKwl965/x0a8fvr8vtKbrNMQeU7p2XQ4w9RxmOzBeqAx9OBitrqBm7i525spoiENKenBzTCmElZpmEAfxjki4JuHaKuY1oOgb+Pbx0/iTL/tQuoD2mzY2Clj6r6EhUWNQBds0PGdh0Vd08NkgrCNSGxwiseQhwsA/NA+TCE/DG2PAcd32oApTiiq0pVSGPv8eLb1bbFUiBcqO/9O9U42+LdRPLZNaxL9pmpeI8mY54HDiGnbnslBdHyn5POU0p2PRXx+oUs0IaGOYcvNB9Gks4FqruIJArhK06Schvz2KySm3N+RSUjOcicWwlZghSkM2voZyEoYoDecT1yEeQ5SGC4nrEI8hSsPFxHWIxxCl4XLiOsRjiNKgJa5DPIYoDTOJ67A3A9xVMIZpg0TomI0zueR/2kQce1XjeuJqxGOI0nArcVfEY4jSsJC4DvEYojQsJ9YQjyFKw0piDfEYojQUEmuQDH8B9/TxQ80PAAA=";
    private static final Log log = LogFactory.getLog(SpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Species bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextField fieldSpeciesCEE;
    protected JTextField fieldSpeciesCodeRubbin;
    protected JTextArea fieldSpeciesComment;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldSpeciesName")
    protected JTextField fieldSpeciesName;
    protected JTextField fieldSpeciesScientificName;
    protected SpeciesHandler handler;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Species> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SpeciesUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private SpeciesStructuredUI $SpeciesStructuredUI0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
        
        @Override
        protected void goTo() {
            handler.goTo();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SpeciesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesUI() {
        $initialize();
    }

    public SpeciesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SpeciesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Species.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldSpeciesCEE(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCodeCEE(Integer.parseInt(fieldSpeciesCEE.getText()));
    }

    public void doKeyReleased__on__fieldSpeciesCodeRubbin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCodeRubbin(fieldSpeciesCodeRubbin.getText());
    }

    public void doKeyReleased__on__fieldSpeciesComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldSpeciesComment.getText());
    }

    public void doKeyReleased__on__fieldSpeciesName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldSpeciesName.getText());
    }

    public void doKeyReleased__on__fieldSpeciesScientificName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setScientificName(fieldSpeciesScientificName.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Species getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextField getFieldSpeciesCEE() {
        return fieldSpeciesCEE;
    }

    public JTextField getFieldSpeciesCodeRubbin() {
        return fieldSpeciesCodeRubbin;
    }

    public JTextArea getFieldSpeciesComment() {
        return fieldSpeciesComment;
    }

    public JTextField getFieldSpeciesName() {
        return fieldSpeciesName;
    }

    public JTextField getFieldSpeciesScientificName() {
        return fieldSpeciesScientificName;
    }

    public SpeciesHandler getHandler() {
        return handler;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Species> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Species bean) {
        Species oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected SpeciesStructuredUI get$SpeciesStructuredUI0() {
        return $SpeciesStructuredUI0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldSpeciesCEE() {
        $objectMap.put("fieldSpeciesCEE", fieldSpeciesCEE = new JTextField());
        
        fieldSpeciesCEE.setName("fieldSpeciesCEE");
        fieldSpeciesCEE.setColumns(15);
        fieldSpeciesCEE.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSpeciesCEE"));
        fieldSpeciesCEE.putClientProperty("sensitivityBean", Species.class);
        fieldSpeciesCEE.putClientProperty("sensitivityMethod", "CodeCEE");
    }

    protected void createFieldSpeciesCodeRubbin() {
        $objectMap.put("fieldSpeciesCodeRubbin", fieldSpeciesCodeRubbin = new JTextField());
        
        fieldSpeciesCodeRubbin.setName("fieldSpeciesCodeRubbin");
        fieldSpeciesCodeRubbin.setColumns(15);
        fieldSpeciesCodeRubbin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSpeciesCodeRubbin"));
        fieldSpeciesCodeRubbin.putClientProperty("sensitivityBean", Species.class);
        fieldSpeciesCodeRubbin.putClientProperty("sensitivityMethod", "CodeRubbin");
    }

    protected void createFieldSpeciesComment() {
        $objectMap.put("fieldSpeciesComment", fieldSpeciesComment = new JTextArea());
        
        fieldSpeciesComment.setName("fieldSpeciesComment");
        fieldSpeciesComment.setColumns(15);
        fieldSpeciesComment.setLineWrap(true);
        fieldSpeciesComment.setWrapStyleWord(true);
        fieldSpeciesComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSpeciesComment"));
    }

    protected void createFieldSpeciesName() {
        $objectMap.put("fieldSpeciesName", fieldSpeciesName = new JTextField());
        
        fieldSpeciesName.setName("fieldSpeciesName");
        fieldSpeciesName.setColumns(15);
        fieldSpeciesName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSpeciesName"));
    }

    protected void createFieldSpeciesScientificName() {
        $objectMap.put("fieldSpeciesScientificName", fieldSpeciesScientificName = new JTextField());
        
        fieldSpeciesScientificName.setName("fieldSpeciesScientificName");
        fieldSpeciesScientificName.setColumns(15);
        fieldSpeciesScientificName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldSpeciesScientificName"));
        fieldSpeciesScientificName.putClientProperty("sensitivityBean", Species.class);
        fieldSpeciesScientificName.putClientProperty("sensitivityMethod", "ScientificName");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SpeciesHandler(this));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Species.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldSpeciesName)), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSpeciesScientificName), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSpeciesCodeRubbin), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSpeciesCEE), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($SpeciesStructuredUI0), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldSpeciesComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.species.name"));
        createFieldSpeciesName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.species.scientificName"));
        createFieldSpeciesScientificName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.species.rubbinCode"));
        createFieldSpeciesCodeRubbin();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.species.cee"));
        createFieldSpeciesCEE();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.species.structured"));
        // inline creation of $SpeciesStructuredUI0
        $objectMap.put("$SpeciesStructuredUI0", $SpeciesStructuredUI0 = new SpeciesStructuredUI());
        
        $SpeciesStructuredUI0.setName("$SpeciesStructuredUI0");
        $SpeciesStructuredUI0.putClientProperty("sensitivityBean", Species.class);
        $SpeciesStructuredUI0.putClientProperty("sensitivityMethod", "AgeGroupType");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.species.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldSpeciesComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSpeciesName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_SCIENTIFIC_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesScientificName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_SCIENTIFIC_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSpeciesScientificName, jaxx.runtime.SwingUtil.getStringValue(getBean().getScientificName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_CODE_RUBBIN_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesCodeRubbin.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_CODE_RUBBIN_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSpeciesCodeRubbin, jaxx.runtime.SwingUtil.getStringValue(getBean().getCodeRubbin()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_CEE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesCEE.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_CEE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSpeciesCEE, String.valueOf(getBean().getCodeCEE()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$SPECIES_STRUCTURED_UI0_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $SpeciesStructuredUI0.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$SPECIES_STRUCTURED_UI0_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                $SpeciesStructuredUI0.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldSpeciesComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}