package fr.ifremer.isisfish.ui.input.species;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SpeciesStructuredUI extends InputContentUI<fr.ifremer.isisfish.entities.Species> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_SPECIES_DYNAMIC_AGE_ENABLED = "fieldSpeciesDynamicAge.enabled";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_AGE_SELECTED = "fieldSpeciesDynamicAge.selected";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_ENABLED = "fieldSpeciesDynamicLength.enabled";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_SELECTED = "fieldSpeciesDynamicLength.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rZTyQwUhEFBMEPFg1K2JHjQgghCkpIqhkhB7cdqdtkO2s+PMrCwX45/gn6B3LybePBkPnj14Mf4LxnjwanyzW3a3ukKDPew28973ve97896+/gY5JeHcDvF9S3pcsxa11pe2tzeqO7SmV6iqSSa0KyH8ZbKQrcCgHZ0rDecrJQMvtOGFZbclXE55Aj1XggGl9xyqmpRqDWc7ETWlCuUoPOcLT+6zRqLSWF/++J59YT9/lQXwBarrQyvTh6FiJz0lyDJbwwhWekoKDuENlCEZb6DeE+Zs2SFK3Sct+gSeQb4EvYJIJNMw073lgCPA+0LD8GyRC08vu1xj+lbxqoYbdWmxuqQtim/FVJ2ppuUxi5lESwlaY1RZ5fCN+rya9iS1t4pCBLy9GnqqlHANs2lMWIbpBEOMyjcJtx0qNdw6moS1EJ/U4dp72FDTO99Su9hKa/0B4dRJVJ19SKoOReMTHVcVZgcxkzkSAcbrjDp2u/jKHictVltq0ACfKLNJbObe8bR2uQGORfjJFHyJ8oZumoTTnclDKnJ3V7oe3thMikqzIWGpIAnNSTjTkYcjbcUjHc9cpgI56eExyq/8vQWbGArnf+KP+TeEQfTX+Ojnd1/friaHfiw1NbGzOIxCugLvmpnSQ+HEe5o5hXtEzFWgX1EHFz5Y6KkUYeV2GMVhvVMGbhm4tUZUEyly+S/vP4w//nQMsqsw4LjEXiUmvwj9uimxC65j++L2YqDo+G4fPoeNNg2D1biRODrzjDuM02micRMxRBd87MZUSjciSdX+jz9Hy28W9zuSQYWT/0yPu5J7BL1hteBD0N7x1MUfFIp6thvvctp2Z8x7UrRH/ULwvJhmOU+5GXP89Jyct4km01XGbZwrtGowVwIP5l+ha8q+8P5o4OL60Xl6NPW1iV4+Koc5vnQAw1RXDNcO8NEdw83/Zlg4xMVvehvxQj0HAAA=";
    private static final Log log = LogFactory.getLog(SpeciesStructuredUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Species bean;
    protected JRadioButton fieldSpeciesDynamicAge;
    protected JRadioButton fieldSpeciesDynamicLength;
    protected SpeciesStructuredHandler handler;
    protected JAXXButtonGroup structuredGroup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SpeciesStructuredUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesStructuredUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SpeciesStructuredUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesStructuredUI() {
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SpeciesStructuredUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__fieldSpeciesDynamicAge(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.dynamicChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Species getBean() {
        return bean;
    }

    public JRadioButton getFieldSpeciesDynamicAge() {
        return fieldSpeciesDynamicAge;
    }

    public JRadioButton getFieldSpeciesDynamicLength() {
        return fieldSpeciesDynamicLength;
    }

    public SpeciesStructuredHandler getHandler() {
        return handler;
    }

    public JAXXButtonGroup getStructuredGroup() {
        return structuredGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Species bean) {
        Species oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToFieldSpeciesDynamicAge() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = structuredGroup; fieldSpeciesDynamicAge.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSpeciesDynamicAge); }
    }

    protected void addChildrenToFieldSpeciesDynamicLength() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = structuredGroup; fieldSpeciesDynamicLength.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSpeciesDynamicLength); }
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldSpeciesDynamicAge() {
        $objectMap.put("fieldSpeciesDynamicAge", fieldSpeciesDynamicAge = new JRadioButton());
        
        fieldSpeciesDynamicAge.setName("fieldSpeciesDynamicAge");
        fieldSpeciesDynamicAge.setText(t("isisfish.species.age"));
        fieldSpeciesDynamicAge.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSpeciesDynamicAge"));
    }

    protected void createFieldSpeciesDynamicLength() {
        $objectMap.put("fieldSpeciesDynamicLength", fieldSpeciesDynamicLength = new JRadioButton());
        
        fieldSpeciesDynamicLength.setName("fieldSpeciesDynamicLength");
        fieldSpeciesDynamicLength.setText(t("isisfish.species.length"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SpeciesStructuredHandler(this));
    }

    protected void createStructuredGroup() {
        $objectMap.put("structuredGroup", structuredGroup = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(fieldSpeciesDynamicAge, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldSpeciesDynamicLength, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFieldSpeciesDynamicAge();
        addChildrenToFieldSpeciesDynamicLength();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldSpeciesDynamicAge();
        createFieldSpeciesDynamicLength();
        createStructuredGroup();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_AGE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesDynamicAge.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_AGE_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldSpeciesDynamicAge.setSelected(getBean().isAgeGroupType());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesDynamicLength.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldSpeciesDynamicLength.setSelected(!getBean().isAgeGroupType());
                }
            }
        });
    }

}