package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class WizardGroupCreationUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHxyaJ66SQ4DShgUBDiYRAYp04SUOV0iYNuE3ktlCntOADjL1je8p6dpmdTTZB4qc4gpC4cIQ7FyRunCoOnDlwQfwLCHHgingz63iz8WRrMTnseufN+8z3vfn18v2faNjn6Nn7OAwtHjBBO8Ta3rh371b9PmmIV4nf4NQTLkfRXyaLsjU0ZvfafYGeq1Wke7HrXtx0O57LCDvivVZBo77Yd4jfJkQI9HTSo+H7xWrPvBZ6AT+k9kTpqN/+/Vf2K/vj77IIhR6oK0Eocw/ziiMZqqAstQUqwEi7uOhg1gIZnLIW6H1Utm062Pdv4g55H32IchU04mEOMIHODx6yYij/0BNobI8eYG5f424AX680uUWbnHQIvH3qN6nftgJqUeYFwvJcL3CwoC6z7sZem5yotjtbnqe4IwLl2pjZDuECXTUgXo8gMfZ0JPZ1zIgDE12QKQktfw8yZG2rVtkxH8uY38F1hywIdDYxC5GHssme4z2HU/PbFVwnzsJxuGqVnQq9vjN10qJMCa4Q1hLtnX2PbMmw1HBHnG9jm7pXod1lScSsDlGF6a3SA6XsyWT/c7r+8Lkn2psB39W5dFOwKD/P6INVtifk41yfraSzNSlss40WEWg6EecOCUWZEsfWs5Y0rBwsRomSn8/r3ZZT5K2k2C7ohouyUUrJxmrPrdRne1ljm1DZUPMezUkvlH7/ixr/yQ4OaQc7alb9ExH5w8la0DC6YS1pwur5xbO83m8saYzjKjC5Eo+J0vgvafyn/O5Cvhl06oTfaqoI0yjLGspoS3rdhWMxVcBKWnQX0oyrGmM3n8tp+YzXwpv9xosa41Qr3qhlmdpkPvoppQUNpdCUG0yfUg1iUadSIaqCpHqWdJ4M78bn2JnkYTvkcbIL6zlxJMS923FHBueE/O0k20ealMHtoLM0MGtE5+8xy3greRjCTag56WUBESlRCYMLhaOnEv3gxrfiGz++kjM1NMwDaIYzvdZfJNwGU1QenD1WHkigsv47PfnbT3/8WD6sCV6Esae0XY+UNHBXe9z14AKlcujxqCAIBHWKN7C3VkN5nzhQD6l6Z1YjrNo1gzgY73Hpbkl36zr224AYzv3+4Ofpd399BGXLaNRxsV3Gsv8Wyos2hyy4jh16V9aVotN7p+A5IbXBXDh435V33GOXbCzwXJ0yG3J8OYQkzGqS0FNSz//yz2T1h/XDRGRA2MyJ3eNkDL+NRihzKCOqPJITnzuhHBrzfBLYblzh6GqejHyPet2q4gP1/Kg/Utn8iXx8Ggby9ZmSLH99rmwTDyXAXmi7nB64TGBnw6Et1lG1WuFSFM4cFlDc1QNBLuuHmB5giCHR3Uxf/n/GWD3eGymomYFy9rUx4ZsUwqyxhsEIaRqeMdYwGOGLFMJ5Yw3mhHljwgvGhJeMCUVjwqLxbK4YazAnrBoT1owJV4wzuWmswZzwmjFhy5hww5jwhjGhaky4Y7we3jLWYE6oGRPeMSY0jAmtAQqJHGHy/yY7BfOesRBzAhuEkJlJIXjGGswJHAj/AWQsza4vFQAA";
    private static final Log log = LogFactory.getLog(WizardGroupCreationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton beginGroupLengthTypeGrowthCurve;
    protected JRadioButton beginGroupLengthTypeInput;
    protected JRadioButton beginGroupLengthTypeSameSize;
    protected JButton cancel;
    protected JTextField fieldNumberOfGroup;
    protected JTextField fieldStep;
    protected JButton finish;
    protected JTextField firstAge;
    protected JTextField firstInputLength;
    protected JTextField firstSizeLength;
    protected JAXXButtonGroup groupLengthType;
    protected JTextField groupWidth;
    protected JTextField growthCurveFirstGroup;
    protected WizardGroupCreationHandler handler;
    protected JTextField lastAge;
    protected JTextField maximalGroupsLength;
    protected Table navButton;
    protected JButton next;
    protected JButton prev;
    protected JTextField sameSizeNumberOfGroup;
    protected WizardGroupCreationUI wizardGroup = this;
    protected JPanel wizardPanels;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel11;
    private JLabel $JLabel12;
    private JLabel $JLabel13;
    private JLabel $JLabel14;
    private JLabel $JLabel15;
    private JLabel $JLabel16;
    private JLabel $JLabel17;
    private JLabel $JLabel18;
    private JLabel $JLabel19;
    private JLabel $JLabel2;
    private JLabel $JLabel20;
    private JLabel $JLabel21;
    private JLabel $JLabel22;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public WizardGroupCreationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WizardGroupCreationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WizardGroupCreationUI() {
        $initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WizardGroupCreationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginGroupLengthTypeGrowthCurve(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeInput(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeSameSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.refreshChoice();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__finish(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.finish();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next();
    }

    public void doActionPerformed__on__prev(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.prev();
    }

    public void doFocusLost__on__fieldNumberOfGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.fieldNumberOfGroupChanged();
    }

    public void doFocusLost__on__fieldStep(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.stepChanged();
    }

    public void doFocusLost__on__firstAge(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.firstAgeChanged();
    }

    public void doFocusLost__on__firstInputLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.firstInputLengthChanged();
    }

    public void doFocusLost__on__firstSizeLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.firstSizeLengthChanged();
    }

    public void doFocusLost__on__groupWidth(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.groupWidthChanged();
    }

    public void doFocusLost__on__growthCurveFirstGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.growthCurveFirstGroupChanged();
    }

    public void doFocusLost__on__lastAge(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.lastAgeChanged();
    }

    public void doFocusLost__on__maximalGroupsLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.maximalGroupsLengthChanged();
    }

    public void doFocusLost__on__sameSizeNumberOfGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.sameSizeNumberOfGroupChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getBeginGroupLengthTypeGrowthCurve() {
        return beginGroupLengthTypeGrowthCurve;
    }

    public JRadioButton getBeginGroupLengthTypeInput() {
        return beginGroupLengthTypeInput;
    }

    public JRadioButton getBeginGroupLengthTypeSameSize() {
        return beginGroupLengthTypeSameSize;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getFieldNumberOfGroup() {
        return fieldNumberOfGroup;
    }

    public JTextField getFieldStep() {
        return fieldStep;
    }

    public JButton getFinish() {
        return finish;
    }

    public JTextField getFirstAge() {
        return firstAge;
    }

    public JTextField getFirstInputLength() {
        return firstInputLength;
    }

    public JTextField getFirstSizeLength() {
        return firstSizeLength;
    }

    public JAXXButtonGroup getGroupLengthType() {
        return groupLengthType;
    }

    public JTextField getGroupWidth() {
        return groupWidth;
    }

    public JTextField getGrowthCurveFirstGroup() {
        return growthCurveFirstGroup;
    }

    public WizardGroupCreationHandler getHandler() {
        return handler;
    }

    public JTextField getLastAge() {
        return lastAge;
    }

    public JTextField getMaximalGroupsLength() {
        return maximalGroupsLength;
    }

    public Table getNavButton() {
        return navButton;
    }

    public JButton getNext() {
        return next;
    }

    public JButton getPrev() {
        return prev;
    }

    public JTextField getSameSizeNumberOfGroup() {
        return sameSizeNumberOfGroup;
    }

    public JPanel getWizardPanels() {
        return wizardPanels;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected JLabel get$JLabel18() {
        return $JLabel18;
    }

    protected JLabel get$JLabel19() {
        return $JLabel19;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel20() {
        return $JLabel20;
    }

    protected JLabel get$JLabel21() {
        return $JLabel21;
    }

    protected JLabel get$JLabel22() {
        return $JLabel22;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBeginGroupLengthTypeGrowthCurve() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeGrowthCurve.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeGrowthCurve); }
    }

    protected void addChildrenToBeginGroupLengthTypeInput() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeInput.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeInput); }
    }

    protected void addChildrenToBeginGroupLengthTypeSameSize() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = groupLengthType; beginGroupLengthTypeSameSize.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(beginGroupLengthTypeSameSize); }
    }

    protected void addChildrenToNavButton() {
        if (!allComponentsCreated) {
            return;
        }
        navButton.add(prev, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(next, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(finish, new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        navButton.add(cancel, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWizardGroup() {
        if (!allComponentsCreated) {
            return;
        }
        add(wizardPanels, BorderLayout.CENTER);
        add(navButton, BorderLayout.SOUTH);
    }

    protected void addChildrenToWizardPanels() {
        if (!allComponentsCreated) {
            return;
        }
        wizardPanels.add($Table0, "beginGroupLength");
        wizardPanels.add($Table1, "singleGroupAge");
        wizardPanels.add($Table2, "endInputGroupLength");
        wizardPanels.add($Table3, "endSameSizeGroupLength");
        wizardPanels.add($Table4, "endGrowthCurveGroupLength");
    }

    protected void createBeginGroupLengthTypeGrowthCurve() {
        $objectMap.put("beginGroupLengthTypeGrowthCurve", beginGroupLengthTypeGrowthCurve = new JRadioButton());
        
        beginGroupLengthTypeGrowthCurve.setName("beginGroupLengthTypeGrowthCurve");
        beginGroupLengthTypeGrowthCurve.setText(t("isisfish.wizardGroupCreation.computedGrowthCurve"));
        beginGroupLengthTypeGrowthCurve.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginGroupLengthTypeGrowthCurve"));
    }

    protected void createBeginGroupLengthTypeInput() {
        $objectMap.put("beginGroupLengthTypeInput", beginGroupLengthTypeInput = new JRadioButton());
        
        beginGroupLengthTypeInput.setName("beginGroupLengthTypeInput");
        beginGroupLengthTypeInput.setText(t("isisfish.wizardGroupCreation.allValues"));
        beginGroupLengthTypeInput.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginGroupLengthTypeInput"));
    }

    protected void createBeginGroupLengthTypeSameSize() {
        $objectMap.put("beginGroupLengthTypeSameSize", beginGroupLengthTypeSameSize = new JRadioButton());
        
        beginGroupLengthTypeSameSize.setName("beginGroupLengthTypeSameSize");
        beginGroupLengthTypeSameSize.setText(t("isisfish.wizardGroupCreation.allGroupsSameSize"));
        beginGroupLengthTypeSameSize.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginGroupLengthTypeSameSize"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFieldNumberOfGroup() {
        $objectMap.put("fieldNumberOfGroup", fieldNumberOfGroup = new JTextField());
        
        fieldNumberOfGroup.setName("fieldNumberOfGroup");
        fieldNumberOfGroup.setColumns(15);
        fieldNumberOfGroup.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__fieldNumberOfGroup"));
    }

    protected void createFieldStep() {
        $objectMap.put("fieldStep", fieldStep = new JTextField());
        
        fieldStep.setName("fieldStep");
        fieldStep.setColumns(15);
        fieldStep.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__fieldStep"));
    }

    protected void createFinish() {
        $objectMap.put("finish", finish = new JButton());
        
        finish.setName("finish");
        finish.setEnabled(false);
        finish.setText(t("isisfish.common.finish"));
        finish.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__finish"));
    }

    protected void createFirstAge() {
        $objectMap.put("firstAge", firstAge = new JTextField());
        
        firstAge.setName("firstAge");
        firstAge.setColumns(15);
        firstAge.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__firstAge"));
    }

    protected void createFirstInputLength() {
        $objectMap.put("firstInputLength", firstInputLength = new JTextField());
        
        firstInputLength.setName("firstInputLength");
        firstInputLength.setColumns(15);
        firstInputLength.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__firstInputLength"));
    }

    protected void createFirstSizeLength() {
        $objectMap.put("firstSizeLength", firstSizeLength = new JTextField());
        
        firstSizeLength.setName("firstSizeLength");
        firstSizeLength.setColumns(15);
        firstSizeLength.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__firstSizeLength"));
    }

    protected void createGroupLengthType() {
        $objectMap.put("groupLengthType", groupLengthType = new JAXXButtonGroup());
    }

    protected void createGroupWidth() {
        $objectMap.put("groupWidth", groupWidth = new JTextField());
        
        groupWidth.setName("groupWidth");
        groupWidth.setColumns(15);
        groupWidth.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__groupWidth"));
    }

    protected void createGrowthCurveFirstGroup() {
        $objectMap.put("growthCurveFirstGroup", growthCurveFirstGroup = new JTextField());
        
        growthCurveFirstGroup.setName("growthCurveFirstGroup");
        growthCurveFirstGroup.setColumns(15);
        growthCurveFirstGroup.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__growthCurveFirstGroup"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new WizardGroupCreationHandler(this));
    }

    protected void createLastAge() {
        $objectMap.put("lastAge", lastAge = new JTextField());
        
        lastAge.setName("lastAge");
        lastAge.setColumns(15);
        lastAge.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__lastAge"));
    }

    protected void createMaximalGroupsLength() {
        $objectMap.put("maximalGroupsLength", maximalGroupsLength = new JTextField());
        
        maximalGroupsLength.setName("maximalGroupsLength");
        maximalGroupsLength.setColumns(15);
        maximalGroupsLength.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__maximalGroupsLength"));
    }

    protected void createNavButton() {
        $objectMap.put("navButton", navButton = new Table());
        
        navButton.setName("navButton");
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setText(t("isisfish.common.next"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createPrev() {
        $objectMap.put("prev", prev = new JButton());
        
        prev.setName("prev");
        prev.setEnabled(false);
        prev.setText(t("isisfish.common.prev"));
        prev.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__prev"));
    }

    protected void createSameSizeNumberOfGroup() {
        $objectMap.put("sameSizeNumberOfGroup", sameSizeNumberOfGroup = new JTextField());
        
        sameSizeNumberOfGroup.setName("sameSizeNumberOfGroup");
        sameSizeNumberOfGroup.setColumns(15);
        sameSizeNumberOfGroup.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__sameSizeNumberOfGroup"));
    }

    protected void createWizardPanels() {
        $objectMap.put("wizardPanels", wizardPanels = new JPanel());
        
        wizardPanels.setName("wizardPanels");
        wizardPanels.setLayout(new java.awt.CardLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToWizardGroup();
        addChildrenToWizardPanels();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginGroupLengthTypeInput, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginGroupLengthTypeSameSize, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginGroupLengthTypeGrowthCurve, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToBeginGroupLengthTypeInput();
        addChildrenToBeginGroupLengthTypeSameSize();
        addChildrenToBeginGroupLengthTypeGrowthCurve();
        // inline complete setup of $Table1
        $Table1.add($JLabel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(firstAge, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(lastAge, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel7, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(firstInputLength, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel9, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(maximalGroupsLength, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel10, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JLabel11, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel12, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(firstSizeLength, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel13, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(sameSizeNumberOfGroup, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel14, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(groupWidth, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel15, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel16, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel17, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel18, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel19, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(growthCurveFirstGroup, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel20, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(fieldNumberOfGroup, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel21, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(fieldStep, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel22, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToNavButton();
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("wizardGroup", wizardGroup);
        createHandler();
        createWizardPanels();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        $JLabel0.setText(t("isisfish.wizardGroupCreation.selectGroupLengthType"));
        createBeginGroupLengthTypeInput();
        createBeginGroupLengthTypeSameSize();
        createBeginGroupLengthTypeGrowthCurve();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setHorizontalAlignment(0);
        $JLabel1.setText(t("isisfish.wizardGroupCreation.populationCharacteristics"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.wizardGroupCreation.firstAge"));
        createFirstAge();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.wizardGroupCreation.lastAge"));
        createLastAge();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.wizardGroupCreation.firstAgeHelp"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.wizardGroupCreation.lastAgeHelp"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("isisfish.wizardGroupCreation.gapBetweenGroupsHelp"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setHorizontalAlignment(0);
        $JLabel7.setText(t("isisfish.wizardGroupCreation.populationCharacteristics"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("isisfish.wizardGroupCreation.firstLength"));
        createFirstInputLength();
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(t("isisfish.wizardGroupCreation.maxGroupsLength"));
        createMaximalGroupsLength();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(t("isisfish.wizardGroupCreation.maxGroupsLengthHelp"));
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel11
        $objectMap.put("$JLabel11", $JLabel11 = new JLabel());
        
        $JLabel11.setName("$JLabel11");
        $JLabel11.setHorizontalAlignment(0);
        $JLabel11.setText(t("isisfish.wizardGroupCreation.populationCharacteristics"));
        // inline creation of $JLabel12
        $objectMap.put("$JLabel12", $JLabel12 = new JLabel());
        
        $JLabel12.setName("$JLabel12");
        $JLabel12.setText(t("isisfish.wizardGroupCreation.firstLength"));
        createFirstSizeLength();
        // inline creation of $JLabel13
        $objectMap.put("$JLabel13", $JLabel13 = new JLabel());
        
        $JLabel13.setName("$JLabel13");
        $JLabel13.setText(t("isisfish.wizardGroupCreation.numberGroup"));
        createSameSizeNumberOfGroup();
        // inline creation of $JLabel14
        $objectMap.put("$JLabel14", $JLabel14 = new JLabel());
        
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(t("isisfish.wizardGroupCreation.groupWidth"));
        createGroupWidth();
        // inline creation of $JLabel15
        $objectMap.put("$JLabel15", $JLabel15 = new JLabel());
        
        $JLabel15.setName("$JLabel15");
        $JLabel15.setText(t("isisfish.wizardGroupCreation.firstLengthHelp"));
        // inline creation of $JLabel16
        $objectMap.put("$JLabel16", $JLabel16 = new JLabel());
        
        $JLabel16.setName("$JLabel16");
        $JLabel16.setText(t("isisfish.wizardGroupCreation.numberGroupHelp"));
        // inline creation of $JLabel17
        $objectMap.put("$JLabel17", $JLabel17 = new JLabel());
        
        $JLabel17.setName("$JLabel17");
        $JLabel17.setText(t("isisfish.wizardGroupCreation.groupWidthHelp"));
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel18
        $objectMap.put("$JLabel18", $JLabel18 = new JLabel());
        
        $JLabel18.setName("$JLabel18");
        $JLabel18.setHorizontalAlignment(0);
        $JLabel18.setText(t("isisfish.wizardGroupCreation.populationCharacteristics"));
        // inline creation of $JLabel19
        $objectMap.put("$JLabel19", $JLabel19 = new JLabel());
        
        $JLabel19.setName("$JLabel19");
        $JLabel19.setText(t("isisfish.wizardGroupCreation.firstGroup"));
        createGrowthCurveFirstGroup();
        // inline creation of $JLabel20
        $objectMap.put("$JLabel20", $JLabel20 = new JLabel());
        
        $JLabel20.setName("$JLabel20");
        $JLabel20.setText(t("isisfish.wizardGroupCreation.numberGroups"));
        createFieldNumberOfGroup();
        // inline creation of $JLabel21
        $objectMap.put("$JLabel21", $JLabel21 = new JLabel());
        
        $JLabel21.setName("$JLabel21");
        $JLabel21.setText(t("isisfish.wizardGroupCreation.timeStep"));
        createFieldStep();
        // inline creation of $JLabel22
        $objectMap.put("$JLabel22", $JLabel22 = new JLabel());
        
        $JLabel22.setName("$JLabel22");
        $JLabel22.setText(t("isisfish.wizardGroupCreation.undefinedGrowthEquation"));
        createNavButton();
        createPrev();
        createNext();
        createFinish();
        createCancel();
        createGroupLengthType();
        // inline creation of wizardGroup
        setName("wizardGroup");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}