package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationRecruitmentUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_ENABLED = "fieldPopulationMonthGapBetweenReproRecrutement.enabled";
    public static final String BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_TEXT = "fieldPopulationMonthGapBetweenReproRecrutement.text";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_ENABLED = "fieldPopulationRecruitmentComment.enabled";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_TEXT = "fieldPopulationRecruitmentComment.text";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_ENABLED = "fieldPopulationRecruitmentDistribution.enabled";
    public static final String BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_MATRIX = "fieldPopulationRecruitmentDistribution.matrix";
    public static final String BINDING_RECRUITMENT_EQUATION_ACTIVE = "recruitmentEquation.active";
    public static final String BINDING_RECRUITMENT_EQUATION_BEAN = "recruitmentEquation.bean";
    public static final String BINDING_REPRODUCTION_EQUATION_ACTIVE = "reproductionEquation.active";
    public static final String BINDING_REPRODUCTION_EQUATION_BEAN = "reproductionEquation.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTXMbRRAdC0uO4oQkODaGBGInqqRShFXiA5Uqh3zJcSIhExM5HxVxYLQ7kiaMdiczs/Y6B4qfwE+AOxequHGiOHDmwIXiL1AUB64UPbOSVqts1ltZH0br6e7Xr9/09Hz/FypKgVaf4SCwhO8qOiBW49aTJ/c7z4itNoi0BeXKEyj8mymgQhvNO+N9qdC5dlOHV4fh1Zo34J5L3Ino9SY6LNU+I7JPiFLovXiELWW1NTavB9wXI9QxqSTUb//5u/CN8/V3BYQCDuxOQikrB0VFlcw2UYE6Cr0FmXZxlWG3BzQEdXvA96jeqzEs5ad4QJ6jr9BcE5U4FgCm0NnsJRsMEx9whY5X6i73Vc1zFbg/rF9W6EZXWLQryIDAr6SyS2Xf8qlFtaPFPe4zrKjnWtvjzwfEFj5VAwPBuYEvKTTbIdhV6EISILhSRYmcQIkC5/rYdRgRCm3kInMvhImAy7uYUQeDHgp9EDuZscGSe6C41dLro9HmZE2esw9npI8jGPo2trFL2AT9yg7uMAJaLsdyhN7Gpj0XpwOu6H/f1cvy2HRSEC48x7d1aXee+6ZEha6m6kKGfpY53PsuGQU+rGvYU2P0Q5VGE3cIuzxdkdmN+1pdSpgT6bwFPPp3Mb9N1B4hIDvwNNorMjBNuRRD3CGB2tQIyQxM7WfjtvNTGSdOdoNKuBkdP1Tjkid6lgsmKHmAVV8vggZWDxTZMp/mhO444CHiOcqVxm1fQSBIsBAjHG7HvRdERGGkqTadSS5qLaGoo5VGyxYeY5oSJH07ljQyxaNWXy0FXPZQ78WX9L4lCNYAa9OdtpbQabMS75qsH+rl6ni/ZGPXDpthZBHoVKyxYWBa0cCMJtpMGxWFD9twE9ovz9gHYAqn6/LUdNWAxvrf0sLvP/354+ZopJ6B3IuJrhMvAow66EUO84Pq1MfCeQq9wqpbmK+3UVkSBs+JeS5OJxBrDc1ADvKd0OGWDrfuYdkHiOLcHz//svTFb2+gwiY6zDzsbGLtX0dl1ReggsecgN+4aRgd2TsE63HNDcQEP7oLGr15DQYLXulQ14Hjuh6ACKcTRBgz6ZR//Xeh9cPNkRAzQOydV7pHYhSfohJ1GXWJeV2GD0fiazLPJfEdL3ogkp6MGf37Ph8Ou5pZ7yZVaoa/tjYCX/98Ykjrr63MGEc0xnZ4lHroXgsrWcEqvPzk+utjF22GX7zISfBY1xMDaL4aVqTniX3t+Pj14WYVXNqcGHPE1TfcSals9UAYvd1NIZIN4csUDpXsHHIhpHG4kFuHbAhpHC5mONJS+JzlQjmIx6Us7UltL+1KZ8GYV57HdijfSe/0g6H0dj2FTDUTwme5ER6lVJEN4fPcHHBuDmlNng0hrbmu5OaQDSGNw0e5B042hDQO67l1yIaQxuHj3Bw0wv/LlRkgqQ8AAA==";
    private static final Log log = LogFactory.getLog(PopulationRecruitmentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected JTextField fieldPopulationMonthGapBetweenReproRecrutement;
    protected JTextArea fieldPopulationRecruitmentComment;
    protected MatrixPanelEditor fieldPopulationRecruitmentDistribution;
    protected PopulationRecruitmentHandler handler;
    protected InputOneEquationUI recruitmentEquation;
    protected InputOneEquationUI reproductionEquation;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationRecruitmentUI $InputContentUI0 = this;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationRecruitmentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationRecruitmentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationRecruitmentUI() {
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationRecruitmentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createRecruitmentDistribution(getBean());
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMonthGapBetweenReproRecrutement(Integer.parseInt(fieldPopulationMonthGapBetweenReproRecrutement.getText()));
    }

    public void doKeyReleased__on__fieldPopulationRecruitmentComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setRecruitmentComment(fieldPopulationRecruitmentComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationRecruitmentDistribution(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationRecruitmentDistributionMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getFieldPopulationMonthGapBetweenReproRecrutement() {
        return fieldPopulationMonthGapBetweenReproRecrutement;
    }

    public JTextArea getFieldPopulationRecruitmentComment() {
        return fieldPopulationRecruitmentComment;
    }

    public MatrixPanelEditor getFieldPopulationRecruitmentDistribution() {
        return fieldPopulationRecruitmentDistribution;
    }

    public PopulationRecruitmentHandler getHandler() {
        return handler;
    }

    public InputOneEquationUI getRecruitmentEquation() {
        return recruitmentEquation;
    }

    public InputOneEquationUI getReproductionEquation() {
        return reproductionEquation;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFieldPopulationMonthGapBetweenReproRecrutement() {
        $objectMap.put("fieldPopulationMonthGapBetweenReproRecrutement", fieldPopulationMonthGapBetweenReproRecrutement = new JTextField());
        
        fieldPopulationMonthGapBetweenReproRecrutement.setName("fieldPopulationMonthGapBetweenReproRecrutement");
        fieldPopulationMonthGapBetweenReproRecrutement.setColumns(15);
        fieldPopulationMonthGapBetweenReproRecrutement.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement"));
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("sensitivityMethod", "MonthGapBetweenReproRecrutement");
    }

    protected void createFieldPopulationRecruitmentComment() {
        $objectMap.put("fieldPopulationRecruitmentComment", fieldPopulationRecruitmentComment = new JTextArea());
        
        fieldPopulationRecruitmentComment.setName("fieldPopulationRecruitmentComment");
        fieldPopulationRecruitmentComment.setColumns(15);
        fieldPopulationRecruitmentComment.setLineWrap(true);
        fieldPopulationRecruitmentComment.setWrapStyleWord(true);
        fieldPopulationRecruitmentComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationRecruitmentComment"));
    }

    protected void createFieldPopulationRecruitmentDistribution() {
        $objectMap.put("fieldPopulationRecruitmentDistribution", fieldPopulationRecruitmentDistribution = new MatrixPanelEditor());
        
        fieldPopulationRecruitmentDistribution.setName("fieldPopulationRecruitmentDistribution");
        fieldPopulationRecruitmentDistribution.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationRecruitmentDistribution"));
        fieldPopulationRecruitmentDistribution.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationRecruitmentDistribution.putClientProperty("sensitivityMethod", "RecruitmentDistribution");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationRecruitmentHandler(this));
    }

    protected void createRecruitmentEquation() {
        $objectMap.put("recruitmentEquation", recruitmentEquation = new InputOneEquationUI(this));
        
        recruitmentEquation.setName("recruitmentEquation");
        recruitmentEquation.setBeanProperty("RecruitmentEquation");
        recruitmentEquation.setFormuleCategory("Recruitment");
        recruitmentEquation.setText(t("isisfish.populationEquation.recruitmentEquation"));
        recruitmentEquation.putClientProperty("sensitivityBean", Population.class);
        recruitmentEquation.putClientProperty("sensitivityMethod", "RecruitmentEquation");
    }

    protected void createReproductionEquation() {
        $objectMap.put("reproductionEquation", reproductionEquation = new InputOneEquationUI(this));
        
        reproductionEquation.setName("reproductionEquation");
        reproductionEquation.setBeanProperty("ReproductionEquation");
        reproductionEquation.setFormuleCategory("Reproduction");
        reproductionEquation.setText(t("isisfish.populationEquation.reproductionEquation"));
        reproductionEquation.putClientProperty("sensitivityBean", Population.class);
        reproductionEquation.putClientProperty("sensitivityMethod", "ReproductionEquation");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "recruitement"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(reproductionEquation), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationMonthGapBetweenReproRecrutement), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentDistribution), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JButton0), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(recruitmentEquation), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        reproductionEquation.setClazz(fr.ifremer.isisfish.equation.PopulationReproductionEquation.class);
        $JButton0.setIcon(SwingUtil.createImageIcon("common/table--plus.png"));
        recruitmentEquation.setClazz(fr.ifremer.isisfish.equation.PopulationRecruitmentEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createReproductionEquation();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationRecruitment.monthgapgetweenreprorecruitment"));
        createFieldPopulationMonthGapBetweenReproRecrutement();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationRecruitment.recruitmentDistribution"));
        createFieldPopulationRecruitmentDistribution();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(t("isisfish.common.newMatrix"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createRecruitmentEquation();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationRecruitment.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationRecruitmentComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                reproductionEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                reproductionEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMonthGapBetweenReproRecrutement.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationMonthGapBetweenReproRecrutement, String.valueOf(getBean().getMonthGapBetweenReproRecrutement()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationRecruitmentDistribution.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_DISTRIBUTION_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("recruitmentDistribution", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null && bean.getRecruitmentDistribution() != null) {
                    fieldPopulationRecruitmentDistribution.setMatrix(getBean() == null ? null : bean.getRecruitmentDistribution().copy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("recruitmentDistribution", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RECRUITMENT_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                recruitmentEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RECRUITMENT_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                recruitmentEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationRecruitmentComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_RECRUITMENT_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationRecruitmentComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getRecruitmentComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}