package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PopulationMigrationEquationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POP_INFO = "popInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EMIGRATION_EQUATION_ACTIVE = "emigrationEquation.active";
    public static final String BINDING_EMIGRATION_EQUATION_BEAN = "emigrationEquation.bean";
    public static final String BINDING_IMMIGRATION_EQUATION_ACTIVE = "immigrationEquation.active";
    public static final String BINDING_IMMIGRATION_EQUATION_BEAN = "immigrationEquation.bean";
    public static final String BINDING_MIGRATION_EQUATION_ACTIVE = "migrationEquation.active";
    public static final String BINDING_MIGRATION_EQUATION_BEAN = "migrationEquation.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UzU8TQRSfVlrkQ/kKBCNEUBIOxq0cTIwliKkQ2hQhVhJiL06703bIdmaYmYWFg/FP8E/QuxcTb56MB88evBj/BWM8eDW+2ZZ+wLpuqD10NvPe+73fe7957813lFASze9hz7OkyzStEyv3YHd3q7RHyvohUWVJheYSNX6xOIoX0ZDdulca3SjmTXiqGZ7K8LrgjLCO6HQeDSp95BBVI0RrNNsdUVYqVWiZ055w5Qlqi1QQ6qufP+Iv7Rev4wh5AtgNQClz/4pqV9KXR3FqazQOmQ5wysGsCjQkZVXge8ncZRys1CNcJ/voOerPo6TAEsA0uh69ZB/Dj/eERqMLWSZcneFMg/tO9rZGaxVp0YokdQKnoqpCVc1yqUWNoyW4cB2sKWfWdutzk1al/7G27/rnTlYIP0lSo74SwUyjxSBYyEk1JaoDqx3YD7myrMI1WooYWyBYcWZiOlBqmNkOkRrl/kNhGw2wzuq4fQSaGXk8Sx2CWlZuGzPidFBYeIJLDoHeTne9hoa3bzOek62AsfrpvBrdDWVPmn6WL+cWI20lDOZ0C3qcnME2ltlurwlaD3WT6GpXJTAxVnti2k86VkQJ6cI1lF48O2SPwdQYr+lT42UAfevvqYkv77+9Wz+ZqXHIPRno2rES4K0LyQWITk3qkcZAuZo6qU0s0kWYTOLAPvH3xUwAsULTDOQg35gJt0y4tYFVDSAS/V8/fJx69vkCiq+jQYdjex0b/ywa0DUJXeCO7Yn7qz6j4cOL8D9quGmUBD96AD26vGxjjedKlNnwClY8aMJMQBNaTEoDn35NFN6unjQiBsSu/NW93YzEU5SkzKGM+OuluTkC18mQUMS1eXtDBO2MmDlnRPN1L/r/N4Mq9efeWC3PNUfKJ22+liJjDBuM7YaUZsqWG5XMYQ17seRqsnJ+7ETZwcfHPRIcqXBZh8eXwZpUuTwyjunzw/Vp4umeMMz1rZCirkVCuNMzwr2QKqIhrPbMYa1nDrmeEcK0mO9Zi2gIYVpEQwjTIhpCmBbREMK0MAh/AMc15sc8CgAA";
    private static final Log log = LogFactory.getLog(PopulationMigrationEquationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected InputOneEquationUI emigrationEquation;
    protected PopulationMigrationEquationHandler handler;
    protected InputOneEquationUI immigrationEquation;
    protected InputOneEquationUI migrationEquation;
    protected PopulationSeasonInfo popInfo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationEquationUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationEquationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationEquationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEquationUI() {
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEquationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEquationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public InputOneEquationUI getEmigrationEquation() {
        return emigrationEquation;
    }

    public PopulationMigrationEquationHandler getHandler() {
        return handler;
    }

    public InputOneEquationUI getImmigrationEquation() {
        return immigrationEquation;
    }

    public InputOneEquationUI getMigrationEquation() {
        return migrationEquation;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createEmigrationEquation() {
        $objectMap.put("emigrationEquation", emigrationEquation = new InputOneEquationUI(this));
        
        emigrationEquation.setName("emigrationEquation");
        emigrationEquation.setBeanProperty("EmigrationEquation");
        emigrationEquation.setFormuleCategory("Emigration");
        emigrationEquation.setText(t("isisfish.common.emigration"));
        emigrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        emigrationEquation.putClientProperty("sensitivityMethod", "EmigrationEquation");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationMigrationEquationHandler(this));
    }

    protected void createImmigrationEquation() {
        $objectMap.put("immigrationEquation", immigrationEquation = new InputOneEquationUI(this));
        
        immigrationEquation.setName("immigrationEquation");
        immigrationEquation.setBeanProperty("ImmigrationEquation");
        immigrationEquation.setFormuleCategory("Immigration");
        immigrationEquation.setText(t("isisfish.common.immigration"));
        immigrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        immigrationEquation.putClientProperty("sensitivityMethod", "ImmigrationEquation");
    }

    protected void createMigrationEquation() {
        $objectMap.put("migrationEquation", migrationEquation = new InputOneEquationUI(this));
        
        migrationEquation.setName("migrationEquation");
        migrationEquation.setBeanProperty("MigrationEquation");
        migrationEquation.setFormuleCategory("Migration");
        migrationEquation.setText(t("isisfish.common.migration"));
        migrationEquation.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        migrationEquation.putClientProperty("sensitivityMethod", "MigrationEquation");
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(SwingUtil.boxComponentWithJxLayer(migrationEquation), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(emigrationEquation), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(immigrationEquation), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        migrationEquation.setClazz(fr.ifremer.isisfish.equation.MigrationEquation.class);
        emigrationEquation.setClazz(fr.ifremer.isisfish.equation.EmigrationEquation.class);
        immigrationEquation.setClazz(fr.ifremer.isisfish.equation.ImmigrationEquation.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMigrationEquation();
        createEmigrationEquation();
        createImmigrationEquation();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                migrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                migrationEquation.setBean(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                emigrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EMIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                emigrationEquation.setBean(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMMIGRATION_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                immigrationEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMMIGRATION_EQUATION_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                immigrationEquation.setBean(getPopInfo());
            }
        });
    }

}