package fr.ifremer.isisfish.ui.input.fisheryregion;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.bbn.openmap.InformationDelegator;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FisheryRegionUI extends InputContentUI<FisheryRegion> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_CELL_MAP = "cellMap";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CELL_MAP_FISHERY_REGION = "cellMap.fisheryRegion";
    public static final String BINDING_FIELD_CELL_LENGTH_LATITUDE_TEXT = "fieldCellLengthLatitude.text";
    public static final String BINDING_FIELD_CELL_LENGTH_LONGITUDE_TEXT = "fieldCellLengthLongitude.text";
    public static final String BINDING_FIELD_COMMENT_TEXT = "fieldComment.text";
    public static final String BINDING_FIELD_LAT_MAX_TEXT = "fieldLatMax.text";
    public static final String BINDING_FIELD_LAT_MIN_TEXT = "fieldLatMin.text";
    public static final String BINDING_FIELD_LONG_MAX_TEXT = "fieldLongMax.text";
    public static final String BINDING_FIELD_LONG_MIN_TEXT = "fieldLongMin.text";
    public static final String BINDING_FIELD_REGION_TEXT = "fieldRegion.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXzW/cRBSfbPPRNAmURvmo2orQBBBUeFNKKSWl+Sqr7mrTonxAYUEwa8/uTpmdccfj1LkguHDmT4A7FyRunBAHzhwQEuJfQIgDV8Sb8a4db6fuCudgx/Pe7ze/9/z83uy3f6KxQKLn7uMocmTIFe0Sp7Z5797d5n3iqlskcCX1lZAo/hspoVIDTXnJeqDQcqOu4eUevLwtur7ghB9Dr9XRqUAdMRJ0CFEKXcgi3CAo7yXmtcgPZZ81EWVj/frvv0pfeZ9/U0Io8kHdCxDK0pNQaSSjdVSinkJnYKdDXGaYt0GGpLwNemf02jbDQXAHd8kD9BmaqKNxH0sgU+ji8CEbDoOPfIVOr1S5H6ptwRW4H1RXFXqzJR3akqRL4B7QoEWDjhNSh2pHRz8ReSRJmwruVOKnXfN0UPV9wzyu0GiTYK7QyzYu2IgqSoIsOsVOdDD3GJEKrf9fKbdjhpRz8hAz6mFIhEKXMq8kMTjBQ0i1s6ev7/YXj0ckvCN4Ofo9RD3f2juYE5b6TK/U9nxGlV6GTM5nfBOLdp5Lo13Zx02m3RczumKUsWnPxQRwcqVWx03CVgfFmFXtdC7xnWpRwrw4J4N69kmkKtqchfTpL+vnJbvtVYst3qqO1Q7lemnZDr2SC8VRDvQ1C3Q6hgrezt/2aj42d9/XczJxzWJbMLzbhLE64W3VgcCoCj2Ss8UbFprFQRoQ+jieGSg8VwrGepW3kK28xDSAMjvsYL9Fodcp9Ey2nGigtOPGYKmayrgwkMtmqJTgm56mU2g2w7RlbNqzkgCejgG7pCsOCWD0ci3r0k/OdUtyMgEbQVu2lwuNsGsa5Nwjpb8pCda+d9Me0a/8VcuGowE+JInIdH3cxdyNP7sBy5jbIe6nFsOJbhzuQva7ngAaZrK3bGt7AHKq8AAeW9BbNejD9AvqYau8JRRacUXXaTa5I3zCDQ6WZRfKUPBbhJG27mw9AonOZdoOzD4nnX3pcBppoDEZmjJZbDw6LnfBFA/KxYFBqQmN9d/52V9/+OP7Sn86LsHec1bXY8MdppYvIQypBwZUTTwaQ0VZGcJda6DJAAJy48l/3iJsr2cGcbCfqXBHw53bOOgAxdjE7z/+NP/JLydQqYJOMYG9Ctb+VTSpOhKyIJgX+esbRtH0w5NwPa21gRaPHlKPyLpwTWahHd+gnFFOlrCCsQ0FTm5GkJHzlowkspqTP/8zu/fdRj8rI6Dy7GPd08yMfYDG493MqaF3ILCeEqb8gISeSAe/7Sgwou9n/d4so+batYV9Bg4W+yJ0O29HPkzZ/nzyo1DfHpgQ9H/B0IxTQlL4SE0SC1KNKviycziefSKHXv5CoaduwPjHS03KPegYN+1sF4djy9HzfGGGF4dn+NLO8FJhDZcKa3ilsIZyYQ2XC2u4UljD1cIarhVmuF44irXCGt4qrGG9sIZqYYZ6YYY7hfOwW1jDwRB9d4JwPQi8HCHvFRYyHMNvORreL6yhOENjiHSOM3wkQpUTyUdDsMy0jv8kziH7eBiy+JwFRDsi/gmSQ/YfKmpOcscRAAA=";
    private static final Log log = LogFactory.getLog(FisheryRegionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FisheryRegion bean;
    protected JButton buttonAddMap;
    protected JButton buttonRemoveMap;
    protected JButton cancel;
    protected IsisMapBean cellMap;
    protected InformationDelegator cellMapInfo;
    protected JButton check;
    protected JTextField fieldCellLengthLatitude;
    protected JTextField fieldCellLengthLongitude;
    protected JTextArea fieldComment;
    protected JTextField fieldLatMax;
    protected JTextField fieldLatMin;
    protected JTextField fieldLongMax;
    protected JTextField fieldLongMin;
    protected JList<String> fieldMapfiles;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldRegion")
    protected JTextField fieldRegion;
    protected FisheryRegionHandler handler;
    protected JPanel map;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<FisheryRegion> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FisheryRegionUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
                handler.afterInit();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FisheryRegionUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FisheryRegionUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FisheryRegionUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FisheryRegionUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FisheryRegionUI() {
        $initialize();
    }

    public FisheryRegionUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public FisheryRegionUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FisheryRegionUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonAddMap(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addMap();
    }

    public void doActionPerformed__on__buttonRemoveMap(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delMap();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__check(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.check();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldCellLengthLatitude(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCellLengthLatitude(Float.parseFloat(fieldCellLengthLatitude.getText()));
    }

    public void doKeyReleased__on__fieldCellLengthLongitude(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCellLengthLongitude(Float.parseFloat(fieldCellLengthLongitude.getText()));
    }

    public void doKeyReleased__on__fieldComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldComment.getText());
    }

    public void doKeyReleased__on__fieldLatMax(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMaxLatitude(Float.parseFloat(fieldLatMax.getText()));
    }

    public void doKeyReleased__on__fieldLatMin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMinLatitude(Float.parseFloat(fieldLatMin.getText()));
    }

    public void doKeyReleased__on__fieldLongMax(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMaxLongitude(Float.parseFloat(fieldLongMax.getText()));
    }

    public void doKeyReleased__on__fieldLongMin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMinLongitude(Float.parseFloat(fieldLongMin.getText()));
    }

    public void doKeyReleased__on__fieldRegion(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldRegion.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public FisheryRegion getBean() {
        return bean;
    }

    public JButton getButtonAddMap() {
        return buttonAddMap;
    }

    public JButton getButtonRemoveMap() {
        return buttonRemoveMap;
    }

    public JButton getCancel() {
        return cancel;
    }

    public IsisMapBean getCellMap() {
        return cellMap;
    }

    public InformationDelegator getCellMapInfo() {
        return cellMapInfo;
    }

    public JButton getCheck() {
        return check;
    }

    public JTextField getFieldCellLengthLatitude() {
        return fieldCellLengthLatitude;
    }

    public JTextField getFieldCellLengthLongitude() {
        return fieldCellLengthLongitude;
    }

    public JTextArea getFieldComment() {
        return fieldComment;
    }

    public JTextField getFieldLatMax() {
        return fieldLatMax;
    }

    public JTextField getFieldLatMin() {
        return fieldLatMin;
    }

    public JTextField getFieldLongMax() {
        return fieldLongMax;
    }

    public JTextField getFieldLongMin() {
        return fieldLongMin;
    }

    public JList<String> getFieldMapfiles() {
        return fieldMapfiles;
    }

    public JTextField getFieldRegion() {
        return fieldRegion;
    }

    public FisheryRegionHandler getHandler() {
        return handler;
    }

    public JPanel getMap() {
        return map;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<FisheryRegion> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(FisheryRegion bean) {
        FisheryRegion oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCellMap(IsisMapBean cellMap) {
        IsisMapBean oldValue = this.cellMap;
        this.cellMap = cellMap;
        firePropertyChange(PROPERTY_CELL_MAP, oldValue, cellMap);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JSplitPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(SwingUtil.boxComponentWithJxLayer(cellMap), BorderLayout.CENTER);
        map.add(cellMapInfo, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createButtonAddMap() {
        $objectMap.put("buttonAddMap", buttonAddMap = new JButton());
        
        buttonAddMap.setName("buttonAddMap");
        buttonAddMap.setText(t("isisfish.fisheryRegion.addMap"));
        buttonAddMap.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonAddMap"));
    }

    protected void createButtonRemoveMap() {
        $objectMap.put("buttonRemoveMap", buttonRemoveMap = new JButton());
        
        buttonRemoveMap.setName("buttonRemoveMap");
        buttonRemoveMap.setText(t("isisfish.fisheryRegion.delMap"));
        buttonRemoveMap.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonRemoveMap"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCellMap() {
        $objectMap.put("cellMap", cellMap = new fr.ifremer.isisfish.map.IsisMapBean());
        
        cellMap.setName("cellMap");
    }

    protected void createCellMapInfo() {
        $objectMap.put("cellMapInfo", cellMapInfo = new InformationDelegator());
        
        cellMapInfo.setName("cellMapInfo");
    }

    protected void createCheck() {
        $objectMap.put("check", check = new JButton());
        
        check.setName("check");
        check.setText(t("isisfish.common.check"));
        check.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__check"));
    }

    protected void createFieldCellLengthLatitude() {
        $objectMap.put("fieldCellLengthLatitude", fieldCellLengthLatitude = new JTextField());
        
        fieldCellLengthLatitude.setName("fieldCellLengthLatitude");
        fieldCellLengthLatitude.setColumns(15);
        fieldCellLengthLatitude.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldCellLengthLatitude"));
    }

    protected void createFieldCellLengthLongitude() {
        $objectMap.put("fieldCellLengthLongitude", fieldCellLengthLongitude = new JTextField());
        
        fieldCellLengthLongitude.setName("fieldCellLengthLongitude");
        fieldCellLengthLongitude.setColumns(15);
        fieldCellLengthLongitude.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldCellLengthLongitude"));
    }

    protected void createFieldComment() {
        $objectMap.put("fieldComment", fieldComment = new JTextArea());
        
        fieldComment.setName("fieldComment");
        fieldComment.setColumns(15);
        fieldComment.setLineWrap(true);
        fieldComment.setWrapStyleWord(true);
        fieldComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldComment"));
    }

    protected void createFieldLatMax() {
        $objectMap.put("fieldLatMax", fieldLatMax = new JTextField());
        
        fieldLatMax.setName("fieldLatMax");
        fieldLatMax.setColumns(15);
        fieldLatMax.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldLatMax"));
    }

    protected void createFieldLatMin() {
        $objectMap.put("fieldLatMin", fieldLatMin = new JTextField());
        
        fieldLatMin.setName("fieldLatMin");
        fieldLatMin.setColumns(15);
        fieldLatMin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldLatMin"));
    }

    protected void createFieldLongMax() {
        $objectMap.put("fieldLongMax", fieldLongMax = new JTextField());
        
        fieldLongMax.setName("fieldLongMax");
        fieldLongMax.setColumns(15);
        fieldLongMax.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldLongMax"));
    }

    protected void createFieldLongMin() {
        $objectMap.put("fieldLongMin", fieldLongMin = new JTextField());
        
        fieldLongMin.setName("fieldLongMin");
        fieldLongMin.setColumns(15);
        fieldLongMin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldLongMin"));
    }

    protected void createFieldMapfiles() {
        $objectMap.put("fieldMapfiles", fieldMapfiles = new JList<String>());
        
        fieldMapfiles.setName("fieldMapfiles");
    }

    protected void createFieldRegion() {
        $objectMap.put("fieldRegion", fieldRegion = new JTextField());
        
        fieldRegion.setName("fieldRegion");
        fieldRegion.setColumns(15);
        fieldRegion.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldRegion"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FisheryRegionHandler(this));
    }

    protected void createMap() {
        $objectMap.put("map", map = new JPanel());
        
        map.setName("map");
        map.setLayout(new BorderLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(FisheryRegion.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add(map, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldRegion)), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldLatMin), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldLatMax), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldLongMin), new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldLongMax), new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel6, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel7, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldCellLengthLatitude), new GridBagConstraints(1, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel8, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldCellLengthLongitude), new GridBagConstraints(1, 9, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 10, 3, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 11, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel9, new GridBagConstraints(0, 12, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 13, 3, 1, 1.0, 0.4, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel10, new GridBagConstraints(0, 14, 3, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 15, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 15, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(check), new GridBagConstraints(2, 15, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldMapfiles));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(buttonAddMap), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(buttonRemoveMap), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldComment));
        addChildrenToMap();
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        cellMap.setSelectionMode(fr.ifremer.isisfish.map.CellSelectionLayer.NO_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.fisheryRegion.name"));
        createFieldRegion();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.fisheryRegion.area"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.fisheryRegion.latitude.min"));
        createFieldLatMin();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.fisheryRegion.latitude.max"));
        createFieldLatMax();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.fisheryRegion.longitude.min"));
        createFieldLongMin();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.fisheryRegion.longitude.max"));
        createFieldLongMax();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("isisfish.fisheryRegion.spatial"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("isisfish.fisheryRegion.latitude"));
        createFieldCellLengthLatitude();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("isisfish.fisheryRegion.longitude"));
        createFieldCellLengthLongitude();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldMapfiles();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createButtonAddMap();
        createButtonRemoveMap();
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(t("isisfish.fisheryRegion.comments"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldComment();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(t("isisfish.fisheryRegion.selectFile"));
        createSave();
        createCancel();
        createCheck();
        createMap();
        createCellMap();
        createCellMapInfo();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_REGION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldRegion, jaxx.runtime.SwingUtil.getStringValue(getBean().getName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_LAT_MIN_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldLatMin, String.valueOf(getBean().getMinLatitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_LAT_MAX_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldLatMax, String.valueOf(getBean().getMaxLatitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_LONG_MIN_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldLongMin, String.valueOf(getBean().getMinLongitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_LONG_MAX_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldLongMax, String.valueOf(getBean().getMaxLongitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LENGTH_LATITUDE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellLengthLatitude, String.valueOf(getBean().getCellLengthLatitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_CELL_LENGTH_LONGITUDE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldCellLengthLongitude, String.valueOf(getBean().getCellLengthLongitude()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CELL_MAP_FISHERY_REGION, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                cellMap.setFisheryRegion(getBean());
            }
        });
    }

}