package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.sensitivity.TableBlockingLayerUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.BlockingLayerUI2;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n.t;

public abstract class InputContentUI<B extends TopiaEntityContextable> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_BUTTON_TITLE = "buttonTitle";
    public static final String PROPERTY_NEXT_PATH = "nextPath";
    public static final String PROPERTY_SENSITIVITY = "sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NEXT_TEXT = "next.text";
    public static final String BINDING_NEXT_VISIBLE = "next.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdm/gzHwQsQoAgBUIF0jlESBRBkA8U4chARBIpwg3ru0284Xy77M4l5wbxE/gJ0NMg0VEhCmoKGsRfQIiCFjF7d/bZYCeWcLF33n3z5s3cm33znWS0Ipf2aRBYyveAN5m1vryz87C+z2y4y7StuAShSPRLpUm6Rkadzr4GMlermvByHF5eFU0pPOZ1RS9WSVFDy2W6wRgAudgbYWtd3uwcLwbSV23Wjqh+rK9+/ki/dF68ThMSSFRXxFJmj4tKKhmpkjR3gJzGTAe07FJvD2Uo7u2h3nGzt+pSrR/QJntGnpNclWQlVUgG5PLwJYccYXwggeSvrG9Qj7nzQK7tKovvKtZk+NRc73LdsHxucU/6YFXMuio8QNbtipQhRRZIltrADxiQU0agZURbK0K4jHoJaFQzT3PEcWiZrYmuo7oPILwtDi6STCYkUeUJMO+xADYoNMz/UrKfc2mLqe0KNqGn1fqQGymusJ/iSzUCddHFYQtomOPjFpLAMaB1l1XbSW8O6FpXxdaWiRioZKQunBZ+dVN6EKePPooBFBKcaQCQUg9uJexeDFTkQk8p6GMr8XFitFSNZJSP20Cma/9a/xEeRaaf/sv0hjA8/T1V+vL+27u1ttPzmPtMX2jXoKIDpRKSKeAm9cnI5j5wt3yfysUaKWjm4pSHUzzTR9hmfIziMF9kOBNu3aO6gRSZ3NcPH6eefD5B0muk6ArqrFGDr5ACNBR2QbhOIO8shYrGDvO4Thpt6GJ0g8BWkolbDgU6W+eeg/29HWATZvo0oaOkXvj0q7T5dqndiBQKOzcQnjQj85hkuedyj4VDH89z3yEflZr5jkjmtt8kp8yzKGNXXQ1Xq1+l4/XYh6vCFcrArge+eSyE6s3bjZDs7BBkY9S2mYRlvAIiEw7gOj8EVzHiqtj/zVQIS/xvIrM9fwTD7BBSRgBn9giOuSE4cgd4r+AFcgzNH50Y6NA7BwAA";
    private static final Log log = LogFactory.getLog(InputContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean active;
    protected JPanel body;
    protected String buttonTitle;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JButton next;
    protected String nextPath;
    protected Boolean sensitivity;
    protected TableBlockingLayerUI tableLayerUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private InputContentUI<B> $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Overriden with generic type
     */
    public abstract void setBean(B entity);
    
    /**
     * Overriden with generic type
     */
    public abstract B getBean();
    
    public abstract <U extends InputContentHandler<? extends InputContentUI<B>>> U getHandler();
    
    /**
     * Pas très safe, le bean doit s'appeler changeModel dans l'heritage "FORCEMENT"
     *
     * FIXME echatellier 20111201 small fix because save
     * button has to reset internal ui change model state
     */
    public void resetChangeModel() {
    
    }
    
    public InputSaveVerifier getSaveVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    public FisheryRegion getFisheryRegion() {
        return getContextValue(FisheryRegion.class);
    }
    public TopiaContext getTopiaContext() {
        return getContextValue(TopiaContext.class);
    }
    public void setInfoText(String msg) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        if (root != null){
            root.setStatusMessage(msg);
        }
    }
    protected void goTo() {
        // FIXME il ne faut pas appeler le parent
        // on ne sais jamais de quel type est le parent
        InputUI inputUI = getParentContainer(InputUI.class);
        if (inputUI != null) {
            inputUI.getHandler().setTreeSelection(this, nextPath);
        }
    }
    
    /**
     * Mettre a jour la region dans une map si necessaire.
     *
     * @param map la map a mettre a jour si necessaire
     */
    protected void refreshRegionInMap(fr.ifremer.isisfish.map.IsisMapBean map) {
        FisheryRegion fisheryRegion = map.getFisheryRegion();
        FisheryRegion regionFromContext = getFisheryRegion();
        if (fisheryRegion == null || !fisheryRegion.equals(regionFromContext)) {
            if (log.isInfoEnabled()) {
                log.info("Use now " + regionFromContext + " in map " + map);
            }
            map.setFisheryRegion(regionFromContext);
        }
    }
    
    /**
     * Method appelée par l'arbre de navigation et le gestionnaire
     * de changement d'onglet pour ajouter les layers sur une interface
     * 'input' seulement dans le cas de la sensibilité.
     */
    public void setLayer(boolean active) {
        if (get$objectMap() != null) {
            for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
                // Verifie si dans l'entré existe dans le fichier sensitivity.properties
                Class<?> sensitivityBeanClass = (Class<?>)boxed.getClientProperty("sensitivityBean");
                String method = (String)boxed.getClientProperty("sensitivityMethod");
    
                // test if factor is enabled
                boolean isSensitivityFactorEnabled = false;
                if (sensitivityBeanClass != null) {
                    // sensitivityBeanClass is defined in property file without "Impl"
                    String className = sensitivityBeanClass.getSimpleName().replace("Impl", "");
    
                    // ensure that method name is uncapitalized
                    method = StringUtils.uncapitalize(method);
    
                    String sensitivityFactorName = className + "." + method;
                    isSensitivityFactorEnabled = SensitivityUtils.isSensitivityFactorEnabled(sensitivityFactorName);
                }
                
                // install correct layer depending if factor enable
                if (isSensitivityFactorEnabled) {
                    jaxx.runtime.swing.BlockingLayerUI2 ui = getLayerUI2().clone();
                    SwingUtil.getLayer(boxed).setUI(ui);
                } else {
                    if (boxed instanceof JTable) {
                        SwingUtil.getLayer(boxed).setUI(getTableLayerUI());
                    }
                    else {
                        jaxx.runtime.swing.BlockingLayerUI ui = getLayerUI().clone();
                        ui.setBlock(true);
                        ui.setUseIcon(isActive());
                        SwingUtil.getLayer(boxed).setUI(ui);
                    }
                }
            }
        }
    }
    
    /**
     * Install tabbed pane change listener depending on sensitivity.
     * (init at first call)
     *
     * @param tabbedPane tabbed pane to install change listener
     */
    public void installChangeListener(JTabbedPane tabbedPane) {
        // in fichery input, we must listener for tab switch
        // to ask user for saving
        // in sensitivity, fishery can't be saved
        if (!isSensitivity()) {
            ChangeListener tabbedPaneChangeListener = new InputTabbedPaneListener();
            tabbedPane.addChangeListener(tabbedPaneChangeListener);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI() {
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputContentUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        goTo();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getActive() {
        return active;
    }

    public JPanel getBody() {
        return body;
    }

    public String getButtonTitle() {
        return buttonTitle;
    }

    public BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public JButton getNext() {
        return next;
    }

    public String getNextPath() {
        return nextPath;
    }

    public Boolean getSensitivity() {
        return sensitivity;
    }

    public TableBlockingLayerUI getTableLayerUI() {
        return tableLayerUI;
    }

    public Boolean isActive() {
        return active !=null && active;
    }

    public Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActive(Boolean active) {
        Boolean oldValue = this.active;
        this.active = active;
        firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    public void setButtonTitle(String buttonTitle) {
        String oldValue = this.buttonTitle;
        this.buttonTitle = buttonTitle;
        firePropertyChange(PROPERTY_BUTTON_TITLE, oldValue, buttonTitle);
    }

    public void setNextPath(String nextPath) {
        String oldValue = this.nextPath;
        this.nextPath = nextPath;
        firePropertyChange(PROPERTY_NEXT_PATH, oldValue, nextPath);
    }

    public void setSensitivity(Boolean sensitivity) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = sensitivity;
        firePropertyChange(PROPERTY_SENSITIVITY, oldValue, sensitivity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createActive() {
        $objectMap.put("active", active = false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JPanel());
        
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createButtonTitle() {
        $objectMap.put("buttonTitle", buttonTitle = null);
    }

    protected void createLayerUI() {
        $objectMap.put("layerUI", layerUI = new BlockingLayerUI());
    }

    protected void createLayerUI2() {
        $objectMap.put("layerUI2", layerUI2 = new BlockingLayerUI2());
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createNextPath() {
        $objectMap.put("nextPath", nextPath = null);
    }

    protected void createSensitivity() {
        $objectMap.put("sensitivity", sensitivity = false);
    }

    protected void createTableLayerUI() {
        $objectMap.put("tableLayerUI", tableLayerUI = new TableBlockingLayerUI(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(body, BorderLayout.CENTER);
        add(SwingUtil.boxComponentWithJxLayer(next), BorderLayout.SOUTH);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        layerUI.setBlockingColor(new Color(25,25,25));
        layerUI2.setAcceptAction(new AbstractAction() {              private static final long serialVersionUID = 1L;              @Override              public void actionPerformed(ActionEvent e) {                 getHandler().accept(InputContentUI.this, e);              }          });
        layerUI2.setAcceptIcon(SwingUtil.createImageIcon("sensitivity/flag--plus.png"));
        layerUI2.setBlockIcon(SwingUtil.createImageIcon("sensitivity/flag.png"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createActive();
        createSensitivity();
        createButtonTitle();
        createNextPath();
        createLayerUI();
        createLayerUI2();
        createTableLayerUI();
        createBody();
        createNext();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEXT_TEXT, true ,"buttonTitle") {
        
            @Override
            public void processDataBinding() {
                next.setText(t(getButtonTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEXT_VISIBLE, true ,"buttonTitle") {
        
            @Override
            public void processDataBinding() {
                next.setVisible(getButtonTitle() != null);
            }
        });
    }

}