/*
 * #%L
 * $Id: StatusBarHandler.java 4277 2015-06-21 17:24:03Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/StatusBarHandler.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Status bar UI handler.
 * 
 * @author chatellier
 */
public class StatusBarHandler {

    /** Class logger. */
    private static Log log = LogFactory.getLog(StatusBarHandler.class);

    protected StatusBarUI statusBarUI;

    /** Attribute used to remember screenshot last directory. */
    protected JFileChooser screenshotFileChooser;

    public StatusBarHandler(StatusBarUI statusBarUI) {
        this.statusBarUI = statusBarUI;
    }

    public void afterInit() {
        
    }

    /**
     * Ask user for screenshot save file and take screenshot to that file.
     */
    public void screenshot() {
        if (screenshotFileChooser == null) {
            screenshotFileChooser = new JFileChooser();
            screenshotFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            screenshotFileChooser.setMultiSelectionEnabled(false);
        }

        // reset
        File previousFile = screenshotFileChooser.getSelectedFile();
        if (previousFile != null) {
            screenshotFileChooser.setSelectedFile(new File("")); // hack alert
            screenshotFileChooser.setCurrentDirectory(previousFile.getParentFile());
        }

        // find parent
        Component parent = statusBarUI;
        while (!(parent instanceof WelcomeUI)) {
            parent = parent.getParent();
        }
        final Component realParent = parent;

        try {
            // take screenshot
            // we must take screenshot BEFORE filechooser display
            Rectangle screenRect = realParent.getBounds();
            final BufferedImage capture = new Robot().createScreenCapture(screenRect);

            // ask user for file
            int opt = screenshotFileChooser.showSaveDialog(realParent);
            if (opt == JFileChooser.APPROVE_OPTION) {
                File file = screenshotFileChooser.getSelectedFile();
    
                // add "png" if not yet set
                if (!file.getName().endsWith(".png")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                final File realFile = file;

                // save screenshot
                ImageIO.write(capture, "png", realFile);
            }
        } catch (AWTException|IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't take screenshot help", ex);
            }
        }
    }
}
