/*
 * #%L
 * IsisFish
 * 
 * $Id: FactorGroupVisitor.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/simulator/sensitivity/visitor/FactorGroupVisitor.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity.visitor;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;

/**
 * Factor group visitor.
 *
 * @author chatellier
 * @version $Revision: 4156 $
 * 
 * Last update : $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * By : $Author: echatellier $
 */
public interface FactorGroupVisitor {

    /**
     * Start.
     * 
     * @param factorGroup factorGroup
     */
    void start(FactorGroup factorGroup);
    
    /**
     * Visit domain.
     * 
     * @param factorGroup factorGroup
     * @param factor factor
     */
    void visit(FactorGroup factorGroup, Factor factor);
    
    /**
     * End.
     * 
     * @param factorGroup factorGroup
     */
    void end(FactorGroup factorGroup);
}
