/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationLoggerUtil.java 4205 2015-04-22 15:09:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/logging/SimulationLoggerUtil.java $
 * %%
 * Copyright (C) 2002 - 2014 Ifremer, Code Lutin, Benjamin Poussin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.logging;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.io.File;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.console.LogConsole;

/**
 * FIXME poussin, a priori cette classe ne supporte pas plusieurs simulation
 * en meme temps, ce qui est le cas si on a plusieurs processeurs de dispo :(
 * 
 * 
 * Usefull class for dealing with hot configuration of log4J. this is temporary
 * we must find a way to abstract this layer.
 * 
 * {@code #removeAppender(String, String)}  to remove a appender of a simulation
 * 
 * @author chemit
 */
public class SimulationLoggerUtil {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(SimulationLoggerUtil.class);

    /**
     * Open a new log console for the given simulation
     *
     * @param simulationName name of the simulation to use
     * @throws IOException 
     * @throws IllegalArgumentException 
     */
    public static void showSimulationLogConsole(Component parent, String simulationName) throws IllegalArgumentException, IOException {
        SimulationStorage storage;

        storage = SimulationStorage.getSimulation(simulationName);

        File logFile = new File(storage.getSimulationLogFile());

        String smtpServer = IsisFish.config.getSmtpServer();
        String defaultFrom = IsisFish.config.getUserMail();

        String title = t("isisfish.simulation.log.console.title", simulationName);

        LogConsole ui = LogConsole.newConsole(logFile, smtpServer, defaultFrom, null, title);
        ui.setLocationRelativeTo(parent);
        ui.setVisible(true);

        if (log.isInfoEnabled()) {
            log.info(t("isisfish.simulation.log.showConsole", simulationName));
        }
    }
}
