/*
 * #%L
 * IsisFish
 * 
 * $Id: SelectivityEquation.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/equation/SelectivityEquation.java $
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Selectivity equation.
 *
 * Created: 23 août 2006 11:39:38
 *
 * @author poussin
 * @version $Revision: 4156 $
 *
 * Last update: $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * by : $Author: echatellier $
 */
public interface SelectivityEquation {
    
    /**
     * Compute selectivity.
     * 
     * @param context simulation context
     * @param pop la population pour lequel on souhaite la selectivite de l'engin
     * @param group le group pour lequel on souhaite la selectivite de l'engin
     * @param metier le metier pour lequel on souhaite la selectivite de l'engin
     * @return equation result
     * @throws Exception 
     */
    @Args({"context", "pop", "group", "metier"})
    public double compute(SimulationContext context,
            Population pop, PopulationGroup group, Metier metier) throws Exception;

}
