/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationRecruitmentEquation.java 4208 2015-04-27 09:23:54Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/equation/PopulationRecruitmentEquation.java $
 * %%
 * Copyright (C) 2015 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.ReproductionDataMap;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;

/**
 * Population recruitment equation.
 *
 * @author echatellier
 * @since 4.4.0.0
 */
public interface PopulationRecruitmentEquation {

    /**
     * Compute recruitment equation.
     * 
     * @param context simulation context
     * @param step current time step
     * @param pop population pour lequel on souhaite la matrice de recrutement
     * @param reproductions les abundances, biomasses et reproduction correspondant au recrutement courant
     * @param result la matrice resultat que l'equation doit remplir, il s'agit
     * d'une matrice groupes/zones
     * @return la valeur retournée n'est pas utilisée, par exemple 'return 0;' convient.
     * @throws Exception 
     */
    @Args({"context", "step", "pop", "reproductions", "result"})
    @ArgTypes({
        "fr.ifremer.isisfish.simulator.SimulationContext",
        "fr.ifremer.isisfish.types.TimeStep",
        "fr.ifremer.isisfish.entities.Population",
        "fr.ifremer.isisfish.types.ReproductionDataMap",
        "org.nuiton.math.matrix.MatrixND"})
    public double compute(SimulationContext context, TimeStep step,
            Population pop, ReproductionDataMap reproductions, MatrixND result) throws Exception;

}
