package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public abstract class TripTypeDAOAbstract<E extends TripType> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TripType.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.TripType;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<VesselType> list = getContext().getHibernate().createSQLQuery(
                    " SELECT main.*" +
                    " FROM vesselType main, triptype_vesseltype secondary" +
                    " WHERE main.topiaid = secondary.vesselType" +
                    " AND secondary.tripType = ?")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(VesselType.class))
                    .setString(0, entity.getTopiaId())
                    .list();

            for (VesselType item : list) {
                item.removeTripType(entity);
            }
        }

                                        {
                                        List<StrategyMonthInfo> list = getContext()
                                                    .getDAO(StrategyMonthInfo.class)
                                                    .findAllByProperties(StrategyMonthInfo.PROPERTY_TRIP_TYPE, entity);
                                            for (StrategyMonthInfo item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTripType())) {
                                                    item.setTripType(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_NAME, v);
        return result;
    }

    public E findByTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_TRIP_DURATION, v);
        return result;
    }

    public List<E> findAllByTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_TRIP_DURATION, v);
        return result;
    }

    public E findByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    public List<E> findAllByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(TripType.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.PROPERTY_COMMENT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == StrategyMonthInfo.class) {
            StrategyMonthInfoDAO dao = (StrategyMonthInfoDAO)
                getContext().getDAO(StrategyMonthInfo.class);
            tmp = dao.findAllByTripType(entity);
            result.addAll(tmp);
        }

        if (type == VesselType.class) {
            VesselTypeDAO dao = (VesselTypeDAO)
                getContext().getDAO(VesselType.class);
            tmp = dao.findAllContainsTripType(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(StrategyMonthInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(StrategyMonthInfo.class, list);
        }

        list = findUsages(VesselType.class, entity);
        if (!list.isEmpty()) {
            result.put(VesselType.class, list);
        }

        return result;
    }

} //TripTypeDAOAbstract<E extends TripType>
