package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public abstract class PopulationAbstract extends TopiaEntityAbstract implements Population {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : geographicId
     */
    protected String geographicId;

    /**
     * Nom de l'attribut en BD : plusGroup
     */
    protected boolean plusGroup;

    /**
     * Nom de l'attribut en BD : growth
     */
    protected Equation growth;

    /**
     * Nom de l'attribut en BD : growthReverse
     */
    protected Equation growthReverse;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : meanWeight
     */
    protected Equation meanWeight;

    /**
     * <p>Le prix en Kg</p>
     * 
     * Nom de l'attribut en BD : price
     */
    protected Equation price;

    /**
     * Nom de l'attribut en BD : naturalDeathRate
     */
    protected Equation naturalDeathRate;

    /**
     * Nom de l'attribut en BD : caractBioComment
     */
    protected String caractBioComment;

    /**
     * Nom de l'attribut en BD : reproductionEquation
     */
    protected Equation reproductionEquation;

    /**
     * Nom de l'attribut en BD : monthGapBetweenReproRecrutement
     */
    protected int monthGapBetweenReproRecrutement;

    /**
     * Nom de l'attribut en BD : recruitmentDistribution
     */
    protected MatrixND recruitmentDistribution;

    /**
     * Nom de l'attribut en BD : recruitmentEquation
     */
    protected Equation recruitmentEquation;

    /**
     * Nom de l'attribut en BD : recruitmentComment
     */
    protected String recruitmentComment;

    /**
     * Nom de l'attribut en BD : zonesComment
     */
    protected String zonesComment;

    /**
     * Nom de l'attribut en BD : seasonsComment
     */
    protected String seasonsComment;

    /**
     * Nom de l'attribut en BD : capturabilityComment
     */
    protected String capturabilityComment;

    /**
     * Nom de l'attribut en BD : migrationComment
     */
    protected String migrationComment;

    /**
     * Nom de l'attribut en BD : mappingZoneReproZoneRecru
     */
    protected MatrixND mappingZoneReproZoneRecru;

    /**
     * Nom de l'attribut en BD : capturability
     */
    protected MatrixND capturability;

    /**
     * Nom de l'attribut en BD : capturabilityEquationUsed
     */
    protected boolean capturabilityEquationUsed;

    /**
     * Nom de l'attribut en BD : capturabilityEquation
     */
    protected Equation capturabilityEquation;

    /**
     * Nom de l'attribut en BD : maturityOgiveEquation
     */
    protected Equation maturityOgiveEquation;

    /**
     * Nom de l'attribut en BD : reproductionRateEquation
     */
    protected Equation reproductionRateEquation;

    /**
     * Fbar group min
     * Nom de l'attribut en BD : fbarGroupMin
     */
    protected int fbarGroupMin;

    /**
     * Fbar group max
     * Nom de l'attribut en BD : fbarGroupMax
     */
    protected int fbarGroupMax;

    /**
     * ajouter un param "mois de considération de l abondance pour le calcul de F" (!) surnommé "*mcacf*"
     * Nom de l'attribut en BD : abundanceReferenceMonth
     */
    protected Month abundanceReferenceMonth;

    /**
     * Nom de l'attribut en BD : computeFOnLandings
     */
    protected boolean computeFOnLandings;

    /**
     * Nom de l'attribut en BD : gear
     */
    protected Collection<Selectivity> gearSelectivity;

    /**
     * Nom de l'attribut en BD : populationGroup
     */
    protected List<PopulationGroup> populationGroup;

    /**
     * Nom de l'attribut en BD : populationSeasonInfo
     */
    protected List<PopulationSeasonInfo> populationSeasonInfo;

    /**
     * Nom de l'attribut en BD : species
     */
    protected Species species;

    /**
     * Nom de l'attribut en BD : reproductionZone
     */
    protected List<Zone> reproductionZone;

    /**
     * Nom de l'attribut en BD : populationZone
     */
    protected List<Zone> populationZone;

    /**
     * Nom de l'attribut en BD : recruitmentZone
     */
    protected List<Zone> recruitmentZone;

    private static final long serialVersionUID = 3702297758987925809L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_GEOGRAPHIC_ID, String.class, geographicId);
        visitor.visit(this, PROPERTY_PLUS_GROUP, boolean.class, plusGroup);
        visitor.visit(this, PROPERTY_GROWTH, Equation.class, growth);
        visitor.visit(this, PROPERTY_GROWTH_REVERSE, Equation.class, growthReverse);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_MEAN_WEIGHT, Equation.class, meanWeight);
        visitor.visit(this, PROPERTY_PRICE, Equation.class, price);
        visitor.visit(this, PROPERTY_NATURAL_DEATH_RATE, Equation.class, naturalDeathRate);
        visitor.visit(this, PROPERTY_CARACT_BIO_COMMENT, String.class, caractBioComment);
        visitor.visit(this, PROPERTY_REPRODUCTION_EQUATION, Equation.class, reproductionEquation);
        visitor.visit(this, PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, int.class, monthGapBetweenReproRecrutement);
        visitor.visit(this, PROPERTY_RECRUITMENT_DISTRIBUTION, MatrixND.class, recruitmentDistribution);
        visitor.visit(this, PROPERTY_RECRUITMENT_EQUATION, Equation.class, recruitmentEquation);
        visitor.visit(this, PROPERTY_RECRUITMENT_COMMENT, String.class, recruitmentComment);
        visitor.visit(this, PROPERTY_ZONES_COMMENT, String.class, zonesComment);
        visitor.visit(this, PROPERTY_SEASONS_COMMENT, String.class, seasonsComment);
        visitor.visit(this, PROPERTY_CAPTURABILITY_COMMENT, String.class, capturabilityComment);
        visitor.visit(this, PROPERTY_MIGRATION_COMMENT, String.class, migrationComment);
        visitor.visit(this, PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, MatrixND.class, mappingZoneReproZoneRecru);
        visitor.visit(this, PROPERTY_CAPTURABILITY, MatrixND.class, capturability);
        visitor.visit(this, PROPERTY_CAPTURABILITY_EQUATION_USED, boolean.class, capturabilityEquationUsed);
        visitor.visit(this, PROPERTY_CAPTURABILITY_EQUATION, Equation.class, capturabilityEquation);
        visitor.visit(this, PROPERTY_MATURITY_OGIVE_EQUATION, Equation.class, maturityOgiveEquation);
        visitor.visit(this, PROPERTY_REPRODUCTION_RATE_EQUATION, Equation.class, reproductionRateEquation);
        visitor.visit(this, PROPERTY_FBAR_GROUP_MIN, int.class, fbarGroupMin);
        visitor.visit(this, PROPERTY_FBAR_GROUP_MAX, int.class, fbarGroupMax);
        visitor.visit(this, PROPERTY_ABUNDANCE_REFERENCE_MONTH, Month.class, abundanceReferenceMonth);
        visitor.visit(this, PROPERTY_COMPUTE_FON_LANDINGS, boolean.class, computeFOnLandings);
        visitor.visit(this, PROPERTY_GEAR_SELECTIVITY, Collection.class, Selectivity.class, gearSelectivity);
        visitor.visit(this, PROPERTY_POPULATION_GROUP, List.class, PopulationGroup.class, populationGroup);
        visitor.visit(this, PROPERTY_POPULATION_SEASON_INFO, List.class, PopulationSeasonInfo.class, populationSeasonInfo);
        visitor.visit(this, PROPERTY_SPECIES, Species.class, species);
        visitor.visit(this, PROPERTY_REPRODUCTION_ZONE, List.class, Zone.class, reproductionZone);
        visitor.visit(this, PROPERTY_POPULATION_ZONE, List.class, Zone.class, populationZone);
        visitor.visit(this, PROPERTY_RECRUITMENT_ZONE, List.class, Zone.class, recruitmentZone);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;

        return result;
    }

    @Override
    public void setGeographicId(String geographicId) {
        String oldValue = this.geographicId;
        fireOnPreWrite(PROPERTY_GEOGRAPHIC_ID, oldValue, geographicId);
        this.geographicId = geographicId;
        fireOnPostWrite(PROPERTY_GEOGRAPHIC_ID, oldValue, geographicId);
    }

    @Override
    public String getGeographicId() {
        String result = this.geographicId;

        return result;
    }

    @Override
    public void setPlusGroup(boolean plusGroup) {
        boolean oldValue = this.plusGroup;
        fireOnPreWrite(PROPERTY_PLUS_GROUP, oldValue, plusGroup);
        this.plusGroup = plusGroup;
        fireOnPostWrite(PROPERTY_PLUS_GROUP, oldValue, plusGroup);
    }

    @Override
    public boolean isPlusGroup() {
        boolean result = this.plusGroup;

        return result;
    }

    @Override
    public boolean getPlusGroup() {
        boolean result = this.plusGroup;

        return result;
    }

    @Override
    public void setGrowth(Equation growth) {
        Equation oldValue = this.growth;
        fireOnPreWrite(PROPERTY_GROWTH, oldValue, growth);
        this.growth = growth;
        fireOnPostWrite(PROPERTY_GROWTH, oldValue, growth);
    }

    @Override
    public Equation getGrowth() {
        Equation result = this.growth;

        return result;
    }

    @Override
    public void setGrowthReverse(Equation growthReverse) {
        Equation oldValue = this.growthReverse;
        fireOnPreWrite(PROPERTY_GROWTH_REVERSE, oldValue, growthReverse);
        this.growthReverse = growthReverse;
        fireOnPostWrite(PROPERTY_GROWTH_REVERSE, oldValue, growthReverse);
    }

    @Override
    public Equation getGrowthReverse() {
        Equation result = this.growthReverse;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void setMeanWeight(Equation meanWeight) {
        Equation oldValue = this.meanWeight;
        fireOnPreWrite(PROPERTY_MEAN_WEIGHT, oldValue, meanWeight);
        this.meanWeight = meanWeight;
        fireOnPostWrite(PROPERTY_MEAN_WEIGHT, oldValue, meanWeight);
    }

    @Override
    public Equation getMeanWeight() {
        Equation result = this.meanWeight;

        return result;
    }

    @Override
    public void setPrice(Equation price) {
        Equation oldValue = this.price;
        fireOnPreWrite(PROPERTY_PRICE, oldValue, price);
        this.price = price;
        fireOnPostWrite(PROPERTY_PRICE, oldValue, price);
    }

    @Override
    public Equation getPrice() {
        Equation result = this.price;

        return result;
    }

    @Override
    public void setNaturalDeathRate(Equation naturalDeathRate) {
        Equation oldValue = this.naturalDeathRate;
        fireOnPreWrite(PROPERTY_NATURAL_DEATH_RATE, oldValue, naturalDeathRate);
        this.naturalDeathRate = naturalDeathRate;
        fireOnPostWrite(PROPERTY_NATURAL_DEATH_RATE, oldValue, naturalDeathRate);
    }

    @Override
    public Equation getNaturalDeathRate() {
        Equation result = this.naturalDeathRate;

        return result;
    }

    @Override
    public void setCaractBioComment(String caractBioComment) {
        String oldValue = this.caractBioComment;
        fireOnPreWrite(PROPERTY_CARACT_BIO_COMMENT, oldValue, caractBioComment);
        this.caractBioComment = caractBioComment;
        fireOnPostWrite(PROPERTY_CARACT_BIO_COMMENT, oldValue, caractBioComment);
    }

    @Override
    public String getCaractBioComment() {
        String result = this.caractBioComment;

        return result;
    }

    @Override
    public void setReproductionEquation(Equation reproductionEquation) {
        Equation oldValue = this.reproductionEquation;
        fireOnPreWrite(PROPERTY_REPRODUCTION_EQUATION, oldValue, reproductionEquation);
        this.reproductionEquation = reproductionEquation;
        fireOnPostWrite(PROPERTY_REPRODUCTION_EQUATION, oldValue, reproductionEquation);
    }

    @Override
    public Equation getReproductionEquation() {
        Equation result = this.reproductionEquation;

        return result;
    }

    @Override
    public void setMonthGapBetweenReproRecrutement(int monthGapBetweenReproRecrutement) {
        int oldValue = this.monthGapBetweenReproRecrutement;
        fireOnPreWrite(PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, oldValue, monthGapBetweenReproRecrutement);
        this.monthGapBetweenReproRecrutement = monthGapBetweenReproRecrutement;
        fireOnPostWrite(PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, oldValue, monthGapBetweenReproRecrutement);
    }

    @Override
    public int getMonthGapBetweenReproRecrutement() {
        int result = this.monthGapBetweenReproRecrutement;

        return result;
    }

    @Override
    public void setRecruitmentDistribution(MatrixND recruitmentDistribution) {
        MatrixND oldValue = this.recruitmentDistribution;
        fireOnPreWrite(PROPERTY_RECRUITMENT_DISTRIBUTION, oldValue, recruitmentDistribution);
        this.recruitmentDistribution = recruitmentDistribution;
        fireOnPostWrite(PROPERTY_RECRUITMENT_DISTRIBUTION, oldValue, recruitmentDistribution);
    }

    @Override
    public MatrixND getRecruitmentDistribution() {
        MatrixND result = this.recruitmentDistribution;

        return result;
    }

    @Override
    public void setRecruitmentEquation(Equation recruitmentEquation) {
        Equation oldValue = this.recruitmentEquation;
        fireOnPreWrite(PROPERTY_RECRUITMENT_EQUATION, oldValue, recruitmentEquation);
        this.recruitmentEquation = recruitmentEquation;
        fireOnPostWrite(PROPERTY_RECRUITMENT_EQUATION, oldValue, recruitmentEquation);
    }

    @Override
    public Equation getRecruitmentEquation() {
        Equation result = this.recruitmentEquation;

        return result;
    }

    @Override
    public void setRecruitmentComment(String recruitmentComment) {
        String oldValue = this.recruitmentComment;
        fireOnPreWrite(PROPERTY_RECRUITMENT_COMMENT, oldValue, recruitmentComment);
        this.recruitmentComment = recruitmentComment;
        fireOnPostWrite(PROPERTY_RECRUITMENT_COMMENT, oldValue, recruitmentComment);
    }

    @Override
    public String getRecruitmentComment() {
        String result = this.recruitmentComment;

        return result;
    }

    @Override
    public void setZonesComment(String zonesComment) {
        String oldValue = this.zonesComment;
        fireOnPreWrite(PROPERTY_ZONES_COMMENT, oldValue, zonesComment);
        this.zonesComment = zonesComment;
        fireOnPostWrite(PROPERTY_ZONES_COMMENT, oldValue, zonesComment);
    }

    @Override
    public String getZonesComment() {
        String result = this.zonesComment;

        return result;
    }

    @Override
    public void setSeasonsComment(String seasonsComment) {
        String oldValue = this.seasonsComment;
        fireOnPreWrite(PROPERTY_SEASONS_COMMENT, oldValue, seasonsComment);
        this.seasonsComment = seasonsComment;
        fireOnPostWrite(PROPERTY_SEASONS_COMMENT, oldValue, seasonsComment);
    }

    @Override
    public String getSeasonsComment() {
        String result = this.seasonsComment;

        return result;
    }

    @Override
    public void setCapturabilityComment(String capturabilityComment) {
        String oldValue = this.capturabilityComment;
        fireOnPreWrite(PROPERTY_CAPTURABILITY_COMMENT, oldValue, capturabilityComment);
        this.capturabilityComment = capturabilityComment;
        fireOnPostWrite(PROPERTY_CAPTURABILITY_COMMENT, oldValue, capturabilityComment);
    }

    @Override
    public String getCapturabilityComment() {
        String result = this.capturabilityComment;

        return result;
    }

    @Override
    public void setMigrationComment(String migrationComment) {
        String oldValue = this.migrationComment;
        fireOnPreWrite(PROPERTY_MIGRATION_COMMENT, oldValue, migrationComment);
        this.migrationComment = migrationComment;
        fireOnPostWrite(PROPERTY_MIGRATION_COMMENT, oldValue, migrationComment);
    }

    @Override
    public String getMigrationComment() {
        String result = this.migrationComment;

        return result;
    }

    @Override
    public void setMappingZoneReproZoneRecru(MatrixND mappingZoneReproZoneRecru) {
        MatrixND oldValue = this.mappingZoneReproZoneRecru;
        fireOnPreWrite(PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, oldValue, mappingZoneReproZoneRecru);
        this.mappingZoneReproZoneRecru = mappingZoneReproZoneRecru;
        fireOnPostWrite(PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, oldValue, mappingZoneReproZoneRecru);
    }

    @Override
    public MatrixND getMappingZoneReproZoneRecru() {
        MatrixND result = this.mappingZoneReproZoneRecru;

        return result;
    }

    @Override
    public void setCapturability(MatrixND capturability) {
        MatrixND oldValue = this.capturability;
        fireOnPreWrite(PROPERTY_CAPTURABILITY, oldValue, capturability);
        this.capturability = capturability;
        fireOnPostWrite(PROPERTY_CAPTURABILITY, oldValue, capturability);
    }

    @Override
    public MatrixND getCapturability() {
        MatrixND result = this.capturability;

        return result;
    }

    @Override
    public void setCapturabilityEquationUsed(boolean capturabilityEquationUsed) {
        boolean oldValue = this.capturabilityEquationUsed;
        fireOnPreWrite(PROPERTY_CAPTURABILITY_EQUATION_USED, oldValue, capturabilityEquationUsed);
        this.capturabilityEquationUsed = capturabilityEquationUsed;
        fireOnPostWrite(PROPERTY_CAPTURABILITY_EQUATION_USED, oldValue, capturabilityEquationUsed);
    }

    @Override
    public boolean isCapturabilityEquationUsed() {
        boolean result = this.capturabilityEquationUsed;

        return result;
    }

    @Override
    public boolean getCapturabilityEquationUsed() {
        boolean result = this.capturabilityEquationUsed;

        return result;
    }

    @Override
    public void setCapturabilityEquation(Equation capturabilityEquation) {
        Equation oldValue = this.capturabilityEquation;
        fireOnPreWrite(PROPERTY_CAPTURABILITY_EQUATION, oldValue, capturabilityEquation);
        this.capturabilityEquation = capturabilityEquation;
        fireOnPostWrite(PROPERTY_CAPTURABILITY_EQUATION, oldValue, capturabilityEquation);
    }

    @Override
    public Equation getCapturabilityEquation() {
        Equation result = this.capturabilityEquation;

        return result;
    }

    @Override
    public void setMaturityOgiveEquation(Equation maturityOgiveEquation) {
        Equation oldValue = this.maturityOgiveEquation;
        fireOnPreWrite(PROPERTY_MATURITY_OGIVE_EQUATION, oldValue, maturityOgiveEquation);
        this.maturityOgiveEquation = maturityOgiveEquation;
        fireOnPostWrite(PROPERTY_MATURITY_OGIVE_EQUATION, oldValue, maturityOgiveEquation);
    }

    @Override
    public Equation getMaturityOgiveEquation() {
        Equation result = this.maturityOgiveEquation;

        return result;
    }

    @Override
    public void setReproductionRateEquation(Equation reproductionRateEquation) {
        Equation oldValue = this.reproductionRateEquation;
        fireOnPreWrite(PROPERTY_REPRODUCTION_RATE_EQUATION, oldValue, reproductionRateEquation);
        this.reproductionRateEquation = reproductionRateEquation;
        fireOnPostWrite(PROPERTY_REPRODUCTION_RATE_EQUATION, oldValue, reproductionRateEquation);
    }

    @Override
    public Equation getReproductionRateEquation() {
        Equation result = this.reproductionRateEquation;

        return result;
    }

    @Override
    public void setFbarGroupMin(int fbarGroupMin) {
        int oldValue = this.fbarGroupMin;
        fireOnPreWrite(PROPERTY_FBAR_GROUP_MIN, oldValue, fbarGroupMin);
        this.fbarGroupMin = fbarGroupMin;
        fireOnPostWrite(PROPERTY_FBAR_GROUP_MIN, oldValue, fbarGroupMin);
    }

    @Override
    public int getFbarGroupMin() {
        int result = this.fbarGroupMin;

        return result;
    }

    @Override
    public void setFbarGroupMax(int fbarGroupMax) {
        int oldValue = this.fbarGroupMax;
        fireOnPreWrite(PROPERTY_FBAR_GROUP_MAX, oldValue, fbarGroupMax);
        this.fbarGroupMax = fbarGroupMax;
        fireOnPostWrite(PROPERTY_FBAR_GROUP_MAX, oldValue, fbarGroupMax);
    }

    @Override
    public int getFbarGroupMax() {
        int result = this.fbarGroupMax;

        return result;
    }

    @Override
    public void setAbundanceReferenceMonth(Month abundanceReferenceMonth) {
        Month oldValue = this.abundanceReferenceMonth;
        fireOnPreWrite(PROPERTY_ABUNDANCE_REFERENCE_MONTH, oldValue, abundanceReferenceMonth);
        this.abundanceReferenceMonth = abundanceReferenceMonth;
        fireOnPostWrite(PROPERTY_ABUNDANCE_REFERENCE_MONTH, oldValue, abundanceReferenceMonth);
    }

    @Override
    public Month getAbundanceReferenceMonth() {
        Month result = this.abundanceReferenceMonth;

        return result;
    }

    @Override
    public void setComputeFOnLandings(boolean computeFOnLandings) {
        boolean oldValue = this.computeFOnLandings;
        fireOnPreWrite(PROPERTY_COMPUTE_FON_LANDINGS, oldValue, computeFOnLandings);
        this.computeFOnLandings = computeFOnLandings;
        fireOnPostWrite(PROPERTY_COMPUTE_FON_LANDINGS, oldValue, computeFOnLandings);
    }

    @Override
    public boolean isComputeFOnLandings() {
        boolean result = this.computeFOnLandings;

        return result;
    }

    @Override
    public boolean getComputeFOnLandings() {
        boolean result = this.computeFOnLandings;

        return result;
    }

    @Override
    public void addPopulationGroup(PopulationGroup populationGroup) {
        fireOnPreWrite(PROPERTY_POPULATION_GROUP, null, populationGroup);
        if (this.populationGroup == null) {
            this.populationGroup = new ArrayList<PopulationGroup>();
        }

        populationGroup.setPopulation(this);

        this.populationGroup.add(populationGroup);
        fireOnPostWrite(PROPERTY_POPULATION_GROUP, this.populationGroup.size(), null, populationGroup);
    }

    @Override
    public void addAllPopulationGroup(List<PopulationGroup> populationGroup) {
        if (populationGroup == null) {
            return;
        }
        for (PopulationGroup item : populationGroup) {
            addPopulationGroup(item);
        }
    }

    @Override
    public void setPopulationGroup(List<PopulationGroup> populationGroup) {
        // Copy elements to keep data for fire with new reference
        List<PopulationGroup> oldValue = this.populationGroup != null ? new ArrayList<PopulationGroup>(this.populationGroup) : null;
        fireOnPreWrite(PROPERTY_POPULATION_GROUP, oldValue, populationGroup);
        this.populationGroup = populationGroup;
        fireOnPostWrite(PROPERTY_POPULATION_GROUP, oldValue, populationGroup);
    }

    @Override
    public void removePopulationGroup(PopulationGroup populationGroup) {
        fireOnPreWrite(PROPERTY_POPULATION_GROUP, populationGroup, null);
        if (this.populationGroup == null || !this.populationGroup.remove(populationGroup)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        populationGroup.setPopulation(null);

        fireOnPostWrite(PROPERTY_POPULATION_GROUP, this.populationGroup.size() + 1, populationGroup, null);
    }

    @Override
    public void clearPopulationGroup() {
        if (this.populationGroup == null) {
            return;
        }
        for (PopulationGroup item : this.populationGroup) {
            item.setPopulation(null);
        }
        List<PopulationGroup> oldValue = new ArrayList<PopulationGroup>(this.populationGroup);
        fireOnPreWrite(PROPERTY_POPULATION_GROUP, oldValue, this.populationGroup);
        this.populationGroup.clear();
        fireOnPostWrite(PROPERTY_POPULATION_GROUP, oldValue, this.populationGroup);
    }

    @Override
    public List<PopulationGroup> getPopulationGroup() {
        return populationGroup;
    }

    @Override
    public PopulationGroup getPopulationGroupByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(populationGroup, topiaId);
    }

    @Override
    public int sizePopulationGroup() {
        if (populationGroup == null) {
            return 0;
        }
        return populationGroup.size();
    }

    @Override
    public boolean isPopulationGroupEmpty() {
        int size = sizePopulationGroup();
        return size == 0;
    }

    @Override
    public void addPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {
        fireOnPreWrite(PROPERTY_POPULATION_SEASON_INFO, null, populationSeasonInfo);
        if (this.populationSeasonInfo == null) {
            this.populationSeasonInfo = new ArrayList<PopulationSeasonInfo>();
        }

        populationSeasonInfo.setPopulation(this);

        this.populationSeasonInfo.add(populationSeasonInfo);
        fireOnPostWrite(PROPERTY_POPULATION_SEASON_INFO, this.populationSeasonInfo.size(), null, populationSeasonInfo);
    }

    @Override
    public void addAllPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo) {
        if (populationSeasonInfo == null) {
            return;
        }
        for (PopulationSeasonInfo item : populationSeasonInfo) {
            addPopulationSeasonInfo(item);
        }
    }

    @Override
    public void setPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo) {
        // Copy elements to keep data for fire with new reference
        List<PopulationSeasonInfo> oldValue = this.populationSeasonInfo != null ? new ArrayList<PopulationSeasonInfo>(this.populationSeasonInfo) : null;
        fireOnPreWrite(PROPERTY_POPULATION_SEASON_INFO, oldValue, populationSeasonInfo);
        this.populationSeasonInfo = populationSeasonInfo;
        fireOnPostWrite(PROPERTY_POPULATION_SEASON_INFO, oldValue, populationSeasonInfo);
    }

    @Override
    public void removePopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {
        fireOnPreWrite(PROPERTY_POPULATION_SEASON_INFO, populationSeasonInfo, null);
        if (this.populationSeasonInfo == null || !this.populationSeasonInfo.remove(populationSeasonInfo)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        populationSeasonInfo.setPopulation(null);

        fireOnPostWrite(PROPERTY_POPULATION_SEASON_INFO, this.populationSeasonInfo.size() + 1, populationSeasonInfo, null);
    }

    @Override
    public void clearPopulationSeasonInfo() {
        if (this.populationSeasonInfo == null) {
            return;
        }
        for (PopulationSeasonInfo item : this.populationSeasonInfo) {
            item.setPopulation(null);
        }
        List<PopulationSeasonInfo> oldValue = new ArrayList<PopulationSeasonInfo>(this.populationSeasonInfo);
        fireOnPreWrite(PROPERTY_POPULATION_SEASON_INFO, oldValue, this.populationSeasonInfo);
        this.populationSeasonInfo.clear();
        fireOnPostWrite(PROPERTY_POPULATION_SEASON_INFO, oldValue, this.populationSeasonInfo);
    }

    @Override
    public List<PopulationSeasonInfo> getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    @Override
    public PopulationSeasonInfo getPopulationSeasonInfoByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(populationSeasonInfo, topiaId);
    }

    @Override
    public int sizePopulationSeasonInfo() {
        if (populationSeasonInfo == null) {
            return 0;
        }
        return populationSeasonInfo.size();
    }

    @Override
    public boolean isPopulationSeasonInfoEmpty() {
        int size = sizePopulationSeasonInfo();
        return size == 0;
    }

    @Override
    public void setSpecies(Species species) {
        Species oldValue = this.species;
        fireOnPreWrite(PROPERTY_SPECIES, oldValue, species);
        this.species = species;
        fireOnPostWrite(PROPERTY_SPECIES, oldValue, species);
    }

    @Override
    public Species getSpecies() {
        Species result = this.species;

        return result;
    }

    @Override
    public void addReproductionZone(Zone reproductionZone) {
        fireOnPreWrite(PROPERTY_REPRODUCTION_ZONE, null, reproductionZone);
        if (this.reproductionZone == null) {
            this.reproductionZone = new ArrayList<Zone>();
        }

        this.reproductionZone.add(reproductionZone);
        fireOnPostWrite(PROPERTY_REPRODUCTION_ZONE, this.reproductionZone.size(), null, reproductionZone);
    }

    @Override
    public void addAllReproductionZone(List<Zone> reproductionZone) {
        if (reproductionZone == null) {
            return;
        }
        for (Zone item : reproductionZone) {
            addReproductionZone(item);
        }
    }

    @Override
    public void setReproductionZone(List<Zone> reproductionZone) {
        // Copy elements to keep data for fire with new reference
        List<Zone> oldValue = this.reproductionZone != null ? new ArrayList<Zone>(this.reproductionZone) : null;
        fireOnPreWrite(PROPERTY_REPRODUCTION_ZONE, oldValue, reproductionZone);
        this.reproductionZone = reproductionZone;
        fireOnPostWrite(PROPERTY_REPRODUCTION_ZONE, oldValue, reproductionZone);
    }

    @Override
    public void removeReproductionZone(Zone reproductionZone) {
        fireOnPreWrite(PROPERTY_REPRODUCTION_ZONE, reproductionZone, null);
        if (this.reproductionZone == null || !this.reproductionZone.remove(reproductionZone)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_REPRODUCTION_ZONE, this.reproductionZone.size() + 1, reproductionZone, null);
    }

    @Override
    public void clearReproductionZone() {
        if (this.reproductionZone == null) {
            return;
        }
        List<Zone> oldValue = new ArrayList<Zone>(this.reproductionZone);
        fireOnPreWrite(PROPERTY_REPRODUCTION_ZONE, oldValue, this.reproductionZone);
        this.reproductionZone.clear();
        fireOnPostWrite(PROPERTY_REPRODUCTION_ZONE, oldValue, this.reproductionZone);
    }

    @Override
    public List<Zone> getReproductionZone() {
        return reproductionZone;
    }

    @Override
    public Zone getReproductionZoneByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(reproductionZone, topiaId);
    }

    @Override
    public int sizeReproductionZone() {
        if (reproductionZone == null) {
            return 0;
        }
        return reproductionZone.size();
    }

    @Override
    public boolean isReproductionZoneEmpty() {
        int size = sizeReproductionZone();
        return size == 0;
    }

    @Override
    public void addPopulationZone(Zone populationZone) {
        fireOnPreWrite(PROPERTY_POPULATION_ZONE, null, populationZone);
        if (this.populationZone == null) {
            this.populationZone = new ArrayList<Zone>();
        }

        this.populationZone.add(populationZone);
        fireOnPostWrite(PROPERTY_POPULATION_ZONE, this.populationZone.size(), null, populationZone);
    }

    @Override
    public void addAllPopulationZone(List<Zone> populationZone) {
        if (populationZone == null) {
            return;
        }
        for (Zone item : populationZone) {
            addPopulationZone(item);
        }
    }

    @Override
    public void setPopulationZone(List<Zone> populationZone) {
        // Copy elements to keep data for fire with new reference
        List<Zone> oldValue = this.populationZone != null ? new ArrayList<Zone>(this.populationZone) : null;
        fireOnPreWrite(PROPERTY_POPULATION_ZONE, oldValue, populationZone);
        this.populationZone = populationZone;
        fireOnPostWrite(PROPERTY_POPULATION_ZONE, oldValue, populationZone);
    }

    @Override
    public void removePopulationZone(Zone populationZone) {
        fireOnPreWrite(PROPERTY_POPULATION_ZONE, populationZone, null);
        if (this.populationZone == null || !this.populationZone.remove(populationZone)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_POPULATION_ZONE, this.populationZone.size() + 1, populationZone, null);
    }

    @Override
    public void clearPopulationZone() {
        if (this.populationZone == null) {
            return;
        }
        List<Zone> oldValue = new ArrayList<Zone>(this.populationZone);
        fireOnPreWrite(PROPERTY_POPULATION_ZONE, oldValue, this.populationZone);
        this.populationZone.clear();
        fireOnPostWrite(PROPERTY_POPULATION_ZONE, oldValue, this.populationZone);
    }

    @Override
    public List<Zone> getPopulationZone() {
        return populationZone;
    }

    @Override
    public Zone getPopulationZoneByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(populationZone, topiaId);
    }

    @Override
    public int sizePopulationZone() {
        if (populationZone == null) {
            return 0;
        }
        return populationZone.size();
    }

    @Override
    public boolean isPopulationZoneEmpty() {
        int size = sizePopulationZone();
        return size == 0;
    }

    @Override
    public void addRecruitmentZone(Zone recruitmentZone) {
        fireOnPreWrite(PROPERTY_RECRUITMENT_ZONE, null, recruitmentZone);
        if (this.recruitmentZone == null) {
            this.recruitmentZone = new ArrayList<Zone>();
        }

        this.recruitmentZone.add(recruitmentZone);
        fireOnPostWrite(PROPERTY_RECRUITMENT_ZONE, this.recruitmentZone.size(), null, recruitmentZone);
    }

    @Override
    public void addAllRecruitmentZone(List<Zone> recruitmentZone) {
        if (recruitmentZone == null) {
            return;
        }
        for (Zone item : recruitmentZone) {
            addRecruitmentZone(item);
        }
    }

    @Override
    public void setRecruitmentZone(List<Zone> recruitmentZone) {
        // Copy elements to keep data for fire with new reference
        List<Zone> oldValue = this.recruitmentZone != null ? new ArrayList<Zone>(this.recruitmentZone) : null;
        fireOnPreWrite(PROPERTY_RECRUITMENT_ZONE, oldValue, recruitmentZone);
        this.recruitmentZone = recruitmentZone;
        fireOnPostWrite(PROPERTY_RECRUITMENT_ZONE, oldValue, recruitmentZone);
    }

    @Override
    public void removeRecruitmentZone(Zone recruitmentZone) {
        fireOnPreWrite(PROPERTY_RECRUITMENT_ZONE, recruitmentZone, null);
        if (this.recruitmentZone == null || !this.recruitmentZone.remove(recruitmentZone)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_RECRUITMENT_ZONE, this.recruitmentZone.size() + 1, recruitmentZone, null);
    }

    @Override
    public void clearRecruitmentZone() {
        if (this.recruitmentZone == null) {
            return;
        }
        List<Zone> oldValue = new ArrayList<Zone>(this.recruitmentZone);
        fireOnPreWrite(PROPERTY_RECRUITMENT_ZONE, oldValue, this.recruitmentZone);
        this.recruitmentZone.clear();
        fireOnPostWrite(PROPERTY_RECRUITMENT_ZONE, oldValue, this.recruitmentZone);
    }

    @Override
    public List<Zone> getRecruitmentZone() {
        return recruitmentZone;
    }

    @Override
    public Zone getRecruitmentZoneByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(recruitmentZone, topiaId);
    }

    @Override
    public int sizeRecruitmentZone() {
        if (recruitmentZone == null) {
            return 0;
        }
        return recruitmentZone.size();
    }

    @Override
    public boolean isRecruitmentZoneEmpty() {
        int size = sizeRecruitmentZone();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getGrowth());
        tmp.add(getGrowthReverse());
        tmp.add(getMeanWeight());
        tmp.add(getPrice());
        tmp.add(getNaturalDeathRate());
        tmp.add(getReproductionEquation());
        tmp.add(getRecruitmentEquation());
        tmp.add(getCapturabilityEquation());
        tmp.add(getMaturityOgiveEquation());
        tmp.add(getReproductionRateEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("population", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulationGroup() != null) {
              tmp.addAll(getPopulationGroup());
           }
        if (getPopulationSeasonInfo() != null) {
              tmp.addAll(getPopulationSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_GEOGRAPHIC_ID, this.geographicId).
            append(PROPERTY_PLUS_GROUP, this.plusGroup).
            append(PROPERTY_GROWTH, this.growth).
            append(PROPERTY_GROWTH_REVERSE, this.growthReverse).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_MEAN_WEIGHT, this.meanWeight).
            append(PROPERTY_PRICE, this.price).
            append(PROPERTY_NATURAL_DEATH_RATE, this.naturalDeathRate).
            append(PROPERTY_CARACT_BIO_COMMENT, this.caractBioComment).
            append(PROPERTY_REPRODUCTION_EQUATION, this.reproductionEquation).
            append(PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, this.monthGapBetweenReproRecrutement).
            append(PROPERTY_RECRUITMENT_DISTRIBUTION, this.recruitmentDistribution).
            append(PROPERTY_RECRUITMENT_EQUATION, this.recruitmentEquation).
            append(PROPERTY_RECRUITMENT_COMMENT, this.recruitmentComment).
            append(PROPERTY_ZONES_COMMENT, this.zonesComment).
            append(PROPERTY_SEASONS_COMMENT, this.seasonsComment).
            append(PROPERTY_CAPTURABILITY_COMMENT, this.capturabilityComment).
            append(PROPERTY_MIGRATION_COMMENT, this.migrationComment).
            append(PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, this.mappingZoneReproZoneRecru).
            append(PROPERTY_CAPTURABILITY, this.capturability).
            append(PROPERTY_CAPTURABILITY_EQUATION_USED, this.capturabilityEquationUsed).
            append(PROPERTY_CAPTURABILITY_EQUATION, this.capturabilityEquation).
            append(PROPERTY_MATURITY_OGIVE_EQUATION, this.maturityOgiveEquation).
            append(PROPERTY_REPRODUCTION_RATE_EQUATION, this.reproductionRateEquation).
            append(PROPERTY_FBAR_GROUP_MIN, this.fbarGroupMin).
            append(PROPERTY_FBAR_GROUP_MAX, this.fbarGroupMax).
            append(PROPERTY_ABUNDANCE_REFERENCE_MONTH, this.abundanceReferenceMonth).
            append(PROPERTY_COMPUTE_FON_LANDINGS, this.computeFOnLandings).
            append(PROPERTY_REPRODUCTION_ZONE, this.reproductionZone).
            append(PROPERTY_POPULATION_ZONE, this.populationZone).
            append(PROPERTY_RECRUITMENT_ZONE, this.recruitmentZone).
         toString();
        return result;
    }

} //PopulationAbstract
