/*
 * #%L
 * $Id: MigrationV41V421.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/datastore/migration/MigrationV41V421.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.datastore.migration;

import java.util.List;

import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion;
import org.nuiton.util.version.Version;

/**
 * Migration between version 4.1 and 4.2.1.
 * 
 * @author chatellier
 * @version $Revision: 4156 $
 * 
 * Last update : $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * By : $Author: echatellier $
 */
public class MigrationV41V421 extends MigrationCallBackForVersion {

    /**
     * Constructor.
     * 
     * @param version version
     * @param callback callback
     */
    public MigrationV41V421(Version version, TopiaMigrationCallbackByClass callback) {
        super(version, callback);
    }

    /*
     * @see org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion#prepareMigrationScript(org.nuiton.topia.framework.TopiaContextImplementor, java.util.List, boolean, boolean)
     */
    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
            List<String> queries, boolean showSql, boolean showProgression)
            throws TopiaException {
        
        // utilisation du if not exists parce que potentiellement
        // déjà fait un v 4.0
        queries.add("alter table POPULATION add column IF NOT EXISTS groupmin integer default 0");
        queries.add("alter table POPULATION add column IF NOT EXISTS groupmax integer default 0");
    }
}
