/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.models.optimization.ExportObservationTableModel;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellEditor;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import fr.ifremer.isisfish.ui.simulator.OptimizationUI;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.ListModel;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class OptimizationHandler {
    private static final Log log = LogFactory.getLog(OptimizationHandler.class);
    protected FactorEditorListener factorEditorListener;

    public void init(OptimizationUI view) {
    }

    public void refresh(OptimizationUI view) {
        SimulAction simulAction = view.getContextValue(SimulAction.class);
        SimulationParameter param = simulAction.getSimulationParameter();
        RegionStorage regionStorage = view.getContextValue(RegionStorage.class);
        if (param.getObjective() != null) {
            view.getFieldObjectiveMethodSelect().setSelectedItem(ObjectiveStorage.getName(param.getObjective()));
        }
        if (param.getOptimization() != null) {
            view.getFieldOptimizationMethodSelect().setSelectedItem(OptimizationStorage.getName(param.getOptimization()));
        }
        view.getExportObservationTable().setModel(this.getExportObservationTableModel(view));
        view.getExportObservationTable().getColumnModel().getColumn(0).setCellRenderer(new ExportTableCellRenderer());
        ExportTableCellEditor editor = new ExportTableCellEditor();
        editor.setRegionStorage(regionStorage);
        view.getExportObservationTable().getColumnModel().getColumn(1).setCellEditor(editor);
        view.getExportObservationTable().getColumnModel().getColumn(1).setCellRenderer(new ExportTableCellRenderer());
    }

    protected SimulationParameter getSimulationParameter(OptimizationUI view) {
        SimulAction simulAction = view.getContextValue(SimulAction.class);
        SimulationParameter param = simulAction.getSimulationParameter();
        return param;
    }

    public GenericComboModel<String> getObjectiveComboModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : ObjectiveStorage.getObjectiveNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public void objectiveChanged(OptimizationUI view) {
        Objective objective;
        RegionStorage regionStorage;
        SimulationParameter param;
        block4: {
            String objectiveName = (String)view.getFieldObjectiveMethodSelect().getSelectedItem();
            param = this.getSimulationParameter(view);
            regionStorage = view.getContextValue(RegionStorage.class);
            objective = param.getObjective();
            if (objective == null || !objective.getClass().getSimpleName().equals(objectiveName)) {
                try {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                    objective = (Objective)objectiveStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (objective != null) {
            param.setObjective(objective);
            ScriptParametersTableModel parametersTableModel = new ScriptParametersTableModel(objective);
            view.getSimulObjectiveMethodParam().setModel(parametersTableModel);
            view.getSimulObjectiveMethodParam().getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(objective));
            ScriptParametersTableCellEditor editor = new ScriptParametersTableCellEditor(objective);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener(view));
            view.getSimulObjectiveMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    protected FactorEditorListener getFactorActionListener(final OptimizationUI view) {
        if (this.factorEditorListener == null) {
            this.factorEditorListener = new FactorEditorListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    final SensitivityTabUI sensitivityTabUI = new SensitivityTabUI((JAXXContext)view);
                    sensitivityTabUI.setContextValue(new InputAction());
                    sensitivityTabUI.setContextValue(new SensitivitySaveVerifier());
                    sensitivityTabUI.setContextValue(view.getParentContainer(SimulationUI.class), "SimulationUI");
                    try {
                        RegionStorage regionStorage = view.getContextValue(RegionStorage.class);
                        TopiaContext tx = regionStorage.getStorage().beginTransaction();
                        FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                        sensitivityTabUI.setFisheryRegion(fisheryRegion);
                        sensitivityTabUI.setTreeModel();
                    }
                    catch (Exception ex) {
                        throw new IsisFishRuntimeException("Can't init dialog tree", ex);
                    }
                    JDialog dialog = new JDialog();
                    dialog.setTitle("S\u00e9lection d'un facteur");
                    dialog.add(sensitivityTabUI);
                    dialog.setSize(800, 600);
                    dialog.setLocationRelativeTo((Component)((Object)view));
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            FactorGroup factorGroup = sensitivityTabUI.getContextValue(SimulAction.class).getFactorGroup();
                            if (factorGroup.size() > 0) {
                                Factor factor = factorGroup.get(factorGroup.size() - 1);
                                sensitivityTabUI.getContextValue(SimulAction.class).removeFactor(factor.getPath());
                                this.setSelectedFactor(factor);
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            };
        }
        return this.factorEditorListener;
    }

    public GenericComboModel<String> getOptimizationComboModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : OptimizationStorage.getOptimizationNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public void optimizationChanged(OptimizationUI view) {
        Optimization optimization;
        RegionStorage regionStorage;
        SimulationParameter param;
        block4: {
            String optimizationName = (String)view.getFieldOptimizationMethodSelect().getSelectedItem();
            param = this.getSimulationParameter(view);
            regionStorage = view.getContextValue(RegionStorage.class);
            optimization = param.getOptimization();
            if (optimization == null || !optimization.getClass().getSimpleName().equals(optimizationName)) {
                try {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                    optimization = (Optimization)optimizationStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (optimization != null) {
            param.setOptimization(optimization);
            ScriptParametersTableModel parametersTableModel = new ScriptParametersTableModel(optimization);
            view.getSimulOptimizationMethodParam().setModel(parametersTableModel);
            view.getSimulOptimizationMethodParam().getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(optimization));
            ScriptParametersTableCellEditor editor = new ScriptParametersTableCellEditor(optimization);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener(view));
            view.getSimulOptimizationMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    public ListModel<String> getExportListModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : ExportStorage.getExportNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public ExportObservationTableModel getExportObservationTableModel(OptimizationUI view) {
        SimulationParameter param = this.getSimulationParameter(view);
        Map<Export, Observation> optimizationExportsObservations = param.getOptimizationExportsObservations();
        ExportObservationTableModel model = new ExportObservationTableModel(optimizationExportsObservations);
        return model;
    }

    public void addExports(OptimizationUI view) {
        SimulationParameter param = this.getSimulationParameter(view);
        ExportObservationTableModel tableModel = (ExportObservationTableModel)view.getExportObservationTable().getModel();
        List<String> selectedExports = view.getFieldExportList().getSelectedValuesList();
        for (String selectedExport : selectedExports) {
            try {
                ExportStorage exportStorage = ExportStorage.getExport(selectedExport, new CodeSourceStorage.Location[0]);
                Export export = (Export)exportStorage.getNewInstance();
                Map<Export, Observation> optimizationExports = param.getOptimizationExportsObservations();
                optimizationExports.put(export, null);
                tableModel.setOptimizationExportsObservations(optimizationExports);
                param.setOptimizationExportsObservations(optimizationExports);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't create new export", ex);
            }
        }
    }

    public void removeExports(OptimizationUI view) {
        SimulationParameter param = this.getSimulationParameter(view);
        Map<Export, Observation> optimizationExports = param.getOptimizationExportsObservations();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)view.getExportObservationTable().getModel();
        JTable table = view.getExportObservationTable();
        int[] rows = table.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            Export export = tableModel.getExportForRow(rows[i]);
            optimizationExports.remove(export);
            tableModel.deleteExport(export);
        }
        param.setOptimizationExportsObservations(optimizationExports);
    }

    public void clearExports(OptimizationUI view) {
        SimulationParameter param = this.getSimulationParameter(view);
        Map<Export, Observation> optimizationExports = param.getOptimizationExportsObservations();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)view.getExportObservationTable().getModel();
        optimizationExports.clear();
        tableModel.setOptimizationExportsObservations(optimizationExports);
        param.setOptimizationExportsObservations(optimizationExports);
    }
}

