/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.check;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.check.CheckResult;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class CheckRegion {
    public static void check(Object parent, String name, Equation eq, CheckResult result) {
        if (eq == null) {
            result.addError(parent, I18n.t((String)"isisfish.error.invalid.nullequation", (Object[])new Object[]{name}));
        } else if (0 != EvaluatorHelper.check(eq.getJavaInterface(), eq.getContent(), null)) {
            result.addError(eq, I18n.t((String)"isisfish.error.invalid.equation", (Object[])new Object[0]));
        }
    }

    public static void check(TargetSpecies capturabilite, CheckResult result) {
        CheckRegion.check(capturabilite, "TargetFactorEquation", capturabilite.getTargetFactorEquation(), result);
    }

    public static void check(PopulationGroup classPop, CheckResult result) {
        if (classPop.getMeanWeight() < 0.0) {
            result.addError(classPop, I18n.t((String)"isisfish.error.invalid.mean.weight", (Object[])new Object[0]));
        }
        if (classPop.getMeanWeight() == 0.0) {
            result.addWarning(classPop, I18n.t((String)"isisfish.error.not.null.mean.weight", (Object[])new Object[0]));
        }
    }

    public static void check(Gear engin, CheckResult result) {
        Collection<Selectivity> selectivites;
        if (StringUtils.isBlank((CharSequence)engin.getName())) {
            result.addWarning(engin, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)engin.getEffortUnit())) {
            result.addWarning(engin, I18n.t((String)"isisfish.error.empty.unit", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(selectivites = engin.getPopulationSelectivity())) {
            result.addWarning(engin, I18n.t((String)"isisfish.error.empty.selectivity", (Object[])new Object[0]));
        } else {
            for (Selectivity selectivity : selectivites) {
                CheckRegion.check(selectivity, result);
            }
        }
        if (engin.getPossibleValue() == null) {
            result.addWarning(engin, I18n.t((String)"isisfish.error.invalid.range", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)engin.getParameterName())) {
            result.addInfo(engin, I18n.t((String)"isisfish.error.empty.params.name", (Object[])new Object[0]));
        }
    }

    public static void check(MetierSeasonInfo infoSaisonMetier, CheckResult result) {
        Collection<TargetSpecies> especeCaptus;
        if (CollectionUtils.isEmpty(infoSaisonMetier.getZone())) {
            result.addWarning(infoSaisonMetier, I18n.t((String)"isisfish.error.no.sector", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(especeCaptus = infoSaisonMetier.getSpeciesTargetSpecies())) {
            result.addInfo(infoSaisonMetier, I18n.t((String)"isisfish.error.empty.species", (Object[])new Object[0]));
        } else {
            for (TargetSpecies i : especeCaptus) {
                CheckRegion.check(i, result);
            }
        }
    }

    public static boolean isEmptyMatrix(Object entity, MatrixND mat) {
        boolean result = true;
        MatrixIterator i = mat.iterator();
        while (result && i.next()) {
            result = false;
        }
        return result;
    }

    public static boolean isNullMatrix(MatrixND mat) {
        boolean result = true;
        if (mat != null) {
            MatrixIterator i = mat.iteratorNotZero();
            while (result && i.next()) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isNegativeMatrix(MatrixND mat) {
        boolean result = true;
        MatrixIterator i = mat.iterator();
        while (result && i.next()) {
            result = i.getValue() < 0.0;
        }
        return result;
    }

    public static double sumMatrix(MatrixND mat) {
        double result = mat.sumAll();
        return result;
    }

    public static void check(PopulationSeasonInfo infoSaisonPop, CheckResult result) {
        if (infoSaisonPop.getUseEquationMigration()) {
            CheckRegion.check(infoSaisonPop, "MigrationEquation", infoSaisonPop.getMigrationEquation(), result);
            CheckRegion.check(infoSaisonPop, "EmigrationEquation", infoSaisonPop.getEmigrationEquation(), result);
            CheckRegion.check(infoSaisonPop, "ImmigrationEquation", infoSaisonPop.getImmigrationEquation(), result);
        } else {
            try {
                if (CheckRegion.isEmptyMatrix(infoSaisonPop, infoSaisonPop.getMigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.migration", (Object[])new Object[0]));
                } else if (CheckRegion.isNullMatrix(infoSaisonPop.getMigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.migration", (Object[])new Object[0]));
                } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getMigrationMatrix())) {
                    result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.migration.negative", (Object[])new Object[0]));
                }
            }
            catch (NullPointerException e) {
                result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.null.semantics", (Object[])new Object[]{"MigrationEquation"}));
            }
            try {
                if (CheckRegion.isEmptyMatrix(infoSaisonPop, infoSaisonPop.getEmigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.emigration", (Object[])new Object[0]));
                } else if (CheckRegion.isNullMatrix(infoSaisonPop.getEmigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.emigration", (Object[])new Object[0]));
                } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getEmigrationMatrix())) {
                    result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.emigration.negative", (Object[])new Object[0]));
                }
            }
            catch (NullPointerException e) {
                result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.null.semantics", (Object[])new Object[]{"EmigrationEquation"}));
            }
            try {
                if (CheckRegion.isEmptyMatrix(infoSaisonPop, infoSaisonPop.getImmigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.immigration", (Object[])new Object[0]));
                } else if (CheckRegion.isNullMatrix(infoSaisonPop.getImmigrationMatrix())) {
                    result.addInfo(infoSaisonPop, I18n.t((String)"isisfish.error.empty.immigration", (Object[])new Object[0]));
                } else if (CheckRegion.isNegativeMatrix(infoSaisonPop.getImmigrationMatrix())) {
                    result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.immigration.negative", (Object[])new Object[0]));
                }
            }
            catch (NullPointerException e) {
                result.addError(infoSaisonPop, I18n.t((String)"isisfish.error.null.semantics", (Object[])new Object[]{"ImmigrationEquation"}));
            }
        }
    }

    public static void check(Cell maille, CheckResult result) {
        if (StringUtils.isBlank((CharSequence)maille.getName())) {
            result.addWarning(maille, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
    }

    public static void check(Species metaPop, CheckResult result) {
        Collection<Population> pops = metaPop.getPopulation();
        if (CollectionUtils.isEmpty(pops)) {
            result.addWarning(metaPop, I18n.t((String)"isisfish.error.empty.population", (Object[])new Object[0]));
        } else {
            for (Population pop : pops) {
                CheckRegion.check(pop, result);
            }
        }
        if (StringUtils.isBlank((CharSequence)metaPop.getName())) {
            result.addInfo(metaPop, I18n.t((String)"isisfish.error.empty.species.name", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)metaPop.getScientificName())) {
            result.addInfo(metaPop, I18n.t((String)"isisfish.error.empty.scientific.name", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)metaPop.getCodeRubbin())) {
            result.addInfo(metaPop, I18n.t((String)"isisfish.error.empty.code.rubbin", (Object[])new Object[0]));
        }
    }

    public static void check(Metier metier, CheckResult result) {
        List<MetierSeasonInfo> infoSaisons;
        if (StringUtils.isBlank((CharSequence)metier.getName())) {
            result.addWarning(metier, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(infoSaisons = metier.getMetierSeasonInfo())) {
            result.addWarning(metier, I18n.t((String)"isisfish.error.empty.season", (Object[])new Object[0]));
        } else {
            HashSet<Month> months = new HashSet<Month>();
            for (MetierSeasonInfo info : infoSaisons) {
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, I18n.t((String)"isisfish.error.overlap.season", (Object[])new Object[0]));
                }
                months.addAll(info.getMonths());
                CheckRegion.check(info, result);
            }
        }
        if (metier.getGear() == null) {
            result.addError(metier, I18n.t((String)"isisfish.error.undefined.gear", (Object[])new Object[0]));
        } else {
            CheckRegion.check(metier.getGear(), result);
            try {
                if (!metier.getGear().getPossibleValue().contains(metier.getGearParameterValue())) {
                    result.addWarning(metier, I18n.t((String)"isisfish.error.invalid.values.params", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                result.addWarning(metier, I18n.t((String)"isisfish.error.invalid.values.params", (Object[])new Object[0]));
            }
        }
    }

    public static void check(Population pop, CheckResult result) {
        List<PopulationSeasonInfo> infoSaisons;
        if (StringUtils.isBlank((CharSequence)pop.getName())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)pop.getGeographicId())) {
            result.addInfo(pop, I18n.t((String)"isisfish.error.empty.id.geographic", (Object[])new Object[0]));
        }
        CheckRegion.check(pop, "MaturityOgiveEquation", pop.getMaturityOgiveEquation(), result);
        CheckRegion.check(pop, "ReproductionRateEquation", pop.getReproductionRateEquation(), result);
        CheckRegion.check(pop, "Growth", pop.getGrowth(), result);
        CheckRegion.check(pop, "GrowthReverse", pop.getGrowthReverse(), result);
        List<PopulationGroup> classes = pop.getPopulationGroup();
        if (CollectionUtils.isEmpty(classes)) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.undefined.classes", (Object[])new Object[0]));
        } else {
            for (PopulationGroup group : classes) {
                CheckRegion.check(group, result);
            }
        }
        if (pop.getMonthGapBetweenReproRecrutement() < 0) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.invalid.interval.reproduction.recruitment", (Object[])new Object[0]));
        }
        if (CheckRegion.isNullMatrix(pop.getMappingZoneReproZoneRecru())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.undefined.correspondence.zones.reproduction.recruitment", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(pop.getPopulationZone())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.undefined.zone.population", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(pop.getRecruitmentZone())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.undefined.zone.recruitment", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(pop.getReproductionZone())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.undefined.zone.reproduction", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(infoSaisons = pop.getPopulationSeasonInfo())) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.empty.season", (Object[])new Object[0]));
        } else {
            HashSet<Month> months = new HashSet<Month>();
            for (PopulationSeasonInfo info : infoSaisons) {
                if (!Collections.disjoint(months, info.getMonths())) {
                    result.addError(info, I18n.t((String)"isisfish.error.overlap.season", (Object[])new Object[0]));
                }
                months.addAll(info.getMonths());
                CheckRegion.check(info, result);
            }
        }
        CheckRegion.check(pop, "Price", pop.getPrice(), result);
        CheckRegion.check(pop, "MeanWeight", pop.getMeanWeight(), result);
        CheckRegion.check(pop, "ReproductionEquation", pop.getReproductionEquation(), result);
        CheckRegion.check(pop, "NaturalDeathRate", pop.getNaturalDeathRate(), result);
        if (pop.getRecruitmentDistribution() == null || CheckRegion.sumMatrix(pop.getRecruitmentDistribution()) != 1.0) {
            result.addWarning(pop, I18n.t((String)"isisfish.error.invalid.distribution.recruitment", (Object[])new Object[0]));
        }
    }

    public static void check(FisheryRegion region, CheckResult result) {
        List<Zone> secteurs;
        if (StringUtils.isBlank((CharSequence)region.getName())) {
            result.addWarning(region, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(secteurs = region.getZone())) {
            result.addWarning(region, I18n.t((String)"isisfish.error.undefined.sector", (Object[])new Object[0]));
        } else {
            for (Zone zone : secteurs) {
                CheckRegion.check(zone, result);
            }
        }
        List<Cell> mailles = region.getCell();
        if (CollectionUtils.isEmpty(mailles)) {
            result.addWarning(region, I18n.t((String)"isisfish.error.undefined.mesh", (Object[])new Object[0]));
        } else {
            for (Cell cell : mailles) {
                CheckRegion.check(cell, result);
            }
        }
        List<Species> metaPops = region.getSpecies();
        if (CollectionUtils.isEmpty(metaPops)) {
            result.addWarning(region, I18n.t((String)"isisfish.error.undefined.meta.population", (Object[])new Object[0]));
        } else {
            for (Species species : metaPops) {
                CheckRegion.check(species, result);
            }
        }
        List<Metier> metiers = region.getMetier();
        if (CollectionUtils.isEmpty(metiers)) {
            result.addWarning(region, I18n.t((String)"isisfish.error.undefined.meta.population", (Object[])new Object[0]));
        } else {
            for (Metier metier : metiers) {
                CheckRegion.check(metier, result);
            }
        }
        List<Strategy> strategies = region.getStrategy();
        if (CollectionUtils.isEmpty(strategies)) {
            result.addWarning(region, I18n.t((String)"isisfish.error.undefined.stategy", (Object[])new Object[0]));
        } else {
            for (Strategy strategy : strategies) {
                CheckRegion.check(strategy, result);
            }
        }
    }

    public static void check(Zone secteur, CheckResult result) {
        if (StringUtils.isBlank((CharSequence)secteur.getName())) {
            result.addWarning(secteur, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(secteur.getCell())) {
            result.addWarning(secteur, I18n.t((String)"isisfish.error.undefined.mesh.sector", (Object[])new Object[0]));
        }
    }

    public static void check(Selectivity selectivite, CheckResult result) {
    }

    public static void check(Strategy strategy, CheckResult result) {
        if (StringUtils.isBlank((CharSequence)strategy.getName())) {
            result.addWarning(strategy, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        CheckRegion.check(strategy.getSetOfVessels(), result);
        List<StrategyMonthInfo> smi = strategy.getStrategyMonthInfo();
        if (smi == null || smi.size() != 12) {
            result.addWarning(strategy, I18n.t((String)"isisfish.error.undefined.stategy.months", (Object[])new Object[0]));
        } else {
            for (StrategyMonthInfo info : smi) {
                CheckRegion.check(info, result);
            }
        }
    }

    public static void check(SetOfVessels sov, CheckResult result) {
        Collection<EffortDescription> efforts;
        CheckRegion.check(sov.getPort(), result);
        if (sov.getNumberOfVessels() < 0) {
            result.addWarning(sov, I18n.t((String)"isisfish.error.invalid.number", (Object[])new Object[0]));
        }
        if (sov.getFixedCosts() < 0.0) {
            result.addWarning(sov, I18n.t((String)"isisfish.error.invalid.costs.fix", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(efforts = sov.getPossibleMetiers())) {
            result.addWarning(sov, I18n.t((String)"isisfish.error.not.possible.metier", (Object[])new Object[0]));
        } else {
            for (EffortDescription effort : efforts) {
                CheckRegion.check(effort, result);
            }
        }
    }

    public static void check(EffortDescription effort, CheckResult result) {
    }

    public static void check(StrategyMonthInfo smi, CheckResult result) {
    }

    public static void check(VesselType vesselType, CheckResult result) {
    }

    public static void check(TripType tripType, CheckResult result) {
    }

    public static void check(Port port, CheckResult result) {
        if (StringUtils.isBlank((CharSequence)port.getName())) {
            result.addWarning(port, I18n.t((String)"isisfish.error.empty.name", (Object[])new Object[0]));
        }
        if (port.getCell() == null) {
            result.addWarning(port, I18n.t((String)"isisfish.error.undefined.mesh.sector", (Object[])new Object[0]));
        }
    }
}

