/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.WelcomeSaveVerifier;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.WelcomeUI;
import fr.ifremer.isisfish.ui.config.RConfigHandler;
import fr.ifremer.isisfish.ui.config.RConfigUI;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.result.ResultUI;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.simulator.SimulUI;
import fr.ifremer.isisfish.ui.vcs.VCSConfigUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.AboutFrame;

public class WelcomeHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(WelcomeHandler.class);
    protected Map<JFrame, WelcomePanelUI> allFrameOpened;
    protected WelcomeSaveVerifier verifier = new WelcomeSaveVerifier();
    protected static final Map<String, String> URLSALIAS = new HashMap<String, String>();

    public void postInit(WelcomeUI welcomeUI) {
        welcomeUI.setContextValue(this.verifier);
        this.allFrameOpened = new HashMap<JFrame, WelcomePanelUI>();
        welcomeUI.getWelcomePanelUI().setContent(new WelcomeTabUI((JAXXContext)new JAXXInitialContext().add((Object)this.verifier)));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(0);
        toolTipManager.setDismissDelay(60000);
    }

    protected void openFrame(WelcomeUI welcomeUI, Component c, String title) {
        JAXXInitialContext childContext = new JAXXInitialContext().add((Object)this.verifier).add((Object)this);
        WelcomePanelUI welcome = new WelcomePanelUI((JAXXContext)childContext);
        welcome.setContent(c);
        JFrame frame = new JFrame(title);
        frame.setLayout(new BorderLayout());
        frame.add((Component)welcome, "Center");
        frame.setSize(new Dimension(800, 600));
        frame.setDefaultCloseOperation(0);
        this.allFrameOpened.put(frame, welcome);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                WelcomeHandler.this.allFrameOpened.get(f).close(f);
            }
        });
        frame.setLocationRelativeTo(welcomeUI);
        frame.setVisible(true);
    }

    public void newSimulationFrame(WelcomeUI welcomeUI) {
        JAXXInitialContext context = new JAXXInitialContext();
        context.add((Object)new SimulAction());
        context.add((Object)this);
        SimulUI simulUI = new SimulUI((JAXXContext)context);
        this.openFrame(welcomeUI, simulUI, I18n.t((String)"isisfish.simulation.title", (Object[])new Object[0]));
    }

    public void newResultFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new ResultUI(), I18n.t((String)"isisfish.result.title", (Object[])new Object[0]));
    }

    public void newInputFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new InputUI((JAXXContext)new JAXXInitialContext().add((Object)this.verifier).add((Object)new InputAction()).add((Object)new InputSaveVerifier()).add((Object)this)), I18n.t((String)"isisfish.input.title", (Object[])new Object[0]));
    }

    public void newScriptFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new ScriptUI(), I18n.t((String)"isisfish.script.title", (Object[])new Object[0]));
    }

    public void newSensitivityFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, new SensitivityUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()).add((Object)new SensitivitySaveVerifier()).add((Object)new SimulAction()).add((Object)this)), I18n.t((String)"isisfish.sensitivity.title", (Object[])new Object[0]));
    }

    public void newQueueFrame(WelcomeUI welcomeUI) {
        this.openFrame(welcomeUI, (Component)((Object)new QueueUI()), I18n.t((String)"isisfish.queue.title", (Object[])new Object[0]));
    }

    public void close(WelcomeUI welcomeUI) {
        if (this.verifier.allIsSaved()) {
            welcomeUI.dispose();
        }
    }

    public void updateVCS(WelcomeUI welcomeUI) {
    }

    public void config(WelcomeUI welcomeUI) {
        ConfigUIHelper modelBuilder = new ConfigUIHelper((ApplicationConfig)IsisFish.config);
        modelBuilder.addCategory(I18n.t((String)"isisfish.config.category.main", (Object[])new Object[0]), I18n.t((String)"isisfish.config.category.main.description", (Object[])new Object[0]));
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.CONFIG_FILE);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.DATABASE_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.COMMUNITY_DATABASE_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.COMPILATION_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.MONITORING_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.JAVADOC_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.BACKUP_DIRECTORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.LOCALE);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_SHOW_ONLY_ERROR);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_SCRIPT_AUTOCONFIG);
        modelBuilder.addCategory(I18n.t((String)"isisfish.config.category.simulation", (Object[])new Object[0]), I18n.t((String)"isisfish.config.category.simulation.description", (Object[])new Object[0]));
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATOR_IN_MAXTHREADS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATOR_SUB_MAXPROCESS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATOR_SUB_MAXMEMORY);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_MATRIX_VECTOR_CLASS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_MATRIX_USE_LAZY_VECTOR);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.MAPPED_RESULT_MATRIX_VECTOR_CLASS);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_STORE_RESULT_ON_DISK);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SIMULATION_STORE_RESULT_CACHE_STEP);
        modelBuilder.addCategory(I18n.t((String)"isisfish.config.category.officialvcs", (Object[])new Object[0]), I18n.t((String)"isisfish.config.category.officialvcs.description", (Object[])new Object[0]));
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_TYPE);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_PROTOCOL);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_HOST_NAME);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_PATH);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_USER_NAME);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_USER_PASSWORD);
        modelBuilder.addCategory(I18n.t((String)"isisfish.config.category.communityvcs", (Object[])new Object[0]), I18n.t((String)"isisfish.config.category.communityvcs.description", (Object[])new Object[0]));
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_TYPE);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_PROTOCOL);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_HOST_NAME);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_PATH);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_USER_NAME);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.VCS_COMMUNITY_PASSWORD);
        modelBuilder.addCategory(I18n.t((String)"isisfish.config.category.misc", (Object[])new Object[0]), I18n.t((String)"isisfish.config.category.misc.description", (Object[])new Object[0]));
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SSH_KEY_FILE);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.USER_NAME);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.SMTP_SERVER);
        modelBuilder.addOption((ConfigOptionDef)IsisConfig.Option.USER_MAIL);
        ConfigUI configUI = modelBuilder.buildUI((JAXXContext)welcomeUI, I18n.t((String)"isisfish.config.category.main", (Object[])new Object[0]));
        JDialog dialogUI = new JDialog((Frame)welcomeUI, I18n.t((String)"isisfish.config.title", (Object[])new Object[0]));
        dialogUI.add((Component)configUI);
        dialogUI.pack();
        dialogUI.setLocationRelativeTo(welcomeUI);
        dialogUI.setVisible(true);
    }

    public void configVCS(WelcomeUI welcomeUI) {
        VCSConfigUI vcsConfig = new VCSConfigUI((JAXXContext)welcomeUI, welcomeUI);
        vcsConfig.pack();
        vcsConfig.setLocationRelativeTo(welcomeUI);
        vcsConfig.setVisible(true);
    }

    public void configurationSSHLauncher(WelcomeUI welcomeUI) {
        SSHLauncherConfigUI configUI = new SSHLauncherConfigUI((JAXXContext)welcomeUI, welcomeUI);
        configUI.pack();
        configUI.setSize(600, configUI.getHeight());
        configUI.setLocationRelativeTo(welcomeUI);
        configUI.setVisible(true);
    }

    public void configurationR(WelcomeUI welcomeUI) {
        RConfigUI rconfigUI = new RConfigUI((JAXXContext)welcomeUI, welcomeUI);
        RConfigHandler handler = rconfigUI.getHandler();
        handler.init(rconfigUI);
        rconfigUI.pack();
        rconfigUI.setLocationRelativeTo(welcomeUI);
        rconfigUI.setVisible(true);
    }

    public void help(WelcomeUI welcomeUI, String urlOrAlias) {
        block3: {
            try {
                String url = URLSALIAS.get(urlOrAlias);
                if (url == null) {
                    url = urlOrAlias;
                }
                Desktop.getDesktop().browse(new URL(url).toURI());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't show help", (Throwable)e);
            }
        }
    }

    public void about(WelcomeUI welcomeUI) {
        AboutFrame about = new AboutFrame();
        about.setTitle(I18n.t((String)"isisfish.about.title", (Object[])new Object[0]));
        about.setIconPath("images/isislogo.png");
        about.setAboutHtmlText(I18n.t((String)"isisfish.about.abouthtmltext", (Object[])new Object[]{IsisConfig.getVersion()}));
        about.setLicenseText(I18n.t((String)"isisfish.about.licensetext", (Object[])new Object[0]));
        about.setBackgroundColor(Color.WHITE);
        about.setSize(640, 520);
        about.setLocationRelativeTo((Component)welcomeUI);
        about.setVisible(true);
    }

    static {
        URLSALIAS.put("ISISFISH", "http://www.isis-fish.org/");
        URLSALIAS.put("JAVA_API", "http://docs.oracle.com/javase/6/docs/api/index.html");
        URLSALIAS.put("ISIS_API", "http://www.isis-fish.org/apidocs/index.html");
        URLSALIAS.put("MATRIX_API", "http://maven-site.nuiton.org/nuiton-matrix/apidocs/index.html");
        URLSALIAS.put("TOPIA_API", "http://maven-site.nuiton.org/topia/topia-persistence/apidocs/index.html");
    }
}

