/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.StorageHelper;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterPropertiesHelper;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationPlanIndependent;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.SortedProperties;
import org.nuiton.util.StringUtil;
import org.nuiton.util.VersionUtil;

public class SimulationParameterImpl
implements SimulationParameter {
    private static final Log log = LogFactory.getLog(SimulationParameterImpl.class);
    protected Properties propertiesParameters;
    protected String isisFishVersion;
    protected String description;
    protected String regionName;
    protected Integer numberOfYear;
    protected String simulatorName;
    protected Boolean useCache;
    protected Boolean useStatistic;
    protected List<Strategy> strategies;
    protected List<Population> populations;
    protected Map<Population, MatrixND> numbers;
    protected List<Rule> rules;
    protected List<String> extraRules;
    protected List<SimulationPlan> simulationPlans;
    protected List<String> exportNames;
    protected Boolean usePreScript;
    protected String preScript;
    protected String generatedPreScript;
    protected Boolean useSimulationPlan;
    protected Integer simulationPlanNumber;
    protected List<SensitivityExport> sensitivityExports;
    protected Integer numberOfSensitivitySimulation;
    protected Boolean sensitivityAnalysisOnlyKeepFirst;
    protected SensitivityAnalysis sensitivityAnalysis;
    protected Boolean useOptimization;
    protected Optimization optimization;
    protected Objective objective;
    protected Map<Export, Observation> optimizationExportsObservations;
    protected Collection<String> resultEnabled;
    protected Map<String, String> tagValue;
    protected Boolean onlyExport;
    protected String simulLogLevel;
    protected String scriptLogLevel;
    protected String libLogLevel;
    protected transient RegionStorage region;

    @Override
    public List<String> check() {
        ArrayList<String> result = new ArrayList<String>();
        return result;
    }

    @Override
    public String getIsisFishVersion() {
        if (this.isisFishVersion == null) {
            this.isisFishVersion = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getIsisFishVersion(this.propertiesParameters) : IsisConfig.getVersion();
        }
        return this.isisFishVersion;
    }

    @Override
    public void setIsisFishVersion(String isisFishVersion) {
        this.isisFishVersion = isisFishVersion;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getDescription(this.propertiesParameters) : "";
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public RegionStorage getRegion() {
        if (this.region == null || !this.region.getName().equals(this.getRegionName())) {
            this.region = RegionStorage.getRegion(this.getRegionName());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"Region %s already inited", (Object[])new Object[]{this.getRegionName()}));
        }
        return this.region;
    }

    @Override
    public MatrixND getNumberOf(Population pop) {
        MatrixND result;
        if (this.numbers == null) {
            this.numbers = new LinkedHashMap<Population, MatrixND>();
        }
        if ((result = this.numbers.get(pop)) == null) {
            List<PopulationGroup> groups = pop.getPopulationGroup();
            List<Zone> zones = pop.getPopulationZone();
            if (groups.isEmpty()) {
                groups.add((PopulationGroup)((Object)"No group"));
            }
            if (zones.isEmpty()) {
                zones.add((Zone)((Object)"No zone"));
            }
            List[] semantics = new List[]{groups, zones};
            result = MatrixFactory.getInstance().create(I18n.n((String)"matrixAbundance", (Object[])new Object[0]), semantics, new String[]{I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
            this.numbers.put(pop, result);
        }
        return result;
    }

    @Override
    public List<String> getExtraRules() {
        if (this.extraRules == null) {
            this.extraRules = new ArrayList<String>();
        }
        return this.extraRules;
    }

    @Override
    public void addExtraRules(String ... extraRules) {
        this.getExtraRules().addAll(Arrays.asList(extraRules));
    }

    @Override
    public List<Population> getPopulations() {
        block11: {
            if (this.populations == null) {
                this.populations = new ArrayList<Population>();
                if (this.propertiesParameters != null) {
                    try {
                        String[] populationList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        PopulationDAO populationDAO = IsisFishDAOHelper.getPopulationDAO(tx);
                        for (String name : populationList = SimulationParameterPropertiesHelper.getPopulationNames(this.propertiesParameters)) {
                            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                            try {
                                Object population = populationDAO.findByName(name);
                                this.populations.add((Population)population);
                                List number = SimulationParameterPropertiesHelper.getPopulationNumbers(this.propertiesParameters, name);
                                MatrixND mat = this.getNumberOf((Population)population);
                                mat.fromList(number);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find population: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get PopulationDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip population reloading");
                }
            }
        }
        return this.populations;
    }

    @Override
    public void setPopulations(List<Population> populations) {
        this.populations = populations;
    }

    @Override
    public List<Strategy> getStrategies() {
        block11: {
            if (this.strategies == null) {
                this.strategies = new ArrayList<Strategy>();
                if (this.propertiesParameters != null) {
                    this.strategies = new ArrayList<Strategy>();
                    try {
                        String[] strategyList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        StrategyDAO strategyDAO = IsisFishDAOHelper.getStrategyDAO(tx);
                        for (String name : strategyList = SimulationParameterPropertiesHelper.getStrategieNames(this.propertiesParameters)) {
                            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                            try {
                                Object str = strategyDAO.findByName(name);
                                this.strategies.add((Strategy)str);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find strategy: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get StrategyDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip strategies reloading");
                }
            }
        }
        return this.strategies;
    }

    @Override
    public void setStrategies(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public void addSimulationPlan(SimulationPlan plan) {
        this.getSimulationPlans().add(plan);
    }

    @Override
    public boolean removeSimulationPlan(SimulationPlan plan) {
        return this.getSimulationPlans().remove(plan);
    }

    @Override
    public List<SimulationPlan> getSimulationPlans() {
        if (this.simulationPlans == null) {
            this.simulationPlans = new ArrayList<SimulationPlan>();
            if (this.propertiesParameters != null) {
                String[] planList = SimulationParameterPropertiesHelper.getSimulationPlanNames(this.propertiesParameters);
                int planIndex = 0;
                for (String name : planList) {
                    if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                    try {
                        SimulationPlanStorage planStorage = SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]);
                        if (planStorage == null) continue;
                        SimulationPlan plan = (SimulationPlan)planStorage.getNewInstance();
                        StorageHelper.populateStorageParams(planIndex++, this.getRegion().getStorage(), plan, this.propertiesParameters, "plan");
                        this.simulationPlans.add(plan);
                    }
                    catch (Exception eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't find plan: " + name), (Throwable)eee);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No last read properties, skip plans reloading");
            }
        }
        return this.simulationPlans;
    }

    @Override
    public void setSimulationPlans(List<SimulationPlan> plans) {
        this.simulationPlans = plans;
    }

    @Override
    public boolean isIndependentPlan() {
        boolean result = true;
        for (SimulationPlan plan : this.getSimulationPlans()) {
            if (plan instanceof SimulationPlanIndependent) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void clearPlans() {
        if (this.simulationPlans != null) {
            this.simulationPlans.clear();
        }
    }

    @Override
    public void addRule(Rule rule) {
        this.getRules().add(rule);
    }

    @Override
    public boolean removeRule(Rule rule) {
        return this.getRules().remove(rule);
    }

    @Override
    public List<Rule> getRules() {
        block11: {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] ruleList = SimulationParameterPropertiesHelper.getRuleNames(this.propertiesParameters);
                        int ruleIndex = 0;
                        for (String name : ruleList) {
                            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                            try {
                                Rule rule = (Rule)RuleStorage.getRule(name, new CodeSourceStorage.Location[0]).getNewInstance();
                                RuleHelper.populateRule(ruleIndex++, tx, rule, this.propertiesParameters);
                                this.rules.add(rule);
                            }
                            catch (Exception eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find rule: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip rule reloading");
                }
            }
        }
        return this.rules;
    }

    @Override
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public void clearRules() {
        if (this.rules != null) {
            this.rules.clear();
        }
    }

    @Override
    public boolean getUseCache() {
        if (this.useCache == null) {
            this.useCache = this.propertiesParameters != null ? (VersionUtil.smallerThan((String)this.getIsisFishVersion(), (String)"4.3.0.0") ? Boolean.valueOf(this.propertiesParameters.getProperty("useOptimization", "true")) : Boolean.valueOf(this.propertiesParameters.getProperty("useCache", "true"))) : Boolean.TRUE;
        }
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    @Override
    public boolean getUseStatistic() {
        if (this.useStatistic == null) {
            this.useStatistic = this.propertiesParameters != null ? Boolean.valueOf(SimulationParameterPropertiesHelper.getUseStatistic(this.propertiesParameters)) : Boolean.FALSE;
        }
        return this.useStatistic;
    }

    @Override
    public void setUseStatistic(boolean useStatistic) {
        this.useStatistic = useStatistic;
    }

    @Override
    public List<String> getExportNames() {
        if (this.exportNames == null) {
            this.exportNames = new ArrayList<String>();
            if (this.propertiesParameters != null) {
                String[] exportList;
                for (String name : exportList = SimulationParameterPropertiesHelper.getExportNames(this.propertiesParameters)) {
                    if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                    this.exportNames.add(name);
                }
            }
        }
        return this.exportNames;
    }

    @Override
    public void setExportNames(List<String> exportNames) {
        this.exportNames = exportNames;
    }

    @Override
    public int getNumberOfSensitivitySimulation() {
        if (this.numberOfSensitivitySimulation == null) {
            this.numberOfSensitivitySimulation = this.propertiesParameters != null ? Integer.valueOf(SimulationParameterPropertiesHelper.getNumberOfSensitivitySimulation(this.propertiesParameters)) : Integer.valueOf(-1);
        }
        return this.numberOfSensitivitySimulation;
    }

    @Override
    public void setNumberOfSensitivitySimulation(int numberOfSensitivitySimulation) {
        this.numberOfSensitivitySimulation = numberOfSensitivitySimulation;
    }

    @Override
    public SensitivityAnalysis getSensitivityAnalysis() {
        block3: {
            String analysisName;
            if (this.sensitivityAnalysis == null && this.propertiesParameters != null && StringUtils.isNotEmpty((CharSequence)(analysisName = SimulationParameterPropertiesHelper.getSensitivityAnalysis(this.propertiesParameters)))) {
                try {
                    SensitivityAnalysisStorage sensitivityStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(analysisName, new CodeSourceStorage.Location[0]);
                    this.sensitivityAnalysis = (SensitivityAnalysis)sensitivityStorage.getNewInstance();
                    StorageHelper.populateStorageParams(0, this.getRegion().getStorage(), this.sensitivityAnalysis, this.propertiesParameters, "sensitivity");
                }
                catch (Exception eee) {
                    this.sensitivityAnalysis = null;
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't find sensitivity: " + this.sensitivityAnalysis), (Throwable)eee);
                }
            }
        }
        return this.sensitivityAnalysis;
    }

    @Override
    public void setSensitivityAnalysis(SensitivityAnalysis sensitivityAnalysis) {
        this.sensitivityAnalysis = sensitivityAnalysis;
    }

    @Override
    public List<SensitivityExport> getSensitivityExport() {
        block11: {
            if (this.sensitivityExports == null) {
                this.sensitivityExports = new ArrayList<SensitivityExport>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDbResult();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] sensitivityExportList = SimulationParameterPropertiesHelper.getSensitivityExportNames(this.propertiesParameters);
                        int sensitivityExportIndex = 0;
                        for (String name : sensitivityExportList) {
                            try {
                                if (StringUtils.isEmpty((CharSequence)name)) continue;
                                SensitivityExport sensitivityExport = (SensitivityExport)SensitivityExportStorage.getSensitivityExport(name, new CodeSourceStorage.Location[0]).getNewInstance();
                                ExportHelper.populateSensitivityExport(sensitivityExportIndex++, tx, sensitivityExport, this.propertiesParameters);
                                this.sensitivityExports.add(sensitivityExport);
                            }
                            catch (Exception eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find SensitivityExport: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip sensitivity exports reloading");
                }
            }
        }
        return this.sensitivityExports;
    }

    @Override
    public void setSensitivityExport(List<SensitivityExport> sensitivityExport) {
        this.sensitivityExports = sensitivityExport;
    }

    @Override
    public Optimization getOptimization() {
        block3: {
            String optimizationName;
            if (this.optimization == null && this.propertiesParameters != null && !StringUtils.isEmpty((CharSequence)(optimizationName = SimulationParameterPropertiesHelper.getOptimizationName(this.propertiesParameters)))) {
                try {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                    this.optimization = (Optimization)optimizationStorage.getNewInstance();
                    StorageHelper.populateStorageParams(0, this.getRegion().getStorage(), this.optimization, this.propertiesParameters, "optimization");
                }
                catch (Exception eee) {
                    this.optimization = null;
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't find optimization: " + this.optimization), (Throwable)eee);
                }
            }
        }
        return this.optimization;
    }

    @Override
    public boolean getUseOptimization() {
        if (this.useOptimization == null) {
            this.useOptimization = this.propertiesParameters != null ? (VersionUtil.smallerThan((String)this.getIsisFishVersion(), (String)"4.3.0.0") ? Boolean.FALSE : Boolean.valueOf(this.propertiesParameters.getProperty("useOptimization", "false"))) : Boolean.FALSE;
        }
        return this.useOptimization;
    }

    @Override
    public void setUseOptimization(boolean useOptimization) {
        this.useOptimization = useOptimization;
    }

    @Override
    public void setOptimization(Optimization optimization) {
        this.optimization = optimization;
    }

    @Override
    public Objective getObjective() {
        block3: {
            String objectiveName;
            if (this.objective == null && this.propertiesParameters != null && !StringUtils.isEmpty((CharSequence)(objectiveName = SimulationParameterPropertiesHelper.getObjectiveName(this.propertiesParameters)))) {
                try {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                    this.objective = (Objective)objectiveStorage.getNewInstance();
                    StorageHelper.populateStorageParams(0, this.getRegion().getStorage(), this.objective, this.propertiesParameters, "objective");
                }
                catch (Exception eee) {
                    this.objective = null;
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't find objective: " + this.objective), (Throwable)eee);
                }
            }
        }
        return this.objective;
    }

    @Override
    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    @Override
    public Map<Export, Observation> getOptimizationExportsObservations() {
        block12: {
            if (this.optimizationExportsObservations == null) {
                this.optimizationExportsObservations = new LinkedHashMap<Export, Observation>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] optimizationExportList = SimulationParameterPropertiesHelper.getOptimizationExportNames(this.propertiesParameters);
                        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(tx);
                        int optimizationExportIndex = 0;
                        for (String name : optimizationExportList) {
                            block11: {
                                if (StringUtils.isNotBlank((CharSequence)name)) {
                                    try {
                                        Export export = (Export)ExportStorage.getExport(name, new CodeSourceStorage.Location[0]).getNewInstance();
                                        Observation observation = null;
                                        String observationId = this.propertiesParameters.getProperty("optimizationobservation." + optimizationExportIndex);
                                        if (StringUtils.isNotBlank((CharSequence)observationId)) {
                                            observation = (Observation)beanUtils.convert(observationId, TopiaEntity.class);
                                        }
                                        this.optimizationExportsObservations.put(export, observation);
                                    }
                                    catch (Exception eee) {
                                        if (!log.isWarnEnabled()) break block11;
                                        log.warn((Object)("Can't find rule: " + name), (Throwable)eee);
                                    }
                                }
                            }
                            ++optimizationExportIndex;
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                    }
                    catch (TopiaException eee) {
                        if (!log.isWarnEnabled()) break block12;
                        log.warn((Object)"Can't get TopiaContext", (Throwable)eee);
                    }
                }
            }
        }
        return this.optimizationExportsObservations;
    }

    @Override
    public void setOptimizationExportsObservations(Map<Export, Observation> optimizationExportsObservations) {
        this.optimizationExportsObservations = optimizationExportsObservations;
    }

    @Override
    public boolean getUseSimulationPlan() {
        if (this.useSimulationPlan == null) {
            this.useSimulationPlan = this.propertiesParameters != null ? Boolean.valueOf(SimulationParameterPropertiesHelper.getUseSimulationPlan(this.propertiesParameters)) : Boolean.FALSE;
        }
        return this.useSimulationPlan;
    }

    @Override
    public void setUseSimulationPlan(boolean useSimulationPlan) {
        this.useSimulationPlan = useSimulationPlan;
    }

    @Override
    public int getSimulationPlanNumber() {
        if (this.simulationPlanNumber == null) {
            this.simulationPlanNumber = this.propertiesParameters != null ? Integer.valueOf(SimulationParameterPropertiesHelper.getSimulationPlanNumber(this.propertiesParameters)) : Integer.valueOf(-1);
        }
        return this.simulationPlanNumber;
    }

    @Override
    public void setSimulationPlanNumber(int simulationPlanNumber) {
        this.simulationPlanNumber = simulationPlanNumber;
    }

    @Override
    public boolean isSensitivityAnalysisOnlyKeepFirst() {
        if (this.sensitivityAnalysisOnlyKeepFirst == null) {
            this.sensitivityAnalysisOnlyKeepFirst = this.propertiesParameters != null ? Boolean.valueOf(SimulationParameterPropertiesHelper.isSensitivityAnalysisOnlyKeepFirst(this.propertiesParameters)) : Boolean.FALSE;
        }
        return this.sensitivityAnalysisOnlyKeepFirst;
    }

    @Override
    public void setSensitivityAnalysisOnlyKeepFirst(boolean onlyKeepFirst) {
        this.sensitivityAnalysisOnlyKeepFirst = onlyKeepFirst;
    }

    @Override
    public int getNumberOfYear() {
        if (this.numberOfYear == null) {
            this.numberOfYear = this.propertiesParameters != null ? Integer.valueOf(SimulationParameterPropertiesHelper.getNumberOfYear(this.propertiesParameters)) : Integer.valueOf(1);
        }
        return this.numberOfYear;
    }

    @Override
    public void setNumberOfYear(int numberOfYear) {
        this.numberOfYear = numberOfYear;
    }

    @Override
    public boolean getUsePreScript() {
        if (this.usePreScript == null) {
            this.usePreScript = this.propertiesParameters != null ? Boolean.valueOf(SimulationParameterPropertiesHelper.getUsePreScript(this.propertiesParameters)) : Boolean.FALSE;
        }
        return this.usePreScript;
    }

    @Override
    public void setUsePreScript(boolean usePreScript) {
        this.usePreScript = usePreScript;
    }

    @Override
    public String getPreScript() {
        if (this.preScript == null) {
            this.preScript = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getPreScript(this.propertiesParameters) : "";
        }
        return this.preScript;
    }

    @Override
    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    @Override
    public String getGeneratedPreScript() {
        if (this.generatedPreScript == null) {
            this.generatedPreScript = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getGeneratedPreScript(this.propertiesParameters) : "";
        }
        return this.generatedPreScript;
    }

    @Override
    public void setGeneratedPreScript(String preScript) {
        this.generatedPreScript = preScript;
    }

    @Override
    public String getRegionName() {
        if (this.regionName == null) {
            this.regionName = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getRegionName(this.propertiesParameters) : "";
        }
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getSimulatorName() {
        if (this.simulatorName == null) {
            this.simulatorName = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getSimulatorName(this.propertiesParameters) : "DefaultSimulator.java";
        }
        return this.simulatorName;
    }

    @Override
    public void setSimulatorName(String simulatorName) {
        this.simulatorName = simulatorName;
    }

    @Override
    public Collection<String> getResultEnabled() {
        if (this.resultEnabled == null) {
            this.resultEnabled = new LinkedList<String>();
            if (this.propertiesParameters != null) {
                String[] resultList = SimulationParameterPropertiesHelper.getResultNames(this.propertiesParameters);
                Collections.addAll(this.resultEnabled, resultList);
            }
        }
        return this.resultEnabled;
    }

    @Override
    public void setResultEnabled(Collection<String> resultEnabled) {
        this.resultEnabled = resultEnabled;
    }

    @Override
    public Map<String, String> getTagValue() {
        if (this.tagValue == null) {
            this.tagValue = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getTagValue(this.propertiesParameters) : new LinkedHashMap<String, String>();
        }
        return this.tagValue;
    }

    @Override
    public void setTagValue(Map<String, String> tagValue) {
        this.tagValue = tagValue;
    }

    @Override
    public String getSimulLogLevel() {
        if (this.simulLogLevel == null) {
            this.simulLogLevel = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getSimulLogLevel(this.propertiesParameters) : "info";
        }
        return this.simulLogLevel;
    }

    @Override
    public void setSimulLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.simulLogLevel, logLevel}));
        }
        this.simulLogLevel = logLevel;
    }

    @Override
    public String getScriptLogLevel() {
        if (this.scriptLogLevel == null) {
            this.scriptLogLevel = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getScriptLogLevel(this.propertiesParameters) : "info";
        }
        return this.scriptLogLevel;
    }

    @Override
    public void setScriptLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.scriptLogLevel, logLevel}));
        }
        this.scriptLogLevel = logLevel;
    }

    @Override
    public String getLibLogLevel() {
        if (this.libLogLevel == null) {
            this.libLogLevel = this.propertiesParameters != null ? SimulationParameterPropertiesHelper.getLibLogLevel(this.propertiesParameters) : "error";
        }
        return this.libLogLevel;
    }

    @Override
    public void setLibLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n.t((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.libLogLevel, logLevel}));
        }
        this.libLogLevel = logLevel;
    }

    @Override
    public boolean isSimulErrorLevel() {
        return "error".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulWarnLevel() {
        return "warn".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulInfoLevel() {
        return "info".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulDebugLevel() {
        return "debug".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isScriptErrorLevel() {
        return "error".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptWarnLevel() {
        return "warn".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptInfoLevel() {
        return "info".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptDebugLevel() {
        return "debug".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isLibErrorLevel() {
        return "error".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibWarnLevel() {
        return "warn".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibInfoLevel() {
        return "info".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibDebugLevel() {
        return "debug".equals(this.getLibLogLevel());
    }

    @Override
    public void setProperty(String key, String value) {
        this.propertiesParameters.setProperty(key, value);
    }

    @Override
    public SimulationParameter copy() {
        SimulationParameterImpl result = new SimulationParameterImpl();
        if (this.propertiesParameters != null) {
            result.propertiesParameters = new SortedProperties();
            result.propertiesParameters.putAll((Map<?, ?>)this.propertiesParameters);
        }
        result.isisFishVersion = this.getIsisFishVersion();
        result.description = this.getDescription();
        result.regionName = this.getRegionName();
        result.numberOfYear = this.getNumberOfYear();
        result.simulatorName = this.getSimulatorName();
        result.useCache = this.getUseCache();
        result.useStatistic = this.getUseStatistic();
        result.usePreScript = this.getUsePreScript();
        result.preScript = this.getPreScript();
        result.generatedPreScript = this.getGeneratedPreScript();
        result.useSimulationPlan = this.getUseSimulationPlan();
        result.simulationPlanNumber = this.getSimulationPlanNumber();
        if (this.exportNames != null) {
            result.exportNames = new LinkedList<String>(this.exportNames);
        }
        if (this.strategies != null) {
            result.strategies = new LinkedList<Strategy>(this.strategies);
        }
        if (this.populations != null) {
            result.populations = new LinkedList<Population>(this.populations);
        }
        if (this.rules != null) {
            result.rules = new LinkedList<Rule>(this.rules);
        }
        if (this.simulationPlans != null) {
            result.simulationPlans = new LinkedList<SimulationPlan>(this.simulationPlans);
        }
        if (this.objective != null) {
            result.objective = this.objective;
        }
        result.useOptimization = this.getUseOptimization();
        if (this.optimization != null) {
            result.optimization = this.optimization;
        }
        if (this.optimizationExportsObservations != null) {
            result.optimizationExportsObservations = new LinkedHashMap<Export, Observation>(this.optimizationExportsObservations);
        }
        if (this.resultEnabled != null) {
            result.resultEnabled = new LinkedList<String>(this.resultEnabled);
        }
        if (this.numbers != null) {
            result.numbers = new HashMap<Population, MatrixND>(this.numbers);
        }
        if (this.tagValue != null) {
            result.tagValue = new HashMap<String, String>(this.tagValue);
        }
        result.simulLogLevel = this.getSimulLogLevel();
        result.scriptLogLevel = this.getScriptLogLevel();
        result.libLogLevel = this.getLibLogLevel();
        result.numberOfSensitivitySimulation = this.getNumberOfSensitivitySimulation();
        if (this.sensitivityExports != null) {
            result.sensitivityExports = new LinkedList<SensitivityExport>(this.sensitivityExports);
        }
        result.sensitivityAnalysis = this.sensitivityAnalysis;
        return result;
    }

    @Override
    public SimulationParameter deepCopy() {
        Properties props = this.toProperties();
        SimulationParameterImpl newInstance = new SimulationParameterImpl();
        newInstance.fromProperties(props);
        return newInstance;
    }

    @Override
    public String toString() {
        Properties prop = this.toProperties();
        return SimulationParameterPropertiesHelper.toString(prop);
    }

    @Override
    public Properties toProperties() {
        String sensitivityexports;
        String sensitivityanalysis;
        String optimization;
        String plans;
        String rules;
        String pops;
        String strs;
        SortedProperties result = new SortedProperties();
        result.setProperty("isisFishVersion", this.getIsisFishVersion());
        result.setProperty("description", this.getDescription());
        result.setProperty("regionName", this.getRegionName());
        result.setProperty("numberOfYear", String.valueOf(this.getNumberOfYear()));
        result.setProperty("simulatorName", this.getSimulatorName());
        result.setProperty("useCache", String.valueOf(this.getUseCache()));
        result.setProperty("useStatistic", String.valueOf(this.getUseStatistic()));
        if (this.strategies != null) {
            String strategyList = "";
            for (Strategy str : this.getStrategies()) {
                strategyList = strategyList + str.getName() + ",";
            }
            result.setProperty("strategies", StringUtil.substring((String)strategyList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && (strs = this.propertiesParameters.getProperty("strategies")) != null) {
            result.setProperty("strategies", strs);
        }
        if (this.populations != null) {
            String populationList = "";
            for (Population pop : this.getPopulations()) {
                populationList = populationList + pop.getName() + ",";
                MatrixND number = this.getNumberOf(pop);
                String numberAsString = String.valueOf(number.toList());
                result.setProperty("population." + pop.getName() + "." + "number", numberAsString);
            }
            result.setProperty("populations", StringUtil.substring((String)populationList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && (pops = this.propertiesParameters.getProperty("populations")) != null) {
            result.setProperty("populations", pops);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "population.");
        }
        if (this.rules != null) {
            String ruleList = "";
            int ruleIndex = 0;
            for (Rule rule : this.getRules()) {
                ruleList = ruleList + RuleStorage.getName(rule) + ",";
                Properties ruleProp = RuleHelper.getRuleAsProperties(ruleIndex++, this.getRegion().getStorage(), rule);
                result.putAll((Map<?, ?>)ruleProp);
            }
            result.setProperty("rules", ruleList);
        } else if (this.propertiesParameters != null && (rules = this.propertiesParameters.getProperty("rules")) != null) {
            result.setProperty("rules", rules);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "rule.");
        }
        if (this.simulationPlans != null) {
            String planList = "";
            int planIndex = 0;
            for (SimulationPlan plan : this.getSimulationPlans()) {
                planList = planList + SimulationPlanStorage.getName(plan) + ",";
                Properties planProp = StorageHelper.getParamsAsProperties(planIndex++, this.getRegion().getStorage(), plan, "plan");
                result.putAll((Map<?, ?>)planProp);
            }
            result.setProperty("plans", planList);
        } else if (this.propertiesParameters != null && (plans = this.propertiesParameters.getProperty("plans")) != null) {
            result.setProperty("plans", plans);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "plan.");
        }
        if (this.objective != null) {
            String objectiveName = ObjectiveStorage.getName(this.objective);
            Properties objectiveProp = StorageHelper.getParamsAsProperties(0, this.getRegion().getStorage(), this.objective, "objective");
            result.putAll((Map<?, ?>)objectiveProp);
            result.setProperty("objective", objectiveName);
        } else if (this.propertiesParameters != null) {
            String objective = this.propertiesParameters.getProperty("objective");
            if (objective != null) {
                result.setProperty("objective", objective);
                SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "objective.");
            }
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("objective.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.optimization != null) {
            String optimizationName = ObjectiveStorage.getName(this.optimization);
            Properties optimizationProp = StorageHelper.getParamsAsProperties(0, this.getRegion().getStorage(), this.optimization, "optimization");
            result.putAll((Map<?, ?>)optimizationProp);
            result.setProperty("optimization", optimizationName);
        } else if (this.propertiesParameters != null && (optimization = this.propertiesParameters.getProperty("optimization")) != null) {
            result.setProperty("optimization", optimization);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "optimization.");
        }
        if (this.optimizationExportsObservations != null) {
            String optimizationExportsList = "";
            int optimizationExportIndex = 0;
            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
            for (Map.Entry<Export, Observation> exportObservationEntry : this.optimizationExportsObservations.entrySet()) {
                Export export = exportObservationEntry.getKey();
                optimizationExportsList = optimizationExportsList + ExportStorage.getName(export) + ",";
                Observation observation = exportObservationEntry.getValue();
                if (observation != null) {
                    result.setProperty("optimizationobservation." + optimizationExportIndex, beanUtils.convert((Object)observation));
                }
                ++optimizationExportIndex;
            }
            result.setProperty("optimizationexports", optimizationExportsList);
        } else if (this.propertiesParameters != null) {
            String optimizationExports = this.propertiesParameters.getProperty("optimizationexports");
            if (optimizationExports != null) {
                result.setProperty("optimizationexports", optimizationExports);
            }
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "optimizationobservation.");
        }
        String exportList = StringUtils.join(this.getExportNames(), (String)",");
        result.setProperty("exports", exportList);
        result.setProperty("numberOfSensitivitySimulation", String.valueOf(this.getNumberOfSensitivitySimulation()));
        if (this.sensitivityAnalysis != null) {
            String analysisName = SensitivityAnalysisStorage.getName(this.getSensitivityAnalysis());
            result.setProperty("sensitivityanalysis", analysisName);
            Properties analysisParams = StorageHelper.getParamsAsProperties(0, this.getRegion().getStorage(), this.getSensitivityAnalysis(), "sensitivity");
            result.putAll((Map<?, ?>)analysisParams);
        } else if (this.propertiesParameters != null && (sensitivityanalysis = this.propertiesParameters.getProperty("sensitivityanalysis")) != null) {
            result.setProperty("sensitivityanalysis", sensitivityanalysis);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "sensitivity.");
        }
        if (this.sensitivityExports != null) {
            String sensitivityExportList = "";
            int sensitivityExportIndex = 0;
            for (SensitivityExport sensitivityExport : this.getSensitivityExport()) {
                sensitivityExportList = sensitivityExportList + SensitivityExportStorage.getName(sensitivityExport) + ",";
                Properties exportProp = ExportHelper.getSensitivityExportAsProperties(sensitivityExportIndex++, this.getRegion().getStorage(), sensitivityExport);
                result.putAll((Map<?, ?>)exportProp);
            }
            result.setProperty("sensitivityexports", sensitivityExportList);
        } else if (this.propertiesParameters != null && (sensitivityexports = this.propertiesParameters.getProperty("sensitivityexports")) != null) {
            result.setProperty("sensitivityexports", sensitivityexports);
            SimulationParameterPropertiesHelper.copy(this.propertiesParameters, (Properties)result, "sensitivityexport.");
        }
        result.setProperty("sensitivityAnalysisOnlyKeepFirst", String.valueOf(this.isSensitivityAnalysisOnlyKeepFirst()));
        result.setProperty("generatedPreScript", this.getGeneratedPreScript());
        result.setProperty("usePreScript", String.valueOf(this.getUsePreScript()));
        result.setProperty("preScript", this.getPreScript());
        result.setProperty("useSimulationPlan", String.valueOf(this.getUseSimulationPlan()));
        result.setProperty("simulationPlanNumber", String.valueOf(this.getSimulationPlanNumber()));
        result.setProperty("useOptimization", String.valueOf(this.getUseOptimization()));
        String resultList = StringUtils.join(this.getResultEnabled(), (String)",");
        result.setProperty("resultNames", resultList);
        for (Map.Entry<String, String> e : this.getTagValue().entrySet()) {
            result.setProperty("tagValue." + e.getKey(), e.getValue());
        }
        result.setProperty("simulLogLevel", this.getSimulLogLevel());
        result.setProperty("scriptLogLevel", this.getScriptLogLevel());
        result.setProperty("libLogLevel", this.getLibLogLevel());
        return result;
    }

    @Override
    public void fromProperties(Properties props) {
        this.propertiesParameters = props;
    }

    @Override
    public void reloadContextParameters() throws TopiaException {
        boolean mustClose = false;
        TopiaContext tx = SimulationContext.get().getDB();
        if (tx == null) {
            tx = this.getRegion().getStorage().beginTransaction();
            mustClose = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reloading rules");
        }
        for (Rule rule : this.getRules()) {
            try {
                for (Field field : rule.getClass().getFields()) {
                    TopiaEntity entity;
                    if (!Modifier.isPublic(field.getModifiers()) || !TopiaEntity.class.isAssignableFrom(field.getType()) || (entity = (TopiaEntity)field.get(rule)) == null) continue;
                    TopiaEntity newEntity = tx.findByTopiaId(entity.getTopiaId());
                    field.set(rule, newEntity);
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't refresh rule field", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't access rule field", (Throwable)e);
            }
        }
        if (mustClose) {
            tx.commitTransaction();
            tx.closeContext();
        }
    }
}

