/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationExportResultWrapper
implements SimulationListener {
    private static Log log = LogFactory.getLog(SimulationExportResultWrapper.class);

    @Override
    public void afterSimulation(SimulationContext context) {
        List<SensitivityExport> sensitivityExports;
        SimulationStorage simulation = context.getSimulationStorage();
        SimulationParameter parameters = simulation.getParameter();
        File rootDirectory = simulation.getDirectory();
        SimulationControl control = context.getSimulationControl();
        ArrayList<Export> allExports = new ArrayList<Export>();
        if (parameters.getExportNames() != null) {
            for (String exportName : parameters.getExportNames()) {
                try {
                    ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                    Export export = (Export)storage.getNewInstance();
                    allExports.add(export);
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't get export instance " + exportName), (Throwable)e);
                }
            }
        }
        if ((sensitivityExports = parameters.getSensitivityExport()) != null) {
            allExports.addAll(sensitivityExports);
        }
        Set<Export> optimizationExports = parameters.getOptimizationExportsObservations().keySet();
        for (Export export : optimizationExports) {
            String exportName = ExportStorage.getName(export);
            if (parameters.getExportNames() != null && parameters.getExportNames().contains(exportName)) continue;
            allExports.add(export);
        }
        if (!allExports.isEmpty()) {
            control.setText(I18n.t((String)"isisfish.message.export.export", (Object[])new Object[0]));
            File exportDir = SimulationStorage.getResultExportDirectory(rootDirectory);
            exportDir.mkdirs();
            ExportHelper.doExport(simulation, exportDir, allExports, rootDirectory);
        }
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }

    @Override
    public void stepChange(SimulationContext context, TimeStep step) {
    }
}

