/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.datastore.ResultStorageAbstract;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

public class ResultStorageInMemory
extends ResultStorageAbstract {
    private static Log log = LogFactory.getLog(ResultStorageInMemory.class);
    public static final String MAX_TIME_STEP = "ResultStorageInMemory.maxTimeStep";
    protected int maxTimeStep = 12;
    LinkedHashMap<TimeStep, Map<String, MatrixND>> data = new LinkedHashMap<TimeStep, Map<String, MatrixND>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > ResultStorageInMemory.this.maxTimeStep;
        }
    };
    LinkedHashMap<TimeStep, List<String>> rules = new LinkedHashMap<TimeStep, List<String>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > ResultStorageInMemory.this.maxTimeStep;
        }
    };

    public ResultStorageInMemory(SimulationStorage simulation) {
        super(simulation);
        this.maxTimeStep = Integer.parseInt(simulation.getParameter().getTagValue().get(MAX_TIME_STEP));
    }

    @Override
    public void delete() {
        super.delete();
        this.data.clear();
    }

    @Override
    protected MatrixND decorate(MatrixND mat, TopiaContext tx) {
        return mat;
    }

    @Override
    protected void writeResult(TimeStep step, String name, MatrixND mat) {
        MatrixND newMat = this.undecorate(mat);
        Map<String, MatrixND> mats = this.data.get(step);
        if (mats == null) {
            mats = new HashMap<String, MatrixND>();
            this.data.put(step, mats);
        }
        mats.put(name, newMat);
    }

    @Override
    protected void writeActiveRule(TimeStep step, String name, String params) {
        List<String> list = this.rules.get(step);
        if (list == null) {
            list = new LinkedList<String>();
            this.rules.put(step, list);
        }
        list.add(name);
    }

    @Override
    public List<String> getResultName() {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, MatrixND> mats : this.data.values()) {
            result.addAll(mats.keySet());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public MatrixND readResult(TimeStep step, String name) {
        MatrixND result = null;
        Map<String, MatrixND> mats = this.data.get(step);
        if (mats != null) {
            result = mats.get(name);
        }
        return result;
    }
}

