/*
 * #%L
 * IsisFish
 * 
 * $Id: IsisCacheBackend.java 3873 2013-12-12 10:20:46Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.1/src/main/java/fr/ifremer/isisfish/util/IsisCacheBackend.java $
 * %%
 * Copyright (C) 2013 Ifremer, Code Lutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.types.TimeStep;

/**
 *
 * @author poussin
 * @version $Revision: 3873 $
 *
 * Last update: $Date: 2013-12-12 11:20:46 +0100 (Thu, 12 Dec 2013) $
 * by : $Author: echatellier $
 */
public interface IsisCacheBackend {

    Object get(TimeStep step, String key) ;

    void put(TimeStep step, String key, Object value);

    void clear() ;

    void removeStep(Object key);

    /**
     * get specific backend cache statistic
     * @return backend specific string cache stat representation
     */
    String getStat();

    static public interface Factory {
        IsisCacheBackend createNew();
    }

}
