package fr.ifremer.isisfish.ui.script;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ImportDialogUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BOTH_EMPTY = "bothEmpty";
    public static final String PROPERTY_CONFLICT_FILES_TABLE_MODEL = "conflictFilesTableModel";
    public static final String PROPERTY_CONFLICT_ITEM_EMPTY = "conflictItemEmpty";
    public static final String PROPERTY_NEW_FILES_TABLE_MODEL = "newFilesTableModel";
    public static final String PROPERTY_NEW_ITEM_EMPTY = "newItemEmpty";
    public static final String PROPERTY_OK_ENABLED = "okEnabled";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHECK_ALL_CHECKBOX_ENABLED = "checkAllCheckbox.enabled";
    public static final String BINDING_CONFLICT_FILES_LABEL_VISIBLE = "conflictFilesLabel.visible";
    public static final String BINDING_NEW_FILES_LABEL_VISIBLE = "newFilesLabel.visible";
    public static final String BINDING_OK_BUTTON_ENABLED = "okButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_VISIBLE = "$JScrollPane0.visible";
    private static final String BINDING_$JSCROLL_PANE1_VISIBLE = "$JScrollPane1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRSeuHUSJ2loE5q2kEpOaxUK6TqJFAmUCpqkibBxaVUHKcIXxrtj7zTjne3s22RDBeIn8BNAXLkgceOEOHDmwAXxFxDiwBXxZtf2dh1nvcI5jJ15733zve/tfOvv/iR5T5GVZzQIDOU7wDvMqG4fHj5uPmMmPGSeqbgLUpHobyJHcg0ya/X3PSC3GzVdXu6Wl3dlx5UOc16q3qqRGQ9OBfNsxgDIzWSF6Xnlej+8Fbi+6qH2SQ1D/frvv3JfWV9+kyMkcJHdq9hKcVRV3MnFGslxC8gCnnRMy4I6baShuNNGvpf03q6gnvcR7bDn5AsyVSOTLlUIBuRW9pZDjLA+cIEUStWHnArZXgOy2lIGbynWYfjpca/FPdvwuRFBGBXEVBBlf1xx3RBkEuk67GSfo1gHtCnYI2kxAWQzHUvn15nAkXLpxHUx6DVTOi3BTRhA1uH5OK0gj/YcHUTZrmiFDK2asSOlYNSJ8+aQYwVYZ6/jwqneW4xjV3pHnZdQaEqwhwWmSiExlO56YsreCc7MCGM6szBYsK7/XdbLa/3QpZ6KNdrUAi7oboIuVDXc1Jk344JStW4qKcQT6mgK1xIFcWigKjGswWP6lG/F000Mos9jJYVM2F4pmbBwdp468oZe3upnzVJl2vyYPaFgA1lKcmMBFjNhJXWbLlX1mWJtsJdwN5l72bSZebQtxK7+bMoAyNVETbi/IwOdvx4fIY92fADpAFlMpEe7yeQ5kzomE3Ho3W5ckdcTDwmajBGbTOwCEw2SVz5u41PVOOtLTzEUOdL1AUfSgGH036XF337844f9ng3dwLOvDk19yUXRHlwlXaaA66NfiTzIBy7Kj6i71SAFL7yvocUuDyFW74aRHJ4XXUZdbnxAPRsh8lO///Tz0qe/XiC5fTIjJLX2qc6vkALYClWQwgrc9x+EjOZOpnG9rLkBmWlJxdpK+g7e8pUX+AQXQ3R6AmioQqo31zbXV9fXNlY3Njbvfh6gNstDtOkTbBZ++Wex/v2Dnj4TyPfGuemxRvlPyCR3BHdYaNRdDx5qzLOux3xLxl47zH3J4K13u9ayHa57I7W4oJgV+Dq3Erahv31Iht7ZDND5jrSodp77UZNFCvjyafrA3jtzyIReZzKAFnCy/LPedT/8/0B54DA2SKGFl/geEkoDKmYAugjoRmNiTB3jizE04fn7FgVabHLHQl85R+3RkHr7uV7UcITbGUjNUx/kUz2z8H2bgnYnE592ikh3MyGIsRHSNBkf4e1MCC9SEO5lmMs0sziMuEblDDiTNuNtO+3RzYQi6Kn0IaWnjSwXgEU/3VJgNrNIE72YIpxzmhqNM+pRy8JkFvB35wF3D9LNIRuZb1NkeWfsdsZH2EKE/wApiTVvrw0AAA==";
    private static final Log log = LogFactory.getLog(ImportDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField archivePath;
    protected Boolean bothEmpty;
    protected JButton cancelButton;
    protected JCheckBox checkAllCheckbox;
    protected JLabel conflictFilesLabel;
    protected JTable conflictFilesTable;
    protected FileSelectionTableModel conflictFilesTableModel;
    protected Boolean conflictItemEmpty;
    protected JLabel newFilesLabel;
    protected JTable newFilesTable;
    protected FileSelectionTableModel newFilesTableModel;
    protected Boolean newItemEmpty;
    protected JButton okButton;
    protected Boolean okEnabled;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ImportDialogUI $JDialog0 = this;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /*public boolean isOkEnabled() {
            return (!isConflictItemEmpty() && !conflictFilesTableModel.getSelectedFiles().isEmpty()) ||
                    (!isNewItemEmpty() && !newFilesTableModel.getSelectedFiles().isEmpty());
        }*/
    
        public void refresh() {
            setConflictItemEmpty(conflictFilesTableModel.getRowCount() == 0);
            setNewItemEmpty(newFilesTableModel.getRowCount() == 0);
            setBothEmpty(isConflictItemEmpty() && isNewItemEmpty());
            
            setOkEnabled((!isConflictItemEmpty() && !conflictFilesTableModel.getSelectedFiles().isEmpty()) ||
                    (!isNewItemEmpty() && !newFilesTableModel.getSelectedFiles().isEmpty()));
        }
    
        public void doCheckAll() {
            boolean selection = checkAllCheckbox.isSelected();
            newFilesTableModel.setAllChecked(selection);
            conflictFilesTableModel.setAllChecked(selection);
        }
        
        protected void performImport() {
            File archiveFile = new File(archivePath.getText());
            getContextValue(ScriptAction.class).performImportScript(archiveFile, newFilesTableModel, conflictFilesTableModel);
        }
        
        protected void cancel() {
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportDialogUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI() {
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportDialogUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportDialogUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel();
    }

    public void doActionPerformed__on__checkAllCheckbox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheckAll();
    }

    public void doMouseClicked__on__conflictFilesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        refresh();
    }

    public void doMouseClicked__on__newFilesTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        refresh();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getArchivePath() {
        return archivePath;
    }

    public Boolean getBothEmpty() {
        return bothEmpty;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JCheckBox getCheckAllCheckbox() {
        return checkAllCheckbox;
    }

    public JLabel getConflictFilesLabel() {
        return conflictFilesLabel;
    }

    public JTable getConflictFilesTable() {
        return conflictFilesTable;
    }

    public FileSelectionTableModel getConflictFilesTableModel() {
        return conflictFilesTableModel;
    }

    public Boolean getConflictItemEmpty() {
        return conflictItemEmpty;
    }

    public JLabel getNewFilesLabel() {
        return newFilesLabel;
    }

    public JTable getNewFilesTable() {
        return newFilesTable;
    }

    public FileSelectionTableModel getNewFilesTableModel() {
        return newFilesTableModel;
    }

    public Boolean getNewItemEmpty() {
        return newItemEmpty;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public Boolean getOkEnabled() {
        return okEnabled;
    }

    public Boolean isBothEmpty() {
        return bothEmpty !=null && bothEmpty;
    }

    public Boolean isConflictItemEmpty() {
        return conflictItemEmpty !=null && conflictItemEmpty;
    }

    public Boolean isNewItemEmpty() {
        return newItemEmpty !=null && newItemEmpty;
    }

    public Boolean isOkEnabled() {
        return okEnabled !=null && okEnabled;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBothEmpty(Boolean bothEmpty) {
        Boolean oldValue = this.bothEmpty;
        this.bothEmpty = bothEmpty;
        firePropertyChange(PROPERTY_BOTH_EMPTY, oldValue, bothEmpty);
    }

    public void setConflictFilesTableModel(FileSelectionTableModel conflictFilesTableModel) {
        FileSelectionTableModel oldValue = this.conflictFilesTableModel;
        this.conflictFilesTableModel = conflictFilesTableModel;
        firePropertyChange(PROPERTY_CONFLICT_FILES_TABLE_MODEL, oldValue, conflictFilesTableModel);
    }

    public void setConflictItemEmpty(Boolean conflictItemEmpty) {
        Boolean oldValue = this.conflictItemEmpty;
        this.conflictItemEmpty = conflictItemEmpty;
        firePropertyChange(PROPERTY_CONFLICT_ITEM_EMPTY, oldValue, conflictItemEmpty);
    }

    public void setNewFilesTableModel(FileSelectionTableModel newFilesTableModel) {
        FileSelectionTableModel oldValue = this.newFilesTableModel;
        this.newFilesTableModel = newFilesTableModel;
        firePropertyChange(PROPERTY_NEW_FILES_TABLE_MODEL, oldValue, newFilesTableModel);
    }

    public void setNewItemEmpty(Boolean newItemEmpty) {
        Boolean oldValue = this.newItemEmpty;
        this.newItemEmpty = newItemEmpty;
        firePropertyChange(PROPERTY_NEW_ITEM_EMPTY, oldValue, newItemEmpty);
    }

    public void setOkEnabled(Boolean okEnabled) {
        Boolean oldValue = this.okEnabled;
        this.okEnabled = okEnabled;
        firePropertyChange(PROPERTY_OK_ENABLED, oldValue, okEnabled);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createArchivePath() {
        $objectMap.put("archivePath", archivePath = new JTextField());
        
        archivePath.setName("archivePath");
        archivePath.setColumns(15);
        archivePath.setEditable(false);
        SwingUtil.setComponentHeight(archivePath,25);
    }

    protected void createBothEmpty() {
        $objectMap.put("bothEmpty", bothEmpty = false);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("isisfish.script.import.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCheckAllCheckbox() {
        $objectMap.put("checkAllCheckbox", checkAllCheckbox = new JCheckBox());
        
        checkAllCheckbox.setName("checkAllCheckbox");
        checkAllCheckbox.setSelected(true);
        checkAllCheckbox.setText(t("isisfish.script.import.checkAll"));
        checkAllCheckbox.setToolTipText(t("isisfish.script.import.tooltip.checkAll"));
        checkAllCheckbox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__checkAllCheckbox"));
    }

    protected void createConflictFilesLabel() {
        $objectMap.put("conflictFilesLabel", conflictFilesLabel = new JLabel());
        
        conflictFilesLabel.setName("conflictFilesLabel");
        if (conflictFilesLabel.getFont() != null) {
            conflictFilesLabel.setFont(conflictFilesLabel.getFont().deriveFont((float) 12));
        }
        conflictFilesLabel.setText(t("isisfish.script.import.labelOverwrite"));
        conflictFilesLabel.setForeground(new Color(255, 0, 0));
    }

    protected void createConflictFilesTable() {
        $objectMap.put("conflictFilesTable", conflictFilesTable = new JTable());
        
        conflictFilesTable.setName("conflictFilesTable");
        conflictFilesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__conflictFilesTable"));
    }

    protected void createConflictFilesTableModel() {
        $objectMap.put("conflictFilesTableModel", conflictFilesTableModel = null);
    }

    protected void createConflictItemEmpty() {
        $objectMap.put("conflictItemEmpty", conflictItemEmpty = false);
    }

    protected void createNewFilesLabel() {
        $objectMap.put("newFilesLabel", newFilesLabel = new JLabel());
        
        newFilesLabel.setName("newFilesLabel");
        if (newFilesLabel.getFont() != null) {
            newFilesLabel.setFont(newFilesLabel.getFont().deriveFont((float) 12));
        }
        newFilesLabel.setText(t("isisfish.script.import.labelAdd"));
    }

    protected void createNewFilesTable() {
        $objectMap.put("newFilesTable", newFilesTable = new JTable());
        
        newFilesTable.setName("newFilesTable");
        newFilesTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newFilesTable"));
    }

    protected void createNewFilesTableModel() {
        $objectMap.put("newFilesTableModel", newFilesTableModel = null);
    }

    protected void createNewItemEmpty() {
        $objectMap.put("newItemEmpty", newItemEmpty = false);
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(t("isisfish.script.import.import"));
    }

    protected void createOkEnabled() {
        $objectMap.put("okEnabled", okEnabled = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivePath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(newFilesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(conflictFilesLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(newFilesTable);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(conflictFilesTable);
        // inline complete setup of $JPanel0
        $JPanel0.add(checkAllCheckbox);
        $JPanel0.add(okButton);
        $JPanel0.add(cancelButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        newFilesTable.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        conflictFilesTable.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        newFilesLabel.setForeground(new java.awt.Color(051,102,225));
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createNewFilesTableModel();
        createConflictFilesTableModel();
        createOkEnabled();
        createNewItemEmpty();
        createConflictItemEmpty();
        createBothEmpty();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createNewFilesLabel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNewFilesTable();
        createConflictFilesLabel();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createConflictFilesTable();
        createArchivePath();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 3, 2, 2));
        createCheckAllCheckbox();
        createOkButton();
        createCancelButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setResizable(false);
        setTitle(t("isisfish.script.import"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NEW_FILES_LABEL_VISIBLE, true ,"newItemEmpty") {
        
            @Override
            public void processDataBinding() {
                newFilesLabel.setVisible(!isNewItemEmpty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE0_VISIBLE, true ,"newItemEmpty") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane0.setVisible(!isNewItemEmpty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONFLICT_FILES_LABEL_VISIBLE, true ,"conflictItemEmpty") {
        
            @Override
            public void processDataBinding() {
                conflictFilesLabel.setVisible(!isConflictItemEmpty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE1_VISIBLE, true ,"conflictItemEmpty") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane1.setVisible(!isConflictItemEmpty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CHECK_ALL_CHECKBOX_ENABLED, true ,"bothEmpty") {
        
            @Override
            public void processDataBinding() {
                checkAllCheckbox.setEnabled(!isBothEmpty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OK_BUTTON_ENABLED, true ,"okEnabled") {
        
            @Override
            public void processDataBinding() {
                okButton.setEnabled(isOkEnabled());
            }
        });
    }

}